/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.syslog.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SyslogUtil {
    public static String XMLElementToString(Element xmlNode) {
        try {
            StringWriter sw = new StringWriter();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(xmlNode);
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(source, new StreamResult(sw));
            String s = sw.toString();
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String XMLNodeToString(Node xmlNode) {
        try {
            StringWriter sw = new StringWriter();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(xmlNode);
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(source, new StreamResult(sw));
            String s = sw.toString();
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Element StringToXMLElement(String message) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream str = new ByteArrayInputStream(SyslogUtil.stringToAscii(message));
        InputSource is = new InputSource(str);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(is);
        if (doc == null) {
            System.err.println("Document null");
            return null;
        }
        Element el = doc.getDocumentElement();
        if (el == null) {
            System.err.println("Element null");
            return null;
        }
        return el;
    }

    public static String MessageToString(InputStream streamMessage) {
        if (streamMessage != null) {
            int replyLength = 0;
            int bytesRead = 0;
            int maxLength = 0;
            Vector<byte[]> bytesVector = new Vector<byte[]>();
            try {
                byte[] br;
                do {
                    maxLength = streamMessage.available();
                    br = new byte[maxLength];
                    bytesRead = streamMessage.read(br, 0, maxLength);
                    replyLength += bytesRead;
                    if (bytesRead <= 0) continue;
                    bytesVector.add(br);
                } while (bytesRead > 0 || streamMessage.available() > 0);
                if (bytesVector.size() == 1) {
                    br = (byte[])bytesVector.elementAt(0);
                } else if (bytesVector.size() > 1) {
                    int l = 0;
                    br = new byte[replyLength];
                    int i = 0;
                    while (i < bytesVector.size()) {
                        System.arraycopy((byte[])bytesVector.elementAt(i), 0, br, l, ((byte[])bytesVector.elementAt(i)).length);
                        l += ((byte[])bytesVector.elementAt(i)).length;
                        ++i;
                    }
                }
                if (bytesVector.size() > 0) {
                    return SyslogUtil.asciiToString(br, 0, replyLength);
                }
                return null;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContents(File aFile) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            try {
                input = new BufferedReader(new FileReader(aFile));
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        try {}
        catch (IOException ex) {
            ex.printStackTrace();
            return contents.toString();
        }
        if (input == null) return contents.toString();
        input.close();
        return contents.toString();
    }

    /*
     * Exception decompiling
     */
    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 155->159)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String asciiToString(byte[] b, int off, int len) {
        char[] c = new char[len];
        int i = 0;
        while (i < len) {
            c[i] = (char)(b[off + i] & 0xFF);
            ++i;
        }
        return new String(c);
    }

    public static byte[] stringToAscii(String s) {
        byte[] b = new byte[s.length()];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)s.charAt(i);
            ++i;
        }
        return b;
    }

    public static byte[] stringBufferToAscii(StringBuffer s) {
        byte[] b = new byte[s.length()];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)s.charAt(i);
            ++i;
        }
        return b;
    }
}

