/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ohf.hl7v2.core.conformance.CPDocument;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPConformanceProfileComposer;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPDocumentParser;
import org.eclipse.ohf.hl7v2.core.conformance.operations.CPErrors;
import org.eclipse.ohf.hl7v2.core.conformance.operations.CPInternalValidator;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.utilities.OHFException;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.eclipse.ohf.utilities.xml.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CPManager {
    private static InputStream openRead(String filename) throws HL7V2Exception {
        try {
            return new FileInputStream(new File(filename));
        }
        catch (FileNotFoundException e) {
            throw new HL7V2Exception(e, 25);
        }
    }

    private static OutputStream openWrite(String filename) throws HL7V2Exception {
        try {
            return new FileOutputStream(new File(filename));
        }
        catch (FileNotFoundException e) {
            throw new HL7V2Exception(e, 25);
        }
    }

    public static int determineDocumentType(String filename) throws HL7V2Exception {
        return CPManager.determineDocumentType(CPManager.openRead(filename));
    }

    public static int determineDocumentType(InputStream stream) throws HL7V2Exception {
        return 0;
    }

    public static void load(String filename, CPDocument document) throws HL7V2Exception {
        CPManager.load(CPManager.openRead(filename), document);
    }

    public static void load(InputStream stream, CPDocument document) throws HL7V2Exception {
        CPManager.load(stream, document, 0);
    }

    public static void load(String filename, CPDocument document, int expectedType) throws HL7V2Exception {
        CPManager.load(CPManager.openRead(filename), document, expectedType);
    }

    public static void load(InputStream stream, CPDocument document, int expectedType) throws HL7V2Exception {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(stream, (DefaultHandler)new XMLReader((XMLObjectParser)new CPDocumentParser(document)));
        }
        catch (Exception e) {
            throw new HL7V2Exception(e, 25);
        }
        if (expectedType != 0 && document.getDocumentType() != expectedType) {
            throw new HL7V2Exception("", 25);
        }
    }

    public static CPDocument load(String filename) throws HL7V2Exception {
        return CPManager.load(CPManager.openRead(filename));
    }

    public static CPDocument load(InputStream stream) throws HL7V2Exception {
        return CPManager.load(stream, 0);
    }

    public static CPDocument load(String filename, int expectedType) throws HL7V2Exception {
        return CPManager.load(CPManager.openRead(filename), expectedType);
    }

    public static CPDocument load(InputStream stream, int expectedType) throws HL7V2Exception {
        CPDocument result = new CPDocument();
        CPManager.load(stream, result, expectedType);
        return result;
    }

    public static void save(String filename, CPDocument document) throws HL7V2Exception {
        CPManager.save(CPManager.openWrite(filename), document, false);
    }

    public static void save(OutputStream stream, CPDocument document) throws HL7V2Exception {
        CPManager.save(stream, document, false);
    }

    public static void save(OutputStream stream, CPDocument document, boolean stitching) throws HL7V2Exception {
        CPConformanceProfileComposer composer = new CPConformanceProfileComposer();
        composer.setStream(stream);
        composer.setStitching(stitching);
        try {
            composer.compose(document);
        }
        catch (OHFException e) {
            throw new HL7V2Exception(e, 22);
        }
    }

    public static void save(String filename, CPDocument document, boolean stitching) throws HL7V2Exception {
        CPManager.save(CPManager.openWrite(filename), document, stitching);
    }

    public static CPDocument createDocument(int type) throws HL7V2Exception {
        CPDocument result = new CPDocument();
        result.setDocumentType(type);
        result.createContent();
        return result;
    }

    public static void check(CPDocument document, CPErrors errors) {
        CPInternalValidator validator = new CPInternalValidator();
        validator.setDocument(document);
        errors.clear();
        validator.setErrors(errors);
        validator.validate();
    }
}

