/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPInteractions;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPMetaData;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPUseCase;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPConformanceProfile
extends CPElement {
    public static final int PROFILE_TYPE_UNKNOWN = 0;
    public static final int PROFILE_TYPE_HL7 = 1;
    public static final int PROFILE_TYPE_CONSTRAINABLE = 2;
    public static final int PROFILE_TYPE_IMPLEMENTATION = 3;
    private String hl7Version;
    private int profileType;
    private String identifier;
    private CPMetaData metaData = new CPMetaData(this);
    private String implementationNote;
    private CPUseCase useCase;
    private String[] encodings;
    private CPInteractions interactions = new CPInteractions(this);

    public CPConformanceProfile() {
        super(null);
    }

    public void clear() {
        super.clear();
        this.hl7Version = null;
        this.profileType = 0;
        this.identifier = null;
        this.implementationNote = null;
        this.encodings = null;
        this.useCase = new CPUseCase(this);
        this.metaData = new CPMetaData(this);
        this.interactions = new CPInteractions(this);
    }

    public String[] getEncodings() {
        return this.encodings;
    }

    public void setEncodings(String[] encodings) {
        this.encodings = encodings;
    }

    public String getHl7Version() {
        return this.hl7Version;
    }

    public void setHl7Version(String hl7Version) {
        this.hl7Version = hl7Version;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getImplementationNote() {
        return this.implementationNote;
    }

    public void setImplementationNote(String implementationNote) {
        this.implementationNote = implementationNote;
    }

    public int getProfileType() {
        return this.profileType;
    }

    public void setProfileType(int profileType) {
        this.profileType = profileType;
    }

    public CPInteractions getInteractions() {
        return this.interactions;
    }

    public CPMetaData getMetaData() {
        return this.metaData;
    }

    public CPUseCase getUseCase() {
        return this.useCase;
    }

    public void addEncoding(String content) {
        if (this.encodings == null) {
            this.encodings = new String[]{content};
        } else {
            String[] newEncodings = new String[this.encodings.length + 1];
            int i = 0;
            while (i < this.encodings.length) {
                newEncodings[i] = this.encodings[i];
                ++i;
            }
            newEncodings[this.encodings.length] = content;
            this.encodings = newEncodings;
        }
    }

    public void setEncodingsAsString(String value) {
        String[] bits = value.split(",");
        this.encodings = null;
        int i = 0;
        while (i < bits.length) {
            this.addEncoding(bits[i].trim());
            ++i;
        }
    }

    public String getEncodingsAsString() {
        if (this.encodings == null) {
            return "";
        }
        String temp = this.encodings[0];
        int i = 1;
        while (i < this.encodings.length) {
            temp = String.valueOf(temp) + ", " + this.encodings[i];
            ++i;
        }
        return temp;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{28, 44, 11, 15, 16, 17, 18, 1, 37, 45});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 28: {
                return this.getHl7Version();
            }
            case 44: {
                return Integer.toString(this.getProfileType());
            }
            case 11: {
                return this.getIdentifier();
            }
            case 1: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.getMetaData().getProperty(id);
            }
            case 37: {
                return this.getImplementationNote();
            }
            case 45: {
                return this.getEncodingsAsString();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 28: {
                this.setHl7Version(value);
                break;
            }
            case 44: {
                this.setProfileType(Integer.parseInt(value));
            }
            case 11: {
                this.setIdentifier(value);
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.getMetaData().setProperty(id, value);
                break;
            }
            case 37: {
                this.setImplementationNote(value);
                break;
            }
            case 45: {
                this.setEncodingsAsString(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Conformance Profile";
    }

    public int elementType() {
        return 3;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPConformanceProfile src = (CPConformanceProfile)source;
        this.encodings = src.encodings == null ? null : (String[])src.encodings.clone();
        if (src.metaData == null) {
            this.metaData = null;
        } else {
            this.metaData = src.metaData.cloneMetaData();
            this.metaData.setOwner(this);
        }
        if (src.useCase == null) {
            this.useCase = null;
        } else {
            this.useCase = src.useCase.cloneUseCase();
            this.useCase.setOwner(this);
        }
        if (src.interactions == null) {
            this.interactions = null;
        } else {
            this.interactions = src.interactions.cloneInteractions();
            this.interactions.setOwner(this);
        }
        this.hl7Version = src.hl7Version;
        this.profileType = src.profileType;
        this.identifier = src.identifier;
        this.implementationNote = src.implementationNote;
    }

    public CPConformanceProfile cloneConformanceProfile() throws CloneNotSupportedException {
        return (CPConformanceProfile)this.clone();
    }
}

