/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions;

import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventMessageDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageTypeDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class DefinitionHelper {
    private VersionDefnList definitions;
    private static final int TABLE_ID_ORDER_CONTROL_CODES = 119;

    public VersionDefnList getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(VersionDefnList definitions) {
        this.definitions = definitions;
    }

    public String getItemNumber(int hl7Version, String segmentCode, int index) throws HL7V2Exception {
        VersionDefn defn = this.definitions.itemByVersion(hl7Version);
        SegmentDefn segment = defn.getSegments().itemByName(segmentCode);
        FieldDefn field = null;
        if (segment != null) {
            field = segment.getFields().itemByNumber(index);
        }
        if (field == null) {
            return null;
        }
        return Integer.toString(field.getDataElementId());
    }

    public DataTypeDefnList getDataTypes(int hl7Version, String itemNumber) {
        return this.definitions.itemByVersion(hl7Version).getDataTypes();
    }

    public int getLength(int hl7Version, String itemNumber) {
        DataElementDefn elem = this.definitions.itemByVersion(hl7Version).getDataElements().itemById(itemNumber);
        if (elem == null) {
            return 0;
        }
        if (elem.getStructure() != null && elem.getStructure().getComponents().size() > 1) {
            int c = 0;
            int i = 0;
            while (i < elem.getStructure().getComponents().size()) {
                c += elem.getStructure().getComponents().item(i).getDatatype().getLength();
                ++i;
            }
            return c;
        }
        return elem.getLength();
    }

    public TableDefnList getTables(String itemNumber, int hl7Version) {
        return this.definitions.itemByVersion(hl7Version).getTables();
    }

    public EventDefnList getEvents(int hl7Version) {
        return this.definitions.itemByVersion(hl7Version).getEvents();
    }

    public MessageTypeDefnList getMessageTypes(int hl7Version) {
        return this.definitions.itemByVersion(hl7Version).getMessageTypes();
    }

    public MessageStructureDefn getMessageStructure(int hl7Version, String event, String message) {
        EventMessageDefn msgDefn;
        VersionDefn defn = this.definitions.itemByVersion(hl7Version);
        MessageStructureDefn result = null;
        EventDefn evDefn = defn.getEvents().itemByName(event);
        if (evDefn != null && (msgDefn = evDefn.getMessages().itemByMessage(message)) != null) {
            result = msgDefn.getStructure();
        }
        return result;
    }

    public MessageStructureDefnList getMessagesStructures(int hl7Version) {
        return this.definitions.itemByVersion(hl7Version).getMessageStructures();
    }

    public TableItemDefnList getTableItems(int hl7Version, int tableId) {
        return this.definitions.itemByVersion(hl7Version).getTables().itemById(tableId).getItems();
    }

    public TableItemDefnList getOrderControlCodes(int hl7Version) {
        return this.getTableItems(hl7Version, 119);
    }
}

