/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.model;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class VersionDefnList
implements Serializable {
    public static final int hvUnknown = 0;
    public static final int hv20 = 1;
    public static final int hv20D = 2;
    public static final int hv21 = 3;
    public static final int hv22 = 4;
    public static final int hv23 = 5;
    public static final int hv231 = 6;
    public static final int hv24 = 7;
    public static final int hv25 = 8;
    public static final int hv26 = 9;
    public static final int LOW_VERSION = 3;
    public static final int HIGH_VERSION = 9;
    private static final long serialVersionUID = 6902594687222212461L;
    private String name;
    private Vector items = new Vector();

    public static String display(int value) {
        switch (value) {
            case 3: {
                return "2.1";
            }
            case 4: {
                return "2.2";
            }
            case 5: {
                return "2.3";
            }
            case 6: {
                return "2.3.1";
            }
            case 7: {
                return "2.4";
            }
            case 8: {
                return "2.5";
            }
            case 9: {
                return "2.6";
            }
        }
        return null;
    }

    public static boolean isValid(int version) {
        return version >= 3 & version <= 9;
    }

    public static int getVersion(String version) throws HL7V2Exception {
        if (version.equals("2.1")) {
            return 3;
        }
        if (version.equals("2.2")) {
            return 4;
        }
        if (version.equals("2.3")) {
            return 5;
        }
        if (version.equals("2.3.1")) {
            return 6;
        }
        if (version.equals("2.4")) {
            return 7;
        }
        if (version.equals("2.5")) {
            return 8;
        }
        if (version.equals("2.6")) {
            return 9;
        }
        throw new HL7V2Exception("VersionDefn '" + version + "' not recognised", 8);
    }

    public int count() {
        return this.items.size();
    }

    public VersionDefn item(int index) {
        return (VersionDefn)this.items.get(index);
    }

    public VersionDefn itemByVersion(int value) {
        int i = 0;
        while (i < this.count()) {
            if (this.item(i).getVersion() == value) {
                return this.item(i);
            }
            ++i;
        }
        return null;
    }

    public VersionDefn itemByVersion(String code) throws HL7V2Exception {
        int value = VersionDefnList.getVersion(code);
        int i = 0;
        while (i < this.count()) {
            if (this.item(i).getVersion() == value) {
                return this.item(i);
            }
            ++i;
        }
        return null;
    }

    public boolean existsByVersion(int version) {
        return this.itemByVersion(version) != null;
    }

    public void clear() {
        this.items.clear();
    }

    public void add(VersionDefn model) {
        this.items.add(model);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.name;
    }
}

