/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.ComposingOptions;
import org.eclipse.ohf.hl7v2.core.message.ParsingOptions;
import org.eclipse.ohf.hl7v2.core.message.formats.Composer;
import org.eclipse.ohf.hl7v2.core.message.formats.Formats;
import org.eclipse.ohf.hl7v2.core.message.formats.StreamComposer;
import org.eclipse.ohf.hl7v2.core.message.formats.StreamParser;
import org.eclipse.ohf.hl7v2.core.message.formats.VerticalBarComposer;
import org.eclipse.ohf.hl7v2.core.message.formats.VerticalBarParser;
import org.eclipse.ohf.hl7v2.core.message.formats.XMLComposer;
import org.eclipse.ohf.hl7v2.core.message.formats.XMLParser;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.utilities.PreviewStream;

public class MessageManager {
    private static MessageManager globalFactory;
    private VersionDefnList versionDefinitions;

    public static MessageManager getFactory() {
        if (globalFactory == null) {
            globalFactory = new MessageManager();
        }
        return globalFactory;
    }

    public VersionDefnList getVersionDefinitions() {
        return this.versionDefinitions;
    }

    public void setVersionDefinitions(VersionDefnList versionDefinitions) {
        this.versionDefinitions = versionDefinitions;
    }

    public Message createMessage() throws HL7V2Exception {
        return this.createMessage(0);
    }

    public Message createMessage(int version) throws HL7V2Exception {
        if (!this.hasDefinitions()) {
            throw new HL7V2Exception("Unable to operate as no HL7 Definitions have been loaded", 17);
        }
        Message result = new Message();
        result.setDefinitions(this.versionDefinitions);
        if (version != 0) {
            result.setVersion(version);
        }
        return result;
    }

    public Message load(InputStream stream) throws HL7V2Exception {
        return this.load(stream, new ParsingOptions());
    }

    public void load(InputStream stream, Message message) throws HL7V2Exception {
        this.load(stream, message, new ParsingOptions());
    }

    public Message load(InputStream stream, ParsingOptions options) throws HL7V2Exception {
        Message result = new Message();
        this.load(stream, result, options);
        return result;
    }

    public void load(InputStream stream, Message message, ParsingOptions options) throws HL7V2Exception {
        if (!this.hasDefinitions()) {
            throw new HL7V2Exception("Unable to operate as no HL7 Definitions have been loaded", 17);
        }
        message.clear();
        if (message.getDefinitions() == null) {
            message.setDefinitions(this.versionDefinitions);
        }
        StreamParser parser = null;
        int format = options.getFormat();
        if (format == 0) {
            stream = new PreviewStream(stream);
            try {
                format = Formats.determine(stream);
                ((PreviewStream)stream).reset(false);
            }
            catch (IOException e) {
                throw new HL7V2Exception(e, 21);
            }
        }
        if (format == 1) {
            parser = new VerticalBarParser(stream);
        } else if (format == 2) {
            parser = new XMLParser(stream);
        } else {
            throw new HL7V2Exception("Unable to determine message type", 21);
        }
        parser.setOptions(options);
        parser.decode(message);
    }

    public void save(OutputStream stream, Message message) throws HL7V2Exception {
        this.save(stream, message, new ComposingOptions());
    }

    public void save(OutputStream stream, Message message, ComposingOptions options) throws HL7V2Exception {
        int format = options.getFormat();
        if (format == 0) {
            format = message.getDefaultFormat();
        }
        StreamComposer composer = null;
        if (format == 1) {
            composer = new VerticalBarComposer(stream);
        } else if (format == 2) {
            composer = new XMLComposer(stream);
        } else {
            throw new HL7V2Exception("Unable to determine message format", 19);
        }
        ((Composer)composer).compose(message);
    }

    public boolean hasDefinitions() {
        return this.versionDefinitions != null;
    }

    public InputStream convertMessage(Message message, int format) throws HL7V2Exception {
        ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
        ComposingOptions opts = new ComposingOptions();
        opts.setFormat(format);
        this.save(tempOut, message, opts);
        return new ByteArrayInputStream(tempOut.toByteArray());
    }

    public InputStream convertToXML(Message message) throws HL7V2Exception {
        return this.convertMessage(message, 2);
    }

    public InputStream convertToVerticalBar(Message message) throws HL7V2Exception {
        return this.convertMessage(message, 1);
    }
}

