/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.formats;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.ParsingOptions;
import org.eclipse.ohf.hl7v2.core.message.formats.StreamParser;
import org.eclipse.ohf.hl7v2.core.message.formats.VerticalBarOffset;
import org.eclipse.ohf.hl7v2.core.message.formats.VerticalBarParserReader;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Content;
import org.eclipse.ohf.hl7v2.core.message.model.ContentBinary;
import org.eclipse.ohf.hl7v2.core.message.model.ContentEscape;
import org.eclipse.ohf.hl7v2.core.message.model.ContentNull;
import org.eclipse.ohf.hl7v2.core.message.model.ContentText;
import org.eclipse.ohf.hl7v2.core.message.model.Delimiters;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class VerticalBarParser
extends StreamParser {
    private Delimiters delimiters = new Delimiters();
    private VerticalBarParserReader reader = null;

    public VerticalBarParser() {
    }

    public VerticalBarParser(InputStream stream) {
        super(stream);
    }

    public VerticalBarParser(String content, int charset) throws HL7V2Exception {
        super(VerticalBarParser.streamFromString(content, charset));
        this.getOptions().setCharset(charset);
    }

    private static InputStream streamFromString(String content, int charset) throws HL7V2Exception {
        try {
            return new ByteArrayInputStream(content.getBytes(ParsingOptions.getCharsetName(charset)));
        }
        catch (UnsupportedEncodingException e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    public void decode(Message message) throws HL7V2Exception {
        if (this.getOptions().hasCharset()) {
            this.decode(message, this.getOptions().getCharset());
        } else {
            this.decode(message, this.determineCharset());
        }
        message.resolveVariableTypes();
    }

    public void decode(Segment segment) throws HL7V2Exception {
        this.reader = new VerticalBarParserReader(this.getStream(), this.getOptions().getCharsetName());
        segment.clearContent();
        this.readSegment(segment);
    }

    public void decode(Field field) throws HL7V2Exception {
        this.reader = new VerticalBarParserReader(this.getStream(), this.getOptions().getCharsetName());
        field.clearContent();
        this.readField(field);
    }

    public void decode(Component component) throws HL7V2Exception {
        this.reader = new VerticalBarParserReader(this.getStream(), this.getOptions().getCharsetName());
        component.clearContent();
        this.readComponent(component, true);
    }

    private int determineCharset() {
        return 1;
    }

    public void decode(Message message, int charset) throws HL7V2Exception {
        this.reader = new VerticalBarParserReader(this.getStream(), ParsingOptions.getCharsetName(charset));
        message.clear();
        this.preDecode(message);
        this.startTrack(message);
        this.readSegment(message);
        message.bindToMSH();
        while (!(this.reader.isFinished() || this.getOptions().getSegmentLimit() != 0 && this.getOptions().getSegmentLimit() <= message.getSegments().size())) {
            this.readSegment(message);
        }
        this.endTrack(message);
    }

    private void preDecode(Message message) throws HL7V2Exception {
        this.reader.skipEOL();
        String temp = this.reader.read(3);
        this.condition(temp.equals("MSH"), "Found '" + temp + "' looking for 'MSH'", 21);
        this.readDelimiters();
        this.readVersion(message);
        this.reader.reset(true);
    }

    private void readDelimiters() throws HL7V2Exception {
        this.delimiters.setFieldDelimiter(this.reader.read());
        if (this.reader.peek() != this.delimiters.getFieldDelimiter()) {
            this.delimiters.setComponentDelimiter(this.reader.read());
        }
        if (this.reader.peek() != this.delimiters.getFieldDelimiter()) {
            this.delimiters.setRepetitionDelimiter(this.reader.read());
        }
        if (this.reader.peek() != this.delimiters.getFieldDelimiter()) {
            this.delimiters.setEscapeCharacter(this.reader.read());
        }
        if (this.reader.peek() != this.delimiters.getFieldDelimiter()) {
            this.delimiters.setSubComponentDelimiter(this.reader.read());
        }
        this.delimiters.check();
    }

    private void readVersion(Message message) throws HL7V2Exception {
        char del = this.delimiters.getFieldDelimiter();
        int count = 0;
        while (count < 10 && !this.reader.isFinished()) {
            char ch = this.reader.read();
            if (ch != del) continue;
            ++count;
        }
        String version = "";
        while (this.reader.peek() != this.delimiters.getFieldDelimiter() && this.reader.peek() != this.delimiters.getComponentDelimiter() && !this.reader.IsEOL()) {
            version = String.valueOf(version) + this.reader.read();
        }
        message.setVersion(VersionDefnList.getVersion(version));
    }

    private void readSegment(Message message) throws HL7V2Exception {
        Segment segment = new Segment();
        message.getSegments().add(segment);
        this.readSegment(segment);
    }

    private void readSegment(Segment segment) throws HL7V2Exception {
        this.startTrack(segment);
        String code = this.reader.read(3);
        if (!this.reader.isFinished() && !this.reader.IsEOL()) {
            char ch = this.reader.read();
            this.condition(ch == this.delimiters.getFieldDelimiter(), "Expected to find field delimiter after segment code but found " + ch, 21);
        }
        this.condition(Segment.isValidCode(code), "Bad Segment code '" + code + "'", 16);
        segment.setCode(code);
        segment.buildFields();
        int start = 0;
        if (code.equals("MSH") || code.equals("FHS") || code.equals("BHS")) {
            start = 2;
            while (!this.reader.isFinished() && this.reader.peek() != this.delimiters.getFieldDelimiter() && !this.reader.IsEOL()) {
                this.reader.read();
            }
            if (!this.reader.isFinished() && !this.reader.IsEOL()) {
                this.condition(this.reader.read() == this.delimiters.getFieldDelimiter(), "Expected to find field delimiter after " + code + "-2", 21);
            }
            segment.forceField(0).setRawContent(this.delimiters.getFieldDelimiter());
            segment.forceField(1).setRawContent(this.delimiters.forMSH2());
        }
        this.readSegmentContent(segment, start);
        this.endTrack(segment);
    }

    private void readSegmentContent(Segment segment, int cursor) throws HL7V2Exception {
        while (!this.reader.isFinished() && !this.reader.IsEOL()) {
            Field field = segment.forceField(cursor);
            ++cursor;
            this.readField(field);
            if (this.reader.isFinished() || this.reader.IsEOL()) continue;
            this.condition(this.reader.read() == this.delimiters.getFieldDelimiter(), "Expected to find field delimiter", 21);
        }
        if (!this.reader.isFinished()) {
            this.reader.skipEOL();
        }
    }

    private void readField(Field field) throws HL7V2Exception {
        boolean repeat;
        Field focus = field;
        do {
            this.readDataElement(focus);
            boolean bl = repeat = !this.reader.isFinished() && this.reader.peek() == this.delimiters.getRepetitionDelimiter();
            if (!repeat) continue;
            this.reader.read();
            focus = field.addRepeat(false);
        } while (repeat);
    }

    private void readDataElement(Field field) throws HL7V2Exception {
        this.startTrack(field);
        this.readContent(field);
        int cursor = 0;
        if (!this.reader.isFinished() && this.reader.peek() == this.delimiters.getSubComponentDelimiter()) {
            this.readComponent(field.forceComponent(cursor), false);
        }
        while (!this.reader.isFinished() && this.reader.peek() == this.delimiters.getComponentDelimiter()) {
            this.reader.read();
            this.readComponent(field.forceComponent(++cursor), true);
        }
        this.endTrack(field);
    }

    private void readComponent(Component component, boolean readContent) throws HL7V2Exception {
        this.startTrack(component);
        if (readContent) {
            this.readContent(component);
        }
        int cursor = 0;
        this.endTrack(component);
        while (!this.reader.isFinished() && this.reader.peek() == this.delimiters.getSubComponentDelimiter()) {
            this.reader.read();
            Component comp = component.forceComponent(++cursor);
            this.startTrack(comp);
            this.readContent(comp);
            this.endTrack(comp);
        }
    }

    private void readEscape(Cell cell, char first) throws HL7V2Exception {
        ContentEscape content = new ContentEscape(0, null);
        this.startTrack(content);
        StringBuffer sb = new StringBuffer();
        sb.append(first);
        while (!this.reader.isFinished() && this.reader.peek() != this.delimiters.getEscapeCharacter()) {
            sb.append(this.reader.read());
        }
        if (this.reader.isFinished()) {
            throw new HL7V2Exception("unterminated escape " + sb.toString(), 20);
        }
        this.reader.read();
        this.endTrack(content);
        content.setRawText(sb.toString());
        cell.getContents().add(content);
    }

    private void readBinary(Cell cell) throws HL7V2Exception {
        ContentBinary content = new ContentBinary(0);
        this.startTrack(content);
        while (!this.reader.isFinished() && this.reader.peek() != this.delimiters.getEscapeCharacter()) {
            int value = Integer.parseInt("" + this.reader.read() + this.reader.read(), 16);
            content.add(value);
        }
        this.endTrack(content);
        if (this.reader.isFinished()) {
            throw new HL7V2Exception("unterminated binary escape ", 20);
        }
        this.reader.read();
        cell.getContents().add(content);
    }

    private void readContent(Cell cell) throws HL7V2Exception {
        cell.clearContent();
        int o = this.reader.getOffset();
        StringBuffer sb = new StringBuffer();
        while (!(this.reader.isFinished() || this.delimiters.isCellDelimiter(this.reader.peek()) || this.reader.IsEOL())) {
            char ch = this.reader.read();
            if (ch == this.delimiters.getEscapeCharacter()) {
                ch = this.reader.read();
                if (this.delimiters.isDelimiterEscape(ch)) {
                    this.condition(this.reader.read() == this.delimiters.getEscapeCharacter(), "improperly terminated escape sequence", 20);
                    sb.append(this.delimiters.getDelimiterEscapeChar(ch));
                    continue;
                }
                if (ch == 'X') {
                    this.addStringToContent(cell, sb.toString(), o);
                    o = this.reader.getOffset() + 1;
                    sb = new StringBuffer();
                    this.readBinary(cell);
                    continue;
                }
                this.addStringToContent(cell, sb.toString(), o);
                o = this.reader.getOffset() + 1;
                sb = new StringBuffer();
                this.readEscape(cell, ch);
                continue;
            }
            sb.append(ch);
        }
        this.addStringToContent(cell, sb.toString(), o);
    }

    private void addStringToContent(Cell cell, String value, int offset) throws HL7V2Exception {
        if (value != null && !value.equals("")) {
            Content cnt = value.equals("\"\"") ? new ContentNull(0) : new ContentText(0, value);
            Cell c = cell;
            c.getContents().add(cnt);
            if (this.getOptions().isTrackOffsets()) {
                cnt.setUserData(new VerticalBarOffset(offset, this.reader.getOffset() - offset, this.reader.getLineNumber()));
                while (c.hasComponents()) {
                    c = cell.getComponent(0);
                    if (c.getUserData() == null) {
                        int s = ((VerticalBarOffset)cell.getUserData()).getOffset();
                        c.setUserData(new VerticalBarOffset(s, this.reader.getOffset() - s, this.reader.getLineNumber()));
                    }
                    cell = c;
                }
            }
        }
    }

    private void startTrack(Item item) {
        if (this.getOptions().isTrackOffsets()) {
            item.setUserData(new VerticalBarOffset(this.reader.getOffset(), this.reader.getLineNumber()));
        }
    }

    private void endTrack(Item item) {
        if (this.getOptions().isTrackOffsets()) {
            ((VerticalBarOffset)item.getUserData()).end(this.reader.getOffset());
        }
    }
}

