/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public abstract class Content
extends Item {
    protected int index;
    public static final int CONTENT_TYPE_TEXT = 0;
    public static final int CONTENT_TYPE_NULL = 1;
    public static final int ctEscape = 2;
    public static final int ctBinary = 3;

    public Content(int index) {
        this.nodeType = 6;
        this.index = index;
    }

    public abstract String getText();

    public abstract int getContentType();

    public void clearContent() throws HL7V2Exception {
        this.clear();
    }

    public String elementName() throws HL7V2Exception {
        return String.valueOf(this.getOwner().elementName()) + "/" + Integer.toString(this.index);
    }

    public Item.ElementTestResult testIsElement(String name, boolean last) throws HL7V2Exception {
        if (!this.hasOwner()) {
            return new Item.ElementTestResult(this, "", false);
        }
        Item.ElementTestResult result = this.getOwner().testIsElement(name, false);
        if (!result.matches) {
            return new Item.ElementTestResult(this, "", false);
        }
        if (result.tail.equals("")) {
            return new Item.ElementTestResult(this, "", this.index == 1);
        }
        String[] parts = StringUtils.split((String)result.tail, (String)"-", (int)2);
        if (StringUtils.isNumeric((String)parts[0]) && Integer.parseInt(parts[0]) == this.index) {
            if (parts.length == 1) {
                return new Item.ElementTestResult(this, "", true);
            }
            return new Item.ElementTestResult(this, "Content cannot have children", false);
        }
        return new Item.ElementTestResult(this, "", false);
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public abstract Content cloneContent() throws HL7V2Exception;
}

