/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.FieldList;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class Field
extends Cell {
    private transient FieldDefn definition;
    private String specifiedDataType;
    private int repeatIndex;
    private FieldList repeats;

    public Field(int index) throws HL7V2Exception {
        super(index);
        this.nodeType = 4;
    }

    public boolean matches(Item obj, boolean path) throws HL7V2Exception {
        boolean result = super.matches(obj, path);
        if (result) {
            Field other = (Field)obj;
            result = this.equals(other.definition, this.definition) && this.equals(other.specifiedDataType, this.specifiedDataType) && other.repeatIndex == this.repeatIndex && this.matches(other.repeats, this.repeats, false);
        }
        return result;
    }

    private DataElementDefn getDataElementDefinition() {
        if (this.definition != null) {
            return this.definition.getDataElement();
        }
        return null;
    }

    public StructureDefn getStructure() {
        DataElementDefn de = this.getDataElementDefinition();
        if (de != null) {
            return de.getStructure();
        }
        return null;
    }

    public TableDefn getTable() {
        DataElementDefn de = this.getDataElementDefinition();
        if (de != null) {
            return this.definition.getDataElement().getTable();
        }
        return null;
    }

    public DataTypeDefn getDataType() throws HL7V2Exception {
        DataTypeDefn result = null;
        StructureDefn struc = this.getStructure();
        if (struc != null) {
            result = struc.getDataType();
        }
        if ((result == null || result.getName().equals("*")) && this.hasSpecifiedDataType()) {
            result = this.getVersionDefinition().getDataTypes().itemByName(this.specifiedDataType);
        }
        return result;
    }

    public boolean canHaveRepeats() {
        return this.repeatIndex == 0;
    }

    public boolean hasRepeats() throws HL7V2Exception {
        return this.canHaveRepeats() && this.getRepeats().size() > 0;
    }

    public FieldList getRepeats() throws HL7V2Exception {
        this.condition(this.canHaveRepeats(), "this Field cannot have repeats", 19);
        if (this.repeats == null) {
            this.repeats = new FieldList(this);
            this.repeats.setCheckIndexes(false);
        }
        return this.repeats;
    }

    public Field getRepeat(int index) throws HL7V2Exception {
        if (index == 0) {
            return this;
        }
        FieldList repeats = this.getRepeats();
        return repeats.item(index - 1);
    }

    public Field addRepeat(boolean firstIfEmpty) throws HL7V2Exception {
        FieldList repeats = this.getRepeats();
        if (firstIfEmpty && !this.hasContent()) {
            return this;
        }
        Field result = new Field(this.getIndex());
        result.repeatIndex = repeats.size() + 1;
        repeats.add(result);
        result.setOwner(this.getOwner());
        result.definition = this.definition;
        result.makeForBuild();
        return result;
    }

    public void makeForBuild() throws HL7V2Exception {
        StructureDefn struc = this.getStructure();
        if (struc != null) {
            int i = 0;
            while (i < struc.getComponents().size()) {
                Component child = this.forceComponent(i);
                child.setDefinition(struc.getComponents().item(i));
                child.makeForBuild();
                ++i;
            }
        }
    }

    public boolean hasSpecifiedDataType() {
        return this.specifiedDataType != null && !this.specifiedDataType.equals("");
    }

    public String getSpecifiedDataType() {
        return this.specifiedDataType;
    }

    public void setSpecifiedDataType(String specifiedDataType) {
        this.specifiedDataType = specifiedDataType;
    }

    public FieldDefn getDefinition() {
        return this.definition;
    }

    public void setDefinition(FieldDefn definition) {
        this.definition = definition;
    }

    public int getRepeatIndex() {
        return this.repeatIndex;
    }

    public boolean hasRepeat(int i) throws HL7V2Exception {
        return i == 0 || this.hasRepeats() && this.repeats.size() >= i - 1;
    }

    public Item.ElementTestResult testIsElement(String name, boolean last) throws HL7V2Exception {
        if (!this.hasOwner()) {
            return new Item.ElementTestResult(this, "", false);
        }
        Item.ElementTestResult result = this.getOwner().testIsElement(name, false);
        if (!result.matches) {
            return new Item.ElementTestResult(this, "", false);
        }
        if (result.tail.equals("")) {
            return new Item.ElementTestResult(this, "", false);
        }
        String[] parts = StringUtils.split((String)result.tail, (String)"-", (int)2);
        String[] bits = StringUtils.split((String)parts[0], (String)":", (int)2);
        if (StringUtils.isNumeric((String)bits[0]) && Integer.parseInt(bits[0]) == this.index && (bits.length == 1 || StringUtils.isNumeric((String)bits[1]) && Integer.parseInt(bits[1]) == this.repeatIndex)) {
            if (parts.length == 1) {
                return new Item.ElementTestResult(this, "", true);
            }
            if (!last) {
                return new Item.ElementTestResult(this, parts[1], true);
            }
            boolean ok = true;
            Cell cell = this;
            do {
                ok = StringUtils.isNumeric((String)(parts = StringUtils.split((String)parts[1], (String)"-", (int)2))[0]) && Integer.parseInt(parts[0]) == 1 && cell.getComponentCount() >= 1;
                cell = ok ? cell.getComponent(0) : null;
            } while (ok && parts.length == 2);
            return new Item.ElementTestResult(this, "", ok);
        }
        return new Item.ElementTestResult(this, "", false);
    }

    public String elementName() throws HL7V2Exception {
        if (this.repeatIndex > 0 || this.hasRepeats()) {
            return String.valueOf(this.getOwner().elementName()) + "-" + Integer.toString(this.index) + ":" + Integer.toString(this.repeatIndex);
        }
        return String.valueOf(this.getOwner().elementName()) + "-" + Integer.toString(this.index);
    }

    public int getRepeatCount() {
        return this.repeats == null ? 1 : this.repeats.size() + 1;
    }

    public int getNonEmptyCount() throws HL7V2Exception {
        int result = this.hasContent() ? 1 : 0;
        int i = 0;
        while (i < this.getRepeats().size()) {
            if (this.getRepeats().itemCell(i).hasContent()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    protected int getSubComponentType() {
        return 5;
    }

    public Segment getSegment() {
        return (Segment)(this.repeatIndex == 0 ? this.getOwner().getOwner() : this.getOwner().getOwner().getOwner());
    }

    public Field getMaster() {
        if (this.repeatIndex == 0) {
            return this;
        }
        return (Field)this.getOwner().getOwner();
    }

    protected void assignDefinition(Component component) {
        if (this.definition != null && component.index <= this.definition.getDataElement().getStructure().getComponents().size()) {
            component.setDefinition(this.definition.getDataElement().getStructure().getComponents().item(component.index - 1));
        }
    }
}

