/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.message.model.ModelProvider;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public abstract class Item
extends Worker {
    public static final int NODE_TYPE_LIST = 1;
    public static final int NODE_TYPE_MESSAGE = 2;
    public static final int NODE_TYPE_SEGMENT = 3;
    public static final int NODE_TYPE_FIELD = 4;
    public static final int NODE_TYPE_COMPONENT = 5;
    public static final int NODE_TYPE_SUBCOMPONENT = 6;
    public static final int NODE_TYPE_CONTENT = 6;
    private Item owner;
    private Object userData;
    protected int nodeType;

    public Item() {
    }

    public Item(Item owner) {
        this.setOwner(owner);
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public Item getOwner() {
        return this.owner;
    }

    public void setOwner(Item owner) {
        this.owner = owner;
    }

    public boolean matches(Item other, boolean path) throws HL7V2Exception {
        return other != null && other instanceof Item && other.nodeType == this.nodeType && (!path || this.elementName().equals(other.elementName()));
    }

    protected boolean equals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    protected boolean matches(Item obj1, Item obj2, boolean path) throws HL7V2Exception {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.matches(obj2, path);
    }

    protected boolean equals(int int1, int int2) {
        return int1 == int2;
    }

    public VersionDefn getVersionDefinition() {
        Item temp = this;
        while (temp != null && !(temp instanceof ModelProvider)) {
            temp = temp.getOwner();
        }
        if (temp == null) {
            return null;
        }
        return temp.getVersionDefinition();
    }

    public abstract void clear() throws HL7V2Exception;

    public abstract void clearContent() throws HL7V2Exception;

    public abstract String elementName() throws HL7V2Exception;

    protected abstract ElementTestResult testIsElement(String var1, boolean var2) throws HL7V2Exception;

    public boolean isElement(String name) throws HL7V2Exception {
        ElementTestResult result = this.testIsElement(name, true);
        return result.matches;
    }

    public final Object getUserData() {
        return this.userData;
    }

    public final void setUserData(Object userData) {
        this.userData = userData;
    }

    public final int getType() {
        return this.nodeType;
    }

    protected class ElementTestResult {
        protected String tail;
        protected boolean matches;

        protected ElementTestResult(String tail, boolean matches) {
            this.tail = tail;
            this.matches = matches;
        }

        protected ElementTestResult() {
        }
    }
}

