/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.definitions.DefinitionManager;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.FieldList;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class Segment
extends Item {
    private String code = "";
    private transient SegmentDefn definition = null;
    private FieldList fields = new FieldList(this);

    public Segment() {
        this.nodeType = 3;
    }

    public boolean matches(Item obj, boolean path) throws HL7V2Exception {
        boolean result = super.matches(obj, path);
        if (result) {
            Segment other = (Segment)obj;
            result = this.equals(other.code, this.code) && this.equals(other.definition, this.definition) && other.fields.matches(this.fields, false);
        }
        return result;
    }

    public void setOwner(Item owner) {
        super.setOwner(owner);
        this.checkDefinition();
    }

    public SegmentDefn getDefinition() {
        return this.definition;
    }

    public String getCode() {
        return this.code;
    }

    public static boolean isValidCode(String code) {
        return code.length() == 3 && Character.isLetter(code.charAt(0)) && Character.isLetterOrDigit(code.charAt(1)) && Character.isLetterOrDigit(code.charAt(2));
    }

    public void setCode(String code) throws HL7V2Exception {
        if (code == null) {
            code = "";
        }
        this.code = code;
        this.checkDefinition();
    }

    private void checkDefinition() {
        VersionDefn model = this.getVersionDefinition();
        this.definition = model != null && this.code != "" ? model.getSegments().itemByName(this.code) : null;
    }

    public Item.ElementTestResult testIsElement(String name, boolean last) throws HL7V2Exception {
        Item.ElementTestResult result = this.hasOwner() ? this.getOwner().testIsElement(name, false) : new Item.ElementTestResult(name, false);
        String[] parts = StringUtils.split((String)result.tail, (String)"-", (int)2);
        result.tail = parts.length == 2 ? parts[1] : "";
        result.matches = parts[0].length() == 3 ? this.code.equals(parts[0]) : (parts[0].length() > 4 ? this.code.equals(parts[0].substring(0, 3)) && parts[0].charAt(3) == ':' && StringUtils.isNumeric((String)parts[0].substring(4)) && ((SegmentList)this.getOwner()).indexByCode(this) == Integer.parseInt(parts[0].substring(4)) - 1 : false);
        return result;
    }

    public void clear() {
        this.fields.clear();
        this.code = "";
        this.definition = null;
    }

    public void clearContent() throws HL7V2Exception {
        this.fields.clearContent();
    }

    public Cell getElement(String path) throws NumberFormatException, HL7V2Exception {
        String[] parts = StringUtils.split((String)path, (String)"-", (int)2);
        int[] indexes = new int[2];
        this.readElementPath(path, parts, indexes);
        if (indexes[0] >= this.fields.size()) {
            return null;
        }
        Field de = this.fields.item(indexes[0]);
        if (indexes[1] > 0) {
            de = de.hasRepeat(indexes[1]) ? de.getRepeat(indexes[1]) : null;
        }
        if (de == null) {
            return null;
        }
        if (parts.length == 1) {
            return de;
        }
        return de.getElement(parts[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readElementPath(String path, String[] parts, int[] indexes) throws NumberFormatException, HL7V2Exception {
        indexes[1] = 0;
        if (parts[0].indexOf(":") > 0) {
            String[] bits = StringUtils.split((String)parts[0], (String)":", (int)2);
            if (!StringUtils.isNumeric((String)bits[0])) {
                throw new HL7V2Exception("Illegal Path " + path, 19);
            }
            indexes[0] = Integer.parseInt(bits[0]) - 1;
            if (!StringUtils.isNumeric((String)bits[1])) throw new HL7V2Exception("Illegal Path " + path, 19);
            indexes[1] = Integer.parseInt(bits[1]);
            return;
        } else {
            if (!StringUtils.isNumeric((String)parts[0])) throw new HL7V2Exception("Illegal Path " + path, 19);
            indexes[0] = Integer.parseInt(parts[0]) - 1;
        }
    }

    public Cell forceElement(String path) throws NumberFormatException, HL7V2Exception {
        String[] parts = StringUtils.split((String)path, (String)"-", (int)2);
        int[] indexes = new int[2];
        this.readElementPath(path, parts, indexes);
        this.forceField(indexes[0]);
        Field de = this.fields.item(indexes[0]);
        if (indexes[1] > 0) {
            while (!de.hasRepeat(indexes[1])) {
                de.addRepeat(false);
            }
            de = de.getRepeat(indexes[1]);
        }
        if (parts.length == 1) {
            return de;
        }
        return de.forceElement(parts[1]);
    }

    public Field forceField(int index) throws HL7V2Exception {
        while (index >= this.fields.size()) {
            this.addField();
        }
        return this.fields.item(index);
    }

    public Field addField() throws HL7V2Exception {
        Field de = new Field(this.fields.size() + 1);
        this.fields.add(de);
        if (this.getDefinition() != null && de.getIndex() <= this.getDefinition().getFields().size()) {
            de.setDefinition(this.getDefinition().getFields().item(de.getIndex() - 1));
        }
        return de;
    }

    public int index() throws HL7V2Exception {
        return ((SegmentList)this.getOwner()).indexOfItem(this);
    }

    public void buildFields() throws HL7V2Exception {
        this.checkDefinition();
        if (this.definition != null) {
            int i = 0;
            while (i < this.definition.getFields().size()) {
                Field de = (Field)this.forceElement(String.valueOf(i + 1));
                de.setSpecifiedDataType(null);
                de.setDefinition(this.definition.getFields().item(i));
                de.makeForBuild();
                ++i;
            }
        }
    }

    public String elementName() throws HL7V2Exception {
        if (this.getOwner() == null || ((SegmentList)this.getOwner()).countByCode(this.code) == 0) {
            return this.code;
        }
        int index = ((SegmentList)this.getOwner()).indexByCode(this) + 1;
        return String.valueOf(this.code) + ":" + Integer.toString(index);
    }

    public FieldList getFields() {
        return this.fields;
    }

    public boolean matches(String mask) {
        if (mask.equals("")) {
            mask = "*";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < (mask.length() > this.code.length() ? mask.length() : this.code.length())) {
            if (i >= mask.length()) {
                sb.append(this.code.charAt(i));
            } else if (mask.charAt(i) == '?') {
                sb.append('?');
            } else {
                if (mask.charAt(i) == '*') {
                    sb.append('*');
                    break;
                }
                if (i <= this.code.length()) {
                    sb.append(this.code.charAt(i));
                }
            }
            ++i;
        }
        return mask.equals(sb.toString());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.definition == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.definition.getPath());
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String defn = in.readUTF();
        if (defn.equals("")) {
            this.definition = null;
        } else {
            try {
                this.definition = (SegmentDefn)DefinitionManager.getByPath(defn);
            }
            catch (HL7V2Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        in.defaultReadObject();
        this.fields.setOwner(this);
    }

    public Message getMessage() {
        Item owner = this.getOwner();
        while (owner != null) {
            if (owner instanceof Message) {
                return (Message)owner;
            }
            owner = owner.getOwner();
        }
        return null;
    }

    public void removeField() throws HL7V2Exception {
        if (this.fields.size() <= 1) {
            throw new HL7V2Exception("Unable to remove fields - at least one must exist", 19);
        }
        this.fields.remove(this.fields.size() - 1);
    }
}

