/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.utilities;

import org.eclipse.ohf.utilities.Iso8601Date;

public class HL7V2DateUtilities
extends Iso8601Date {
    public String checkDateByType(String content, String datatype, int version) {
        return this.checkDateByType(content, datatype, version, 2);
    }

    public String checkDateByType(String content, String datatype, int version, int timezone) {
        if (datatype == null) {
            return null;
        }
        if (datatype.equals("DT")) {
            if (version < 5) {
                return this.parse(content, "YYYYMMDD", 3);
            }
            return this.parse(content, "YYYYYMM[DD]", 3);
        }
        if (datatype.equals("TM")) {
            if (version < 5) {
                return this.parse(content, "HHNN[SS[.UUUU]]", timezone);
            }
            return this.parse(content, "HH[NN[SS[.U[U[U[U]]]]]]", timezone);
        }
        if (datatype.equals("TS")) {
            if (version < 8) {
                return this.parse(content, "YYYY[MM[DD[HHNN[SS[.U[U[U[U]]]]]]]]", timezone);
            }
            return this.parse(content, "YYYY[MM[DD[HH[NN[SS[.U[U[U[U]]]]]]]]]", timezone);
        }
        if (datatype.equals("DTM")) {
            return this.parse(content, "YYYY[MM[DD[HH[NN[SS[.U[U[U[U]]]]]]]]]", timezone);
        }
        return null;
    }
}

