/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pix.consumer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.ParsingOptions;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.Client;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerException;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerQuery;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerResponse;

public class PixConsumer
extends Client {
    private static Logger logger;
    private static final String MSH_CONTROL_ID = "MSH-10";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.pix.consumer.PixConsumer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public PixConsumer() throws ClientException {
    }

    public PixConsumer(InputStream conformanceProfile) throws ClientException {
        super(conformanceProfile);
    }

    public PixConsumerQuery createQuery(String patientId) throws PixConsumerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixConsumer: createQuery - Entry patientId: " + patientId));
        }
        PixConsumerQuery query = new PixConsumerQuery(this.getMessageManager(), this.getCPProfile(), patientId);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = query.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixConsumer: createQuery - Exit patientId: " + patientId + " controlId: " + controlId));
        }
        return query;
    }

    public PixConsumerQuery createQuery(String patientId, String namespaceId, String universalId, String universalIdType) throws PixConsumerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixConsumer: createQuery - Entry patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType));
        }
        PixConsumerQuery query = new PixConsumerQuery(this.getMessageManager(), this.getCPProfile(), patientId, namespaceId, universalId, universalIdType);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = query.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixConsumer: createQuery - Exit patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " controlId: " + controlId));
        }
        return query;
    }

    public String sendQuery(String rawHL7, boolean verify) throws PixConsumerException {
        String queryResponse = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixConsumer: sendQuery - Exit ");
        }
        try {
            queryResponse = this.sendHL7(rawHL7, verify, "OHF_PixConsumer");
        }
        catch (ClientException e) {
            throw new PixConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixConsumer: sendQuery - Exit ");
        }
        return queryResponse;
    }

    public Message sendQuery(Message msg, boolean verify) throws PixConsumerException {
        Message queryResponse = null;
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixConsumer: sendQuery - Entry controlId: " + controlId + " run verification? " + verify + " user: " + PixPdqMessageUtilities.getAuditUser()));
        }
        try {
            queryResponse = this.sendMsg(msg, verify, "OHF_PixConsumer");
        }
        catch (ClientException e) {
            throw new PixConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixConsumer: sendQuery - Exit controlId: " + controlId));
        }
        return queryResponse;
    }

    public PixConsumerResponse sendQuery(PixConsumerQuery msg, boolean verify) throws PixConsumerException {
        String hl7;
        PixConsumerResponse queryResponse = new PixConsumerResponse(this.getMessageManager());
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixConsumer: sendQuery - Entry controlId: " + controlId + " run verification? " + verify + " user: " + PixPdqMessageUtilities.getAuditUser()));
        }
        try {
            Message msgResponse = this.sendMsg((Message)msg, verify, "OHF_PixConsumer");
            hl7 = PixPdqMessageUtilities.msgToString((Message)msgResponse);
        }
        catch (ClientException e) {
            throw new PixConsumerException(e);
        }
        catch (PixPdqMessageException e) {
            throw new PixConsumerException(e);
        }
        queryResponse = new PixConsumerResponse(MessageManager.getFactory());
        ByteArrayInputStream inStream = new ByteArrayInputStream(hl7.getBytes());
        ParsingOptions pOptions = new ParsingOptions();
        try {
            pOptions.setFormat(1);
            if (hl7.compareTo("") == 0) {
                return queryResponse;
            }
            MessageManager.getFactory().load((InputStream)inStream, (Message)queryResponse, pOptions);
            queryResponse.init();
        }
        catch (HL7V2Exception e) {
            logger.error((Object)"PixConsumer: sendQuery - createQueryResponse HL7V2Exception ", (Throwable)e);
            throw new PixConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixConsumer: sendQuery - Exit controlId: " + controlId));
        }
        return queryResponse;
    }
}

