/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.IdentifiableType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.util.RimResourceFactoryImpl;
import org.eclipse.ohf.ihe.xds.metadata.FolderType;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0FolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.FolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;

public class EbXML_3_0InputStreamFolderExtractor
implements FolderExtractor {
    public static final String DESCRIPTOR = "EBXML_3_0_STREAM_FOL_EXTR";
    private static final Logger logger;
    private InputStream ebXMLFolderInputStream;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0InputStreamFolderExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public EbXML_3_0InputStreamFolderExtractor(InputStream ebXMLFolderInputStream) {
        this.ebXMLFolderInputStream = ebXMLFolderInputStream;
    }

    public FolderType extract() throws MetadataExtractionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading RimPackage.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading Resources.");
        }
        Resource resource = new RimResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0"));
        try {
            resource.load(this.ebXMLFolderInputStream, null);
        }
        catch (IOException e) {
            logger.error((Object)"IOException while loading Resources from InputStream.", (Throwable)e);
            throw new MetadataExtractionException("IOException while loading Resources from InputStream.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Parsing ebXML InputStream contents.");
        }
        EList list = resource.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        RegistryPackageType folderData = null;
        AssociationType1[] associationData = null;
        if (root.getRegistryPackage() != null) {
            folderData = root.getRegistryPackage();
        } else if (root.getRegistryObjectList() != null) {
            if (root.getRegistryObjectList().getIdentifiable() != null) {
                boolean foundRegistryPackage = false;
                ArrayList<AssociationType1> associations = new ArrayList<AssociationType1>();
                Iterator i = root.getRegistryObjectList().getIdentifiable().iterator();
                while (i.hasNext()) {
                    IdentifiableType ident = (IdentifiableType)i.next();
                    if (ident instanceof RegistryPackageType && !foundRegistryPackage) {
                        folderData = (RegistryPackageType)ident;
                        foundRegistryPackage = true;
                        continue;
                    }
                    if (!(ident instanceof AssociationType1)) continue;
                    associations.add((AssociationType1)ident);
                }
                if (!foundRegistryPackage || associations.size() == 0) {
                    logger.error((Object)"Malformed InputStream: InputStream must contain a single RegistryPackage or a single LeafRegistryObjectList containing a single RegistryPackage and one or more Associations. Extraction cannot proceed.");
                    throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single RegistryPackage or a single LeafRegistryObjectList containing a single RegistryPackage and one or more Associations. Extraction cannot proceed.");
                }
            }
        } else {
            logger.error((Object)"Malformed InputStream: InputStream must contain a single RegistryPackage or a single LeafRegistryObjectList containing a single RegistryPackage and one or more Associations. Extraction cannot proceed.");
            throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single RegistryPackage or a single LeafRegistryObjectList containing a single RegistryPackage and one or more Associations. Extraction cannot proceed.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating Folder metadata with object from InputStream " + this.ebXMLFolderInputStream));
        }
        EbXML_3_0FolderExtractor fExtractor = new EbXML_3_0FolderExtractor(folderData, associationData);
        FolderType folder = fExtractor.extract();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Unloading Resources.");
        }
        resource.unload();
        return folder;
    }
}

