/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.atna;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.common.atna.NoSecurityDomainException;
import org.eclipse.ohf.ihe.common.atna.SecurityDomain;
import org.eclipse.ohf.ihe.common.atna.SecurityDomainException;

public class ConfigurationManager {
    private static final Logger logger;
    private static boolean TLSEnabled;
    private static boolean nonTLSConnectionsPermitted;
    private static ConfigurationManager SINGLETON;
    private static Map securityDomains;
    private static Map uriToSecurityDomain;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.common.atna.ConfigurationManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        TLSEnabled = true;
        nonTLSConnectionsPermitted = true;
        SINGLETON = null;
        securityDomains = null;
        uriToSecurityDomain = null;
        uriToSecurityDomain = Collections.synchronizedMap(new HashMap());
        securityDomains = Collections.synchronizedMap(new HashMap());
        SINGLETON = new ConfigurationManager();
    }

    private ConfigurationManager() {
        if (SINGLETON == null) {
            SINGLETON = this;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing ATNA ConfigurationManager");
        }
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"KeyStore information has been detected in the system environment variables. Creating a default security domain with them.");
            }
            try {
                SecurityDomain domain = new SecurityDomain(SecurityDomain.DEFAULT_SECURITY_DOMAIN, System.getProperties());
                ConfigurationManager.registerDefaultSecurityDomain(domain);
            }
            catch (SecurityDomainException securityDomainException) {
                logger.error((Object)"Error initializing default keystore. No default SecurityDomain defined.");
            }
        }
    }

    public static void registerSecurityDomain(SecurityDomain securityDomain) {
        securityDomains.put(securityDomain.getName(), securityDomain);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Security Domain " + securityDomain.getName() + " has been successfully registered to the configuration manager."));
        }
    }

    public static void registerDefaultSecurityDomain(SecurityDomain securityDomain) {
        securityDomains.put(SecurityDomain.DEFAULT_SECURITY_DOMAIN, securityDomain);
        ConfigurationManager.registerSecurityDomain(securityDomain);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Security domain " + securityDomain.getName() + " has been successfully registered as the Default security domain."));
        }
    }

    public static void registerURItoSecurityDomain(URI uri, String name) throws NoSecurityDomainException {
        if (uri == null) {
            throw new IllegalArgumentException("URI parameter cannot be null");
        }
        if (!securityDomains.containsKey(name)) {
            throw new IllegalArgumentException("Security domain " + name + " is not a configured security domain.");
        }
        if (uriToSecurityDomain.containsKey(uri)) {
            uriToSecurityDomain.remove(uri);
        }
        uriToSecurityDomain.put(uri, name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Security domain " + name + " has been registered for URI " + uri.toString()));
        }
    }

    public static void unregisterURItoSecurityDomain(URI uri) {
        uriToSecurityDomain.remove(uri);
    }

    public static SecurityDomain getSecurityDomain(String name) {
        return (SecurityDomain)securityDomains.get(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecurityDomain getSecurityDomain(URI uri) throws NoSecurityDomainException {
        SecurityDomain domain;
        String name = (String)uriToSecurityDomain.get(uri);
        if (name == null) {
            logger.debug((Object)("No explicit Security Domain was registered for URI " + uri.toString()));
            if (!securityDomains.containsKey(SecurityDomain.DEFAULT_SECURITY_DOMAIN)) throw new NoSecurityDomainException(uri, "No DEFAULT Security Domain available for URI " + uri.toString());
            name = SecurityDomain.DEFAULT_SECURITY_DOMAIN;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Default Security Domain [" + name + "] has been found and will be used for URI " + uri.toString()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Security Domain [" + name + "] has been found and will be used for URI " + uri.toString()));
        }
        if ((domain = (SecurityDomain)securityDomains.get(name)) == null) {
            String msg = "Security Domain [" + name + "] was set for URI " + uri.toString() + " but it could not be located in the set of registered domains.";
            logger.error((Object)msg);
            throw new NoSecurityDomainException(uri, msg);
        }
        if (!logger.isDebugEnabled()) return domain;
        logger.debug((Object)("Security Domain [" + name + "] successfully retrieved."));
        return domain;
    }

    public static Set getRegisteredSecurityDomains() {
        return Collections.unmodifiableSet(securityDomains.keySet());
    }

    public static boolean isTLSEnabled() {
        return TLSEnabled;
    }

    public static void setTLSEnabled(boolean enabletls) {
        TLSEnabled = enabletls;
    }

    public static boolean isNonTLSConnectionsPermitted() {
        return nonTLSConnectionsPermitted;
    }

    public static void setNonTLSConnectionsPermitted(boolean nonTLSConnectionsPermitted) {
        ConfigurationManager.nonTLSConnectionsPermitted = nonTLSConnectionsPermitted;
    }
}

