/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.atna;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.common.atna.SecurityDomainException;

public class SecurityDomain {
    private static final Logger logger;
    public static final String JAVAX_NET_DEBUG = "javax.net.debug";
    public static final String JAVAX_NET_SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_NET_SSL_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_NET_SSL_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String JAVAX_NET_SSL_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String HTTPS_CIPHERSUITES = "https.cipherSuites";
    public static final String HTTPS_PROTOCOLS = "https.protocols";
    private static final String[] ENVNAMES;
    public static String TLS_RSA_WITH_AES_128_CBC_SHA;
    public static String SSL_RSA_WITH_NULL_SHA;
    public static String SSL_RSA_WITH_AES_128_CBC_SHA;
    public static String DEFAULT_HTTPS_CIPHERSUITES;
    public static String DEFAULT_HTTPS_PROTOCOLS;
    public static String DEFAULT_SECURITY_DOMAIN;
    final String name;
    KeyManagerFactory keyManagerFactory = null;
    KeyStore keyStore = null;
    TrustManagerFactory trustManagerFactory = null;
    KeyStore trustStore = null;
    String debug = null;
    String systemDebug = null;
    Properties domainProperties = null;
    Properties systemProperties = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.common.atna.SecurityDomain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        ENVNAMES = new String[]{JAVAX_NET_DEBUG, JAVAX_NET_SSL_KEYSTORE, JAVAX_NET_SSL_KEYSTORE_PASSWORD, JAVAX_NET_SSL_TRUSTSTORE, JAVAX_NET_SSL_TRUSTSTORE_PASSWORD, HTTPS_CIPHERSUITES, HTTPS_PROTOCOLS};
        TLS_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";
        SSL_RSA_WITH_NULL_SHA = "TLS_RSA_WITH_NULL_SHA";
        SSL_RSA_WITH_AES_128_CBC_SHA = "SSL_RSA_WITH_AES_128_CBC_SHA";
        DEFAULT_HTTPS_CIPHERSUITES = String.valueOf(TLS_RSA_WITH_AES_128_CBC_SHA) + "," + SSL_RSA_WITH_NULL_SHA + "," + SSL_RSA_WITH_AES_128_CBC_SHA;
        DEFAULT_HTTPS_PROTOCOLS = "TLSv1";
        DEFAULT_SECURITY_DOMAIN = "_DEFAULT_";
    }

    public SecurityDomain(String name, Properties properties) throws SecurityDomainException {
        if (name == null || name.trim().length() < 1) {
            throw new IllegalArgumentException("SecurityDomain(String name, Properties properties) - name cannot be null or blank");
        }
        if (properties == null) {
            throw new IllegalArgumentException("SecurityDomain(String name, Properties properties) - properties cannot be null");
        }
        this.name = name;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Begin: Security name " + name + " setup."));
        }
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) throws SecurityDomainException {
        this.domainProperties = this.cloneProperites(properties);
        if (this.domainProperties.getProperty(HTTPS_CIPHERSUITES) == null) {
            this.domainProperties.setProperty(HTTPS_CIPHERSUITES, DEFAULT_HTTPS_CIPHERSUITES);
        }
        if (this.domainProperties.getProperty(HTTPS_PROTOCOLS) == null) {
            this.domainProperties.setProperty(HTTPS_PROTOCOLS, DEFAULT_HTTPS_PROTOCOLS);
        }
        this.initStores();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Success: Security name " + this.name + " configured."));
        }
    }

    public void setDomainEnvironment() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting System environment properties to Security Domain values");
        }
        this.systemProperties = System.getProperties();
        int i = 0;
        while (i < ENVNAMES.length) {
            this.setOrClearSystemProperties(ENVNAMES[i], this.domainProperties);
            ++i;
        }
    }

    public void restoreSystemEnvironment() {
        if (this.systemProperties == null) {
            throw new NullPointerException("Must call SecurityDomain.setDomainEnvironment() first to record existing System environment");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Swapping back to original System environment properties values");
        }
        int i = 0;
        while (i < ENVNAMES.length) {
            this.setOrClearSystemProperties(ENVNAMES[i], this.systemProperties);
            ++i;
        }
    }

    private Properties cloneProperites(Properties source) {
        Properties clone = new Properties();
        int i = 0;
        while (i < ENVNAMES.length) {
            String v = source.getProperty(ENVNAMES[i]);
            if (v != null) {
                clone.setProperty(ENVNAMES[i], v);
            }
            ++i;
        }
        return clone;
    }

    private void setOrClearSystemProperties(String name, Properties source) {
        String v = source.getProperty(name);
        if (v != null) {
            if (logger.isDebugEnabled()) {
                if (name.indexOf("assword") == -1) {
                    logger.debug((Object)("System property " + name + " set to " + v));
                } else {
                    logger.debug((Object)("System property " + name + " set to XXX (password not shown)"));
                }
            }
            System.setProperty(name, v);
        } else {
            System.setProperty(name, "");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("System property " + name + " cleared."));
            }
        }
    }

    protected void initStores() throws SecurityDomainException {
        this.setDomainEnvironment();
        char[] keyStorePasswd = this.domainProperties.getProperty(JAVAX_NET_SSL_KEYSTORE_PASSWORD, "").toCharArray();
        char[] trustStorePasswd = this.domainProperties.getProperty(JAVAX_NET_SSL_TRUSTSTORE_PASSWORD, "").toCharArray();
        String keyStoreName = this.domainProperties.getProperty(JAVAX_NET_SSL_KEYSTORE, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Name of key store for security domain " + this.name + " is " + keyStoreName));
        }
        if (keyStoreName == null) {
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, "Key Store file is undefined");
        }
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keyStore.load(new FileInputStream(keyStoreName), keyStorePasswd);
            this.keyManagerFactory.init(this.keyStore, keyStorePasswd);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Key store for security domain " + this.name + " initialized successfully"));
            }
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Error: Key Store Manager Algorithm " + KeyManagerFactory.getDefaultAlgorithm() + " is not supported. " + e.getLocalizedMessage();
            logger.error((Object)msg);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        catch (KeyStoreException e) {
            String msg = "Key Store of type " + KeyStore.getDefaultType() + " is not supported. " + e.getLocalizedMessage();
            logger.error((Object)msg, (Throwable)e);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        catch (CertificateException e) {
            String msg = "Error loading key store file " + keyStoreName + ".  " + e.getLocalizedMessage();
            logger.error((Object)msg);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        catch (IOException e) {
            String msg = "Error loading key store file " + keyStoreName + ".  " + e.getLocalizedMessage();
            logger.error((Object)msg);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        catch (UnrecoverableKeyException e) {
            String msg = "Error loading key store file " + keyStoreName + ".  " + e.getLocalizedMessage();
            logger.error((Object)msg);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        String trustStoreName = this.domainProperties.getProperty(JAVAX_NET_SSL_TRUSTSTORE, null);
        if (logger.isDebugEnabled()) {
            if (trustStoreName != null) {
                logger.debug((Object)("Name of trust store for security domain " + this.name + " is " + trustStoreName));
            } else {
                logger.debug((Object)("Name of trust store for security domain " + this.name + " was not defined. Default trust store from JVM will be used"));
            }
        }
        if (trustStoreName != null) {
            try {
                this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                this.trustStore.load(new FileInputStream(trustStoreName), trustStorePasswd);
                this.trustManagerFactory.init(this.trustStore);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trust store for security domain " + this.name + " initialized successfully"));
                }
            }
            catch (NoSuchAlgorithmException e) {
                String msg = "Error: Key Store Manager Algorithm " + KeyManagerFactory.getDefaultAlgorithm() + " is not supported. " + e.getLocalizedMessage();
                logger.error((Object)msg);
                this.restoreSystemEnvironment();
                throw new SecurityDomainException(this.name, msg, e);
            }
            catch (KeyStoreException e) {
                String msg = "Trust Store of type " + KeyStore.getDefaultType() + " is not supported. " + e.getLocalizedMessage();
                logger.error((Object)msg);
                this.restoreSystemEnvironment();
                throw new SecurityDomainException(this.name, msg, e);
            }
            catch (CertificateException e) {
                String msg = "Error loading trust store file " + trustStoreName + ".  " + e.getLocalizedMessage();
                logger.error((Object)msg);
                this.restoreSystemEnvironment();
                throw new SecurityDomainException(this.name, msg, e);
            }
            catch (IOException e) {
                String msg = "Error loading trust store file " + trustStoreName + ".  " + e.getLocalizedMessage();
                logger.error((Object)msg);
                this.restoreSystemEnvironment();
                throw new SecurityDomainException(this.name, msg, e);
            }
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public String getName() {
        return this.name;
    }

    public String[] getCipherSuites() {
        String suitestring = this.domainProperties.getProperty(HTTPS_CIPHERSUITES);
        String[] suites = suitestring.split(",");
        return suites;
    }
}

