/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities;

public class PreviewStreamBuffer {
    public static final int GROW_SIZE = 256;
    private byte[] bytes;
    private int capacity = 0;
    private int size = 0;
    private int cursor = 0;

    private void grow() {
        int oldCapacity = this.capacity;
        this.capacity += 256;
        byte[] newBytes = new byte[this.capacity];
        int i = 0;
        while (i < oldCapacity) {
            newBytes[i] = this.bytes[i];
            ++i;
        }
        this.bytes = newBytes;
    }

    public void reset() {
        this.cursor = 0;
    }

    public boolean hasContent() {
        return this.cursor < this.size;
    }

    public int read() {
        byte value = this.bytes[this.cursor];
        ++this.cursor;
        return value;
    }

    public void add(int value) {
        if (this.size >= this.capacity - 1) {
            this.grow();
        }
        this.bytes[this.size] = (byte)value;
        ++this.size;
        this.cursor = this.size;
    }

    public int available() {
        return this.size - this.cursor;
    }
}

