/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.ohf.utilities.OHFException;
import org.eclipse.ohf.utilities.xml.XMLWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLDomWriter {
    private XMLWriter xml;

    public XMLDomWriter(OutputStream stream) throws UnsupportedEncodingException, IOException {
        this.xml = new XMLWriter(stream, "UTF-8");
        this.xml.start();
    }

    public XMLDomWriter(XMLWriter writer) throws UnsupportedEncodingException {
        this.xml = writer;
    }

    public void write(Element element, boolean rootElement, String elementName, String defaultNamespace) throws OHFException, IOException {
        if (defaultNamespace != null) {
            if (!this.xml.namespaceDefined(defaultNamespace)) {
                this.xml.defaultNamespace(defaultNamespace);
            }
        } else if (rootElement) {
            this.xml.defaultNamespace(element.getNamespaceURI());
        }
        if (elementName != null) {
            this.xml.open(defaultNamespace, elementName);
        }
        if (rootElement) {
            this.processElement(element);
        } else {
            this.processContents(element);
        }
        if (elementName != null) {
            this.xml.close();
        }
        this.xml.flush();
    }

    private void processContents(Element element) throws OHFException, IOException {
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    this.processElement((Element)node);
                    break;
                }
                case 3: {
                    this.processText(node);
                    break;
                }
                case 8: {
                    this.processComment((Comment)node);
                    break;
                }
                default: {
                    throw new OHFException("unhandled node type " + Integer.toString(node.getNodeType()));
                }
            }
            node = node.getNextSibling();
        }
    }

    private void processComment(Comment node) throws DOMException, IOException {
        this.xml.comment(node.getNodeValue(), true);
    }

    private void processElement(Element element) throws OHFException, IOException {
        this.xml.namespace(element.getNamespaceURI());
        this.processAttributes(element);
        this.xml.open(element.getNamespaceURI(), element.getLocalName());
        this.processContents(element);
        this.xml.close();
    }

    private void processText(Node node) throws OHFException, IOException {
        this.xml.text(node.getNodeValue());
    }

    private void processComment(Node node) throws OHFException, IOException {
        this.xml.comment(node.getNodeValue(), false);
    }

    private void processAttributes(Element element) throws IOException {
        NamedNodeMap nodes = element.getAttributes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node attr = nodes.item(i);
            if (attr.getNamespaceURI() != null) {
                this.xml.namespace(attr.getNamespaceURI());
                this.xml.attribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeValue());
            } else {
                this.xml.attribute(attr.getLocalName(), attr.getNodeValue());
            }
            ++i;
        }
    }
}

