/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ExternalIdentifierType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.SlotType1;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;
import org.eclipse.ohf.ihe.xds.metadata.FolderType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0ExtractorConstants;
import org.eclipse.ohf.ihe.xds.metadata.extract.FolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.impl.MetadataFactoryImpl;

public class EbXML_3_0FolderExtractor
implements FolderExtractor {
    public static final String DESCRIPTOR = "EBXML_3_0_FOL_EXTR";
    private static final Logger logger;
    private RegistryPackageType folderData;
    private AssociationType1[] documentsInFolder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0FolderExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public EbXML_3_0FolderExtractor(RegistryPackageType folderData, AssociationType1[] documentsInFolder) {
        this.folderData = folderData;
        this.documentsInFolder = documentsInFolder;
    }

    public FolderType extract() throws MetadataExtractionException {
        if (this.folderData == null) {
            logger.error((Object)"RegistryPackage is null, cannot execute extraction.");
            throw new MetadataExtractionException("RegistryPackage is null, cannot execute extraction.");
        }
        FolderType folder = MetadataFactoryImpl.eINSTANCE.createFolderType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting attributes from the Registry Package.");
        }
        this.extractRegistryPackageAttributes(folder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Name from the Registry Package.");
        }
        folder.setTitle(EbXML_3_0FolderExtractor.copy(this.folderData.getName()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting description from the Registry Package.");
        }
        folder.setComments(EbXML_3_0FolderExtractor.copy(this.folderData.getDescription()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Slot data from  the Registry Package.");
        }
        this.extractRegistryPackageSlots(folder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting ExternalIdentifier data from the Registry Package.");
        }
        this.extractRegistryPackageExternalIdentifiers(folder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Classification data from the Registry Package.");
        }
        this.extractRegistryPackageClassifications(folder);
        if (this.documentsInFolder != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Extracting associated documents from the AssociationType1[].");
            }
            this.extractAssociatedDocuments(folder);
        }
        return folder;
    }

    private void extractRegistryPackageAttributes(FolderType folder) {
        folder.setEntryUUID(this.folderData.getId());
        if (this.folderData.getStatus() != null) {
            if (this.folderData.getStatus().equals(EbXML_3_0ExtractorConstants.APPROVED_STATUS)) {
                folder.setAvailabilityStatus(AvailabilityStatusType.APPROVED_LITERAL);
            } else if (this.folderData.getStatus().equals(EbXML_3_0ExtractorConstants.DEPRECATED_STATUS)) {
                folder.setAvailabilityStatus(AvailabilityStatusType.DEPRECATED_LITERAL);
            } else if (this.folderData.getStatus().equals(EbXML_3_0ExtractorConstants.SUBMITTED_STATUS)) {
                folder.setAvailabilityStatus(AvailabilityStatusType.SUBMITTED_LITERAL);
            } else if (this.folderData.getStatus().equals(EbXML_3_0ExtractorConstants.WITHDRAWN_STATUS)) {
                folder.setAvailabilityStatus(AvailabilityStatusType.WITHDRAWN_LITERAL);
            } else {
                logger.error((Object)"Unknown Status. Status will not be included in extracted content.");
            }
        }
    }

    private void extractRegistryPackageSlots(FolderType folder) {
        EList slots = this.folderData.getSlot();
        int i = 0;
        while (i < slots.size()) {
            String slotName;
            SlotType1 slot = (SlotType1)slots.get(i);
            if (slot != null && slot.getName() != null && slot.getValueList() != null && slot.getValueList().getValue() != null && slot.getValueList().getValue().size() >= 1 && slot.getValueList().getValue().get(0) != null && (slotName = slot.getName()).equals("lastUpdateTime")) {
                String s = (String)slot.getValueList().getValue().get(0);
                folder.setLastUpdateTime(s);
                return;
            }
            ++i;
        }
    }

    private void extractRegistryPackageExternalIdentifiers(FolderType folder) {
        EList externalIdentifiers = this.folderData.getExternalIdentifier();
        int i = 0;
        while (i < externalIdentifiers.size()) {
            ExternalIdentifierType exID = (ExternalIdentifierType)externalIdentifiers.get(i);
            String idScheme = exID.getIdentificationScheme();
            if (idScheme == null) {
                logger.error((Object)("Required ExternalIdentifier/@identificationScheme attribute missing for following id: " + exID.getValue() + ". ID will not be included in extracted content."));
            }
            if (idScheme.equals("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a")) {
                String s = exID.getValue();
                CX patientId = HL7V2MessageFormat.buildCXFromMessageString((String)s, (char)'^', (char)'&');
                folder.setPatientId(patientId);
            } else if (idScheme.equals("urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a")) {
                folder.setUniqueId(exID.getValue());
            } else {
                logger.error((Object)("Unidentified ExternalIdentifier/@identificationScheme: " + idScheme + ". " + exID.getValue() + " will not be included in extracted content."));
            }
            ++i;
        }
    }

    private void extractRegistryPackageClassifications(FolderType folder) {
        EList codeList = this.folderData.getClassification();
        int i = 0;
        while (i < codeList.size()) {
            ClassificationType c;
            if (codeList.get(i) instanceof ClassificationType && (c = (ClassificationType)codeList.get(i)) != null) {
                String codeUUID;
                SlotType1 cSlot;
                CodedMetadataType code = MetadataFactory.eINSTANCE.createCodedMetadataType();
                code.setCode(c.getNodeRepresentation());
                code.setDisplayName(EbXML_3_0FolderExtractor.copy(c.getName()));
                if (c.getSlot() != null && c.getSlot().size() > 0 && c.getSlot().get(0) != null && (cSlot = (SlotType1)c.getSlot().get(0)).getValueList() != null && cSlot.getValueList().getValue() != null && cSlot.getValueList().getValue().size() > 0) {
                    code.setSchemeName((String)cSlot.getValueList().getValue().get(0));
                }
                if ((codeUUID = c.getClassificationScheme()) == null) {
                    logger.error((Object)("Required Classification/@classificationScheme attribute missing for following code: " + code.getCode() + ", " + code.getSchemeName() + ". Code will not be included in extracted content."));
                }
                if (codeUUID.equals("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5")) {
                    folder.getCode().add((Object)code);
                } else {
                    logger.error((Object)("Unidentified Classification/@classificationScheme: " + codeUUID + code.getCode() + ", " + code.getSchemeName() + " will not be included in extracted content."));
                }
            }
            ++i;
        }
    }

    private void extractAssociatedDocuments(FolderType folder) {
        int i = 0;
        while (i < this.documentsInFolder.length) {
            if (this.documentsInFolder[i].getAssociationType().equals("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember")) {
                folder.getAssociatedDocuments().add((Object)this.documentsInFolder[i].getTargetObject());
            } else {
                logger.error((Object)("Unidentified Association/@associationType: " + this.documentsInFolder[i].getAssociationType() + this.documentsInFolder[i].getTargetObject() + " will not be included in extracted content."));
            }
            ++i;
        }
    }

    private static InternationalStringType copy(org.eclipse.ohf.ihe.common.ebxml._3._0.rim.InternationalStringType ist) {
        InternationalStringType result = MetadataFactory.eINSTANCE.createInternationalStringType();
        if (ist != null) {
            Iterator i = ist.getLocalizedString().iterator();
            while (i.hasNext()) {
                LocalizedStringType lst = MetadataFactory.eINSTANCE.createLocalizedStringType();
                org.eclipse.ohf.ihe.common.ebxml._3._0.rim.LocalizedStringType original = (org.eclipse.ohf.ihe.common.ebxml._3._0.rim.LocalizedStringType)i.next();
                lst.setCharset(original.getCharset());
                lst.setLang(original.getLang());
                lst.setValue(original.getValue());
                result.getLocalizedString().add((Object)lst);
            }
        }
        return result;
    }
}

