/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pix.source;

import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.CPMessageBuilder;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.pix.source.PixSourceException;

public class PixMsgADT
extends PixPdqMessage {
    private static Logger logger;
    private MessageManager globalFactory;
    private CPConformanceProfile cpProfile;
    private int version = 6;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.pix.source.PixMsgADT");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public PixMsgADT(MessageManager globalFactory, CPConformanceProfile cpProfile, int version, String msgEventType, String patientId, String namespaceId, String universalId, String universalIdType) throws PixSourceException {
        this.nodeType = 2;
        this.globalFactory = globalFactory;
        this.cpProfile = cpProfile;
        this.version = version;
        this.createFeedMsg(msgEventType, patientId, namespaceId, universalId, universalIdType);
    }

    public void addOptionalPatientId(String patientId, String namespaceId, String universalId, String universalIdType) throws PixSourceException {
        try {
            this.setField("PID-3-1", patientId);
            if (!PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                throw new PixSourceException("PixMsgADT: changeDefaultSendingApplication - " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination ");
            }
            this.setField("PID-3-4-1", namespaceId);
            this.setField("PID-3-4-2", universalId);
            this.setField("PID-3-4-3", universalIdType);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientId ");
        }
    }

    public void addOptionalPatientNameFamilyName(String familyName) throws PixSourceException {
        try {
            this.setField("PID-5-1-1", familyName);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientNameFamilyName ");
        }
    }

    public void addOptionalPatientNameGivenName(String givenName) throws PixSourceException {
        try {
            this.setField("PID-5-2", givenName);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientNameGivenName ");
        }
    }

    public void addOptionalPatientNameOtherName(String otherName) throws PixSourceException {
        try {
            this.setField("PID-5-3", otherName);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientNameOtherName ");
        }
    }

    public void addOptionalPatientNameSuffix(String suffix) throws PixSourceException {
        try {
            this.setField("PID-5-4", suffix);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientNameSuffix ");
        }
    }

    public void addOptionalPatientNamePrefix(String prefix) throws PixSourceException {
        try {
            this.setField("PID-5-5", prefix);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientNamePrefix ");
        }
    }

    public void addOptionalPatientNameDegree(String degree) throws PixSourceException {
        try {
            this.setField("PID-5-6", degree);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientNameDegree ");
        }
    }

    public void addOptionalPatientDateOfBirth(String dob) throws PixSourceException {
        try {
            this.setField("PID-7-1", dob);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientDateOfBirth ");
        }
    }

    public void addOptionalPatientSex(String sex) throws PixSourceException {
        try {
            this.setField("PID-8", sex);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientSex ");
        }
    }

    public void addOptionalPatientAddressStreetAddress(String address) throws PixSourceException {
        try {
            this.setField("PID-11-1-1", address);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressStreetAddress ");
        }
    }

    public void addOptionalPatientAddressOtherDesignation(String address) throws PixSourceException {
        try {
            this.setField("PID-11-2", address);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressOtherDesignation ");
        }
    }

    public void addOptionalPatientAddressCity(String city) throws PixSourceException {
        try {
            this.setField("PID-11-3", city);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressCity ");
        }
    }

    public void addOptionalPatientAddressStateOrProvince(String stateOrProvince) throws PixSourceException {
        try {
            this.setField("PID-11-4", stateOrProvince);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressStateOrProvince ");
        }
    }

    public void addOptionalPatientAddressZipOrPostalCode(String zipOrPostalCode) throws PixSourceException {
        try {
            this.setField("PID-11-5", zipOrPostalCode);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressZipOrPostalCode ");
        }
    }

    public void addOptionalPatientAddressCountry(String country) throws PixSourceException {
        try {
            this.setField("PID-11-6", country);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressCountry ");
        }
    }

    public void addOptionalPatientAddressType(String type) throws PixSourceException {
        try {
            this.setField("PID-11-7", type);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressType ");
        }
    }

    public void addOptionalPatientAddressOtherGeographicDesignation(String otherDesignation) throws PixSourceException {
        try {
            this.setField("PID-11-8", otherDesignation);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressOtherGeographicDesignation ");
        }
    }

    public void addOptionalPatientAddressCountyParishCode(String countyParishCode) throws PixSourceException {
        try {
            this.setField("PID-11-9", countyParishCode);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressCountyParishCode ");
        }
    }

    public void addOptionalPatientAddressCensusTract(String censusTract) throws PixSourceException {
        try {
            this.setField("PID-11-10", censusTract);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientAddressCensusTract ");
        }
    }

    public void addOptionalPatientPhoneHomeUnformattedTelephoneNumber(String homePhone) throws PixSourceException {
        try {
            this.setField("PID-13-1", homePhone);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientPhoneHome ");
        }
    }

    public void addOptionalPatientPhoneBusinessUnformattedTelephoneNumber(String businessPhone) throws PixSourceException {
        try {
            this.setField("PID-14-1", businessPhone);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addOptionalPatientPhoneBusiness ");
        }
    }

    public void addOptionalPatientAccountNumberId(String accountNumberId, String namespaceId, String universalId, String universalIdType) throws PixSourceException {
        try {
            if (accountNumberId != null && accountNumberId.length() > 0) {
                this.setField("PID-18-1", accountNumberId);
                if (PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                    this.setField("PID-18-4-1", namespaceId);
                    this.setField("PID-18-4-2", universalId);
                    this.setField("PID-18-4-3", universalIdType);
                } else {
                    logger.info((Object)("PixMsgADT: addQueryPatientAccountNumberId - " + accountNumberId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination "));
                }
            }
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgADT: addQueryPatientAccountNumberId ");
        }
    }

    private void createFeedMsg(String msgEventType, String patientId, String namespaceId, String universalId, String universalIdType) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixFeedMsg: createFeedMsg - Entry ");
        }
        if (patientId == null || patientId.length() <= 0) {
            logger.error((Object)"PixMsgADT: createFeedMsg - required patientId empty");
            throw new PixSourceException("PixMsgADT: createFeedMsg - required patientId empty");
        }
        try {
            this.clear();
            if (this.globalFactory != null) {
                this.setDefinitions(this.globalFactory.getVersionDefinitions());
            }
            this.setVersion(this.version);
            this.setEvent(msgEventType);
            this.setMessageType("ADT");
            if (msgEventType.equals("A40")) {
                this.setStructId("ADT_A39");
            } else if (msgEventType.equals("A05")) {
                this.setStructId("ADT_A05");
            } else {
                this.setStructId("ADT_A01");
            }
            this.addMSHFromFields();
            this.getSegments().add("EVN");
            this.getSegments().add("PID");
            if (this.cpProfile != null) {
                CPMessageBuilder builder = new CPMessageBuilder();
                builder.build(this.version, this.cpProfile.getInteractions().itemInteraction(0).getStaticDefinition(), true, (Message)this);
                String cpNamespaceId = this.getField("PID-3-4-1");
                String cpUniversalId = this.getField("PID-3-4-2");
                String cpUniversalIdType = this.getField("PID-3-4-3");
                logger.debug((Object)("PixFeedMsg: cp assigningAuthority " + cpNamespaceId + ", " + cpUniversalId + ", " + cpUniversalIdType));
                if (cpNamespaceId != null && cpNamespaceId.length() > 0 || cpUniversalId != null && cpUniversalId.length() > 0 || cpUniversalIdType != null && cpUniversalIdType.length() > 0) {
                    if (!PixPdqMessageUtilities.isHDParamValid((String)cpNamespaceId, (String)cpUniversalId, (String)cpUniversalIdType)) {
                        throw new PixSourceException("PixMsgADT: createFeedMsg - patientId cp assigning authority invalid");
                    }
                    this.setField("PID-3-1", patientId);
                }
                if (namespaceId != null && namespaceId.length() > 0 || universalId != null && universalId.length() > 0 || universalIdType != null && universalIdType.length() > 0) {
                    if (!PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                        throw new PixSourceException("PixMsgADT: createFeedMsg - patientId assigning authority invalid");
                    }
                    this.setField("PID-3-1", patientId);
                    this.setField("PID-3-4-1", namespaceId);
                    this.setField("PID-3-4-2", universalId);
                    this.setField("PID-3-4-3", universalIdType);
                    logger.debug((Object)"PixMsgADT: createFeedMsg - patientId cp assigning authority overridden with local parameters");
                }
            } else {
                if (!PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                    throw new PixSourceException("PixMsgADT: createFeedMsg - required patientId namespace invalid");
                }
                this.setField("PID-3-1", patientId);
                this.setField("PID-3-4-1", namespaceId);
                this.setField("PID-3-4-2", universalId);
                this.setField("PID-3-4-3", universalIdType);
            }
            this.setField("MSH-12", VersionDefnList.display((int)this.version));
            String dateTime = PixPdqMessageUtilities.getCurrentDateTimeString();
            this.setField("MSH-7", dateTime);
            this.setNonNullElement("EVN-2-1", dateTime);
            this.setNonNullElement("MSH-10", PixPdqMessageUtilities.getRandomFieldValue((int)20));
            this.setNonNullElement("MSH-11-1", "P");
            this.setNonNullElement("MSH-18-1", "ASCII");
            if (msgEventType.equals("A01") || msgEventType.equals("A05")) {
                if (this.getSegments().countByCode("PV1") < 1) {
                    this.getSegments().add("PV1");
                }
                this.setField("PV1-2", "I");
            } else if (msgEventType.equals("A04")) {
                if (this.getSegments().countByCode("PV1") < 1) {
                    this.getSegments().add("PV1");
                }
                this.setField("PV1-2", "O");
            }
        }
        catch (HL7V2Exception e) {
            logger.error((Object)("PixMsgADT: createFeedMsg - HL7V2Exception " + e.getLocalizedMessage()));
            throw new PixSourceException(e);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug((Object)("PixMsgADT: createFeedMsg \r" + PixPdqMessageUtilities.msgToString((Message)this)));
            }
            catch (PixPdqMessageException pixPdqMessageException) {
                logger.debug((Object)"PixMsgADT: createFeedMsg \r");
            }
        }
    }
}

