/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPDynamicDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTyped;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPInteraction
extends CPTyped {
    private CPDynamicDefinition dynamicDefinition;
    private CPStaticDefinition staticDefinition;

    public CPInteraction(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.dynamicDefinition = new CPDynamicDefinition(this);
        this.staticDefinition = new CPStaticDefinition(this);
    }

    public CPDynamicDefinition getDynamicDefinition() {
        return this.dynamicDefinition;
    }

    public CPStaticDefinition getStaticDefinition() {
        return this.staticDefinition;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(this.staticDefinition.getPropertyIds(), new int[]{32, 33, 34, 35, 36});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return this.dynamicDefinition.getProperty(id);
            }
        }
        return this.staticDefinition.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                this.dynamicDefinition.setProperty(id, value);
                break;
            }
            default: {
                this.staticDefinition.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Interaction";
    }

    public void defaults() {
        super.defaults();
        this.dynamicDefinition.defaults();
        this.staticDefinition.defaults();
    }

    public int elementType() {
        return 7;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPInteraction src = (CPInteraction)source;
        if (src.dynamicDefinition == null) {
            this.dynamicDefinition = null;
        } else {
            this.dynamicDefinition = src.dynamicDefinition.cloneDynamicDefinition();
            this.dynamicDefinition.setOwner(this);
        }
        if (src.staticDefinition == null) {
            this.staticDefinition = null;
        } else {
            this.staticDefinition = src.staticDefinition.cloneStaticDefinition();
            this.staticDefinition.setOwner(this);
        }
    }

    public CPInteraction cloneInteraction() throws CloneNotSupportedException {
        return (CPInteraction)this.clone();
    }
}

