/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPUseCaseElements;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPUseCase
extends CPElement {
    private String purpose;
    private String description;
    private CPUseCaseElements elements;

    public CPUseCase(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.purpose = null;
        this.description = null;
        this.elements = new CPUseCaseElements(this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CPUseCaseElements getElements() {
        return this.elements;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.equals("");
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.equals("");
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{4, 5});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 4: {
                return this.getPurpose();
            }
            case 5: {
                return this.getDescription();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 4: {
                this.setPurpose(value);
                break;
            }
            case 5: {
                this.setDescription(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Use Case";
    }

    public void defaults() {
        super.defaults();
        this.purpose = null;
        this.description = null;
    }

    public int elementType() {
        return 4;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPUseCase src = (CPUseCase)source;
        if (src.elements == null) {
            this.elements = src.elements.cloneUseCaseElements();
            this.elements.setOwner(this);
        } else {
            this.elements = null;
        }
        this.purpose = src.purpose;
        this.description = src.description;
    }

    public CPUseCase cloneUseCase() throws CloneNotSupportedException {
        return (CPUseCase)this.clone();
    }
}

