/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.formats.embedded;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.ohf.utilities.xml.XMLElementIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmbeddedLoaderGenerator {
    private static String GENERATE_PATH = "E:/Dev/org.eclipse.ohf.hl7v2.core/src/org/eclipse/ohf/hl7v2/core/definitions/formats/embedded";
    private static String DEFNS_PATH = "E:/Dev/org.eclipse.ohf.hl7v2.ui/Resources/hl7Definitions.stream";
    private Element root;
    private String path;
    private static String HEADER = "/*******************************************************************************\n* Copyright (c) 2000, 2005 Jiva Medical and others.\n* All rights reserved. This program and the accompanying materials\n* are made available under the terms of the Eclipse Public License v1.0\n* which accompanies this distribution, and is available at\n* http://www.eclipse.org/legal/epl-v10.html\n*\n* Contributors:\n*     Jiva Medical - initial API and implementation\n******************************************************************************/\npackage org.eclipse.ohf.hl7v2.core.definitions.formats.embedded;\n\nimport org.eclipse.ohf.hl7v2.core.definitions.model.*;\nimport org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;";
    private transient List defns = new ArrayList();
    private transient List tables = new ArrayList();
    private transient List comps = new ArrayList();
    private transient List dataElements = new ArrayList();
    private transient List segments = new ArrayList();
    private transient List dataTypes = new ArrayList();
    private transient List structs = new ArrayList();
    private transient List events = new ArrayList();
    private transient List msgTypes = new ArrayList();
    private transient List msgStructs = new ArrayList();
    private transient int tableCount;
    private transient int structCount;
    private transient int segmentCount;
    private transient int eventCount;
    private transient int msgStructCount;
    private transient PrintWriter writer = null;

    public EmbeddedLoaderGenerator(Document doc, String path) {
        this.root = doc.getDocumentElement();
        this.path = path;
    }

    private void initGenerator() throws IOException {
        this.defns.clear();
        this.tables.clear();
        this.comps.clear();
        this.dataElements.clear();
        this.segments.clear();
        this.dataTypes.clear();
        this.structs.clear();
        this.events.clear();
        this.msgTypes.clear();
        this.msgStructs.clear();
    }

    private void openWriter(String name) throws Exception {
        this.writer = new PrintWriter(new FileOutputStream(String.valueOf(this.path) + "/" + name + ".java"));
        this.writer.println(HEADER);
        this.writer.println("\npublic class " + name + " {");
        this.writer.println();
    }

    private void closeWriter() throws Exception {
        this.writer.println("}");
        this.writer.close();
    }

    public void generate() throws Exception {
        this.initGenerator();
        XMLElementIterator iter = new XMLElementIterator(this.root);
        while (iter.more()) {
            this.generateDefnsInit(iter.current());
            iter.next();
        }
        this.openWriter("VersionDefnInit");
        this.generateDefnListInit();
        this.closeWriter();
    }

    private void generateDefnsInit(Element defnNode) throws Exception {
        String version = defnNode.getAttribute("v");
        String versionSt = version.replace('.', '_');
        String defnClassName = "VersionDefn" + versionSt;
        this.defns.add(String.valueOf(defnClassName) + ".initDefn");
        this.tableCount = 0;
        this.structCount = 0;
        this.segmentCount = 0;
        this.eventCount = 0;
        this.msgStructCount = 0;
        this.openWriter(defnClassName);
        this.writer.println("\tprivate static transient VersionDefn version;");
        this.writer.println("\tprivate static transient TableDefn table;");
        this.writer.println("\tprivate static transient StructureDefn struct;");
        this.writer.println("\tprivate static transient SegmentDefn segment;");
        this.writer.println("\tprivate static transient EventDefn event;");
        this.writer.println("\tprivate static transient MessageStructureDefn msgStruct;");
        this.writer.println();
        XMLElementIterator iter = new XMLElementIterator(defnNode);
        while (iter.more()) {
            String nodeName = iter.current().getNodeName();
            if ("tbl".equals(nodeName)) {
                this.tables.add(this.generateTableInits(iter.current(), versionSt));
            } else if ("dt".equals(nodeName)) {
                this.dataTypes.add(this.generateDataTypeInits(iter.current()));
            } else if (nodeName.equals("cmp")) {
                this.comps.add(this.generateComponentInits(iter.current()));
            } else if (nodeName.equals("struc")) {
                this.structs.add(this.generateStructInits(iter.current(), versionSt));
            } else if (nodeName.equals("de")) {
                this.dataElements.add(this.generateDataElementInits(iter.current()));
            } else if (nodeName.equals("seg")) {
                this.segments.add(this.generateSegmentInits(iter.current(), versionSt));
            } else if (nodeName.equals("msg")) {
                this.msgStructs.add(this.generateMsgStructInits(iter.current(), versionSt));
            } else if (nodeName.equals("ev")) {
                this.events.add(this.generateEventInits(iter.current(), versionSt));
            } else if (nodeName.equals("mt")) {
                this.msgTypes.add(this.generateMsgTypeInits(iter.current()));
            } else {
                throw new Exception("Unknown children name " + nodeName + " of version definition");
            }
            iter.next();
        }
        ArrayList<String> initBody = new ArrayList<String>();
        initBody.add(this.generateCreateMethods("Tables", versionSt, this.tables));
        initBody.add(this.generateCreateMethods("DataTypes", versionSt, this.dataTypes));
        initBody.add(this.generateCreateMethods("Components", versionSt, this.comps));
        initBody.add(this.generateCreateMethods("Structs", versionSt, this.structs));
        initBody.add(this.generateCreateMethods("DataElements", versionSt, this.dataElements));
        initBody.add(this.generateCreateMethods("Segments", versionSt, this.segments));
        initBody.add(this.generateCreateMethods("MsgStructs", versionSt, this.msgStructs));
        initBody.add(this.generateCreateMethods("Events", versionSt, this.events));
        initBody.add(this.generateCreateMethods("MsgTypes", versionSt, this.msgTypes));
        this.writer.println("\n\tpublic static VersionDefn initDefn(VersionDefnList list) throws HL7V2Exception {");
        this.writer.println("\t\tversion = new VersionDefn(list);");
        this.writer.println("\t\tversion.setVersion(VersionDefnList.getVersion(\"" + version + "\"));\n");
        int i = 0;
        while (i < initBody.size()) {
            this.writer.println("\t\t" + initBody.get(i) + ";");
            ++i;
        }
        initBody.clear();
        this.writer.println("\t\tversion.crossLink();");
        this.writer.println("\t\treturn version;");
        this.writer.println("\t}");
        this.closeWriter();
    }

    private String generateCreateMethods(String name, String version, List methodBody) {
        String methodName = "create" + name + "ForVersion" + version + "()";
        this.writer.println("\n\tpublic static void " + methodName + " throws HL7V2Exception {");
        int i = 0;
        while (i < methodBody.size()) {
            this.writer.println("\t\t" + methodBody.get(i) + ";");
            ++i;
        }
        methodBody.clear();
        this.writer.println("\t}\n");
        return methodName;
    }

    private String generateMsgTypeInits(Element node) {
        String name = StringEscapeUtils.escapeJava((String)node.getAttribute("n"));
        String desc = StringEscapeUtils.escapeJava((String)node.getAttribute("d"));
        return "EmbeddedLoaderUtil.createMessageType(version, \"" + name + "\", \"" + desc + "\");";
    }

    private String generateEventInits(Element node, String version) throws Exception {
        String name = StringEscapeUtils.escapeJava((String)node.getAttribute("n"));
        String desc = StringEscapeUtils.escapeJava((String)node.getAttribute("d"));
        String methodName = "createEvent" + this.eventCount + "_version_" + version + "()";
        ++this.eventCount;
        this.writer.println("\n\t/* Event name=" + name + ", count = " + this.eventCount + " */");
        this.writer.println("\tpublic static void " + methodName + " throws HL7V2Exception {");
        this.writer.println("\t\tevent = EmbeddedLoaderUtil.createEvent(version, \"" + name + "\", \"" + desc + "\");");
        XMLElementIterator iter = new XMLElementIterator(node);
        while (iter.more()) {
            String nodeName = iter.current().getNodeName();
            if (!"msg".equals(nodeName)) {
                throw new Exception("Unknown struct's children name " + nodeName);
            }
            String msg = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("m"));
            String code = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("sc"));
            String reply = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("rm"));
            String replyCode = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("rsc"));
            this.writer.println("\t\tEmbeddedLoaderUtil.createEventMessage(version, event, \"" + msg + "\", \"" + code + "\", \"" + reply + "\", \"" + replyCode + "\");");
            iter.next();
        }
        this.writer.println("\t}\n");
        return methodName;
    }

    private String generateMsgStructInits(Element node, String version) throws Exception {
        String name = StringEscapeUtils.escapeJava((String)node.getAttribute("n"));
        String desc = StringEscapeUtils.escapeJava((String)node.getAttribute("d"));
        String exEvents = StringEscapeUtils.escapeJava((String)node.getAttribute("xe"));
        String exMsgType = StringEscapeUtils.escapeJava((String)node.getAttribute("xmt"));
        String action = StringEscapeUtils.escapeJava((String)node.getAttribute("a"));
        String methodName = "createMsgStruct" + this.msgStructCount + "_version_" + version + "()";
        ++this.msgStructCount;
        String body = "";
        XMLElementIterator iter = new XMLElementIterator(node);
        while (iter.more()) {
            String nodeName = iter.current().getNodeName();
            if ("sg".equals(nodeName)) {
                if (body.length() > 0) {
                    throw new Exception("MessageStructure has more than 1 segment group as children.");
                }
                String segName = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("n"));
                String segDesc = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("d"));
                boolean isOpt = Boolean.getBoolean(iter.current().getAttribute("o"));
                boolean isRepeating = Boolean.getBoolean(iter.current().getAttribute("r"));
                int groupType = Integer.parseInt(iter.current().getAttribute("t"));
                body = String.valueOf(body) + "\t\tSegmentGroupDefn defn = EmbeddedLoaderUtil.createSegmentGroup(" + "version, \"" + segName + "\", \"" + segDesc + "\", " + isOpt + ", " + isRepeating + ", " + groupType + ");\n";
                if (iter.current().getElementsByTagName("sg").getLength() > 0) {
                    body = String.valueOf(body) + "\t\t" + this.generateSegmentGroupChildrenInit("createSegmentGroupChildren_version" + version + "MsgStruct" + this.msgStructCount + "_", 1, iter.current()) + "\n";
                }
            } else {
                throw new Exception("Unknown MessageStructure's children name " + nodeName);
            }
            body = String.valueOf(body) + "\t\tmsgStruct.setMap(defn);\n";
            iter.next();
        }
        this.writer.println("\n\t/* MessageStruct name=" + name + ", count = " + this.msgStructCount + " */");
        this.writer.println("\tpublic static void " + methodName + " throws HL7V2Exception {");
        this.writer.println("\t\tmsgStruct = EmbeddedLoaderUtil.createMessageStructure(version, \"" + name + "\", \"" + desc + "\", \"" + exEvents + "\", " + "\"" + exMsgType + "\", \"" + action + "\");");
        this.writer.print(body);
        this.writer.println("\t}\n");
        return methodName;
    }

    private String generateSegmentGroupChildrenInit(String prefix, int count, Element node) throws Exception {
        String methodName = String.valueOf(prefix) + "_" + count;
        int childrenCount = 0;
        ArrayList<String> methodBody = new ArrayList<String>();
        boolean moreChildren = false;
        XMLElementIterator iter = new XMLElementIterator(node);
        while (iter.more()) {
            String nodeName = iter.current().getNodeName();
            if ("sg".equals(nodeName)) {
                ++childrenCount;
                String segName = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("n"));
                String segDesc = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("d"));
                boolean isOpt = Boolean.getBoolean(iter.current().getAttribute("o"));
                boolean isRepeating = Boolean.getBoolean(iter.current().getAttribute("r"));
                int groupType = Integer.parseInt(iter.current().getAttribute("t"));
                if (iter.current().getElementsByTagName("sg").getLength() > 0) {
                    methodBody.add("\t\tdefn = EmbeddedLoaderUtil.createSegmentGroupChildren(version, parent, \"" + segName + "\", " + "\"" + segDesc + "\", " + isOpt + ", " + isRepeating + ", " + groupType + ");\n");
                    moreChildren = true;
                    methodBody.add("\t\t" + this.generateSegmentGroupChildrenInit(methodName, childrenCount, iter.current()) + "\n");
                } else {
                    methodBody.add("\t\tEmbeddedLoaderUtil.createSegmentGroupChildren(version, parent, \"" + segName + "\", " + "\"" + segDesc + "\", " + isOpt + ", " + isRepeating + ", " + groupType + ");\n");
                }
            } else {
                throw new Exception("Unknown SegmentGroup's children name " + nodeName);
            }
            iter.next();
        }
        this.writer.println("\n\t/* SegmentGroup name=" + methodName + " */");
        this.writer.println("\tpublic static void " + methodName + "(SegmentGroupDefn parent) throws HL7V2Exception {");
        if (moreChildren) {
            this.writer.println("\t\tSegmentGroupDefn defn;");
        }
        int i = 0;
        while (i < methodBody.size()) {
            this.writer.print(methodBody.get(i));
            ++i;
        }
        this.writer.println("\t}\n");
        return String.valueOf(methodName) + "(defn);";
    }

    private Object generateSegmentInits(Element node, String version) throws Exception {
        String name = StringEscapeUtils.escapeJava((String)node.getAttribute("n"));
        String desc = StringEscapeUtils.escapeJava((String)node.getAttribute("d"));
        String segmentMethodName = "createSegment" + this.segmentCount + "_version_" + version + "()";
        ++this.segmentCount;
        this.writer.println("\n\t/* Segment name=" + name + " */");
        this.writer.println("\tpublic static void " + segmentMethodName + " throws HL7V2Exception {");
        this.writer.println("\t\tsegment = EmbeddedLoaderUtil.createSegment(version, \"" + name + "\", \"" + desc + "\");");
        XMLElementIterator iter = new XMLElementIterator(node);
        while (iter.more()) {
            String nodeName = iter.current().getNodeName();
            if (!"f".equals(nodeName)) {
                throw new Exception("Unknown struct's children name " + nodeName);
            }
            int id = Integer.parseInt(iter.current().getAttribute("id"));
            int repeatCount = Integer.parseInt(iter.current().getAttribute("c"));
            int no = Integer.parseInt(iter.current().getAttribute("n"));
            boolean isRepeatable = Boolean.getBoolean(iter.current().getAttribute("r"));
            boolean isRequired = Boolean.getBoolean(iter.current().getAttribute("m"));
            this.writer.println("\t\tEmbeddedLoaderUtil.createSegmentField(version, segment, " + id + ", " + isRepeatable + ", " + repeatCount + ", " + isRequired + ", " + no + ");");
            iter.next();
        }
        this.writer.println("\t}\n");
        return segmentMethodName;
    }

    private String generateDataElementInits(Element node) {
        String desc = StringEscapeUtils.escapeJava((String)node.getAttribute("d"));
        String code = StringEscapeUtils.escapeJava((String)node.getAttribute("sc"));
        int id = Integer.parseInt(node.getAttribute("id"));
        int len = Integer.parseInt(node.getAttribute("l"));
        int tableId = Integer.parseInt(node.getAttribute("t"));
        return "EmbeddedLoaderUtil.createDataElement(version, \"" + desc + "\", \"" + code + "\", " + id + ", " + len + ", " + tableId + ");";
    }

    private String generateStructInits(Element node, String version) throws Exception {
        int structId = Integer.parseInt(node.getAttribute("id"));
        String name = StringEscapeUtils.escapeJava((String)node.getAttribute("n"));
        String desc = StringEscapeUtils.escapeJava((String)node.getAttribute("d"));
        String code = StringEscapeUtils.escapeJava((String)node.getAttribute("dt"));
        String structMethodName = "createStruct" + this.structCount + "_version_" + version + "()";
        ++this.structCount;
        this.writer.println("\n\t/* Struct id=" + structId + " */");
        this.writer.println("\tpublic static void " + structMethodName + " throws HL7V2Exception {");
        this.writer.println("\t\tstruct = EmbeddedLoaderUtil.createStruct(version, \"" + name + "\", \"" + desc + "\", \"" + code + "\", " + structId + ");");
        XMLElementIterator iter = new XMLElementIterator(node);
        while (iter.more()) {
            String nodeName = iter.current().getNodeName();
            if (!"cmp".equals(nodeName)) {
                throw new Exception("Unknown struct's children name " + nodeName);
            }
            int itemNo = Integer.parseInt(iter.current().getAttribute("nm"));
            this.writer.println("\t\tstruct.getComponents().add(version.getComponents().itemByNumber(" + itemNo + "));");
            iter.next();
        }
        this.writer.println("\t}\n");
        return structMethodName;
    }

    private String generateComponentInits(Element node) {
        String name = StringEscapeUtils.escapeJava((String)node.getAttribute("n"));
        String code = StringEscapeUtils.escapeJava((String)node.getAttribute("dt"));
        int no = Integer.parseInt(node.getAttribute("nm"));
        int tableId = Integer.parseInt(node.getAttribute("t"));
        return "EmbeddedLoaderUtil.createComponent(version, \"" + name + "\", \"" + code + "\", " + no + ", " + tableId + ");";
    }

    private String generateDataTypeInits(Element node) throws Exception {
        int len = Integer.parseInt(node.getAttribute("l"));
        String name = StringEscapeUtils.escapeJava((String)node.getAttribute("n"));
        String desc = StringEscapeUtils.escapeJava((String)node.getAttribute("d"));
        return "EmbeddedLoaderUtil.createDataType(version, \"" + name + "\", \"" + desc + "\", " + len + ");";
    }

    private String generateTableInits(Element node, String version) throws Exception {
        int tableId = Integer.parseInt(node.getAttribute("id"));
        String tableName = StringEscapeUtils.escapeJava((String)node.getAttribute("n"));
        String tableDesc = StringEscapeUtils.escapeJava((String)node.getAttribute("d"));
        String tableMethodName = "createTable" + this.tableCount + "_version_" + version + "()";
        ++this.tableCount;
        this.writer.println("\n\t/* Table id=" + tableId + " */");
        this.writer.println("\tpublic static void " + tableMethodName + " throws HL7V2Exception {");
        this.writer.println("\t\ttable = EmbeddedLoaderUtil.createTableDefn(version, " + tableId + ", \"" + tableName + "\", \"" + tableDesc + "\");");
        XMLElementIterator iter = new XMLElementIterator(node);
        while (iter.more()) {
            String nodeName = iter.current().getNodeName();
            if (!"itm".equals(nodeName)) {
                throw new Exception("Unknown table's children name " + nodeName);
            }
            int itemId = Integer.parseInt(iter.current().getAttribute("id"));
            String itemName = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("n"));
            String itemDesc = StringEscapeUtils.escapeJava((String)iter.current().getAttribute("d"));
            this.writer.println("\t\tEmbeddedLoaderUtil.createTableItemDefn(version, table, " + itemId + ", \"" + itemName + "\", \"" + itemDesc + "\");");
            iter.next();
        }
        this.writer.println("\t}\n");
        return tableMethodName;
    }

    private void generateDefnListInit() {
        this.writer.println("\n\tpublic static void init(VersionDefnList list) throws HL7V2Exception {");
        Iterator iter = this.defns.iterator();
        while (iter.hasNext()) {
            this.writer.println("\t\tlist.add(" + iter.next().toString() + "(list));");
        }
        this.writer.println("\t}");
    }

    public static void main(String[] args) throws Exception {
        Document doc = EmbeddedLoaderGenerator.extractDefnFromStream(DEFNS_PATH);
        EmbeddedLoaderGenerator gen = new EmbeddedLoaderGenerator(doc, GENERATE_PATH);
        gen.generate();
        EmbeddedLoaderGenerator.extractDefnToXML(doc, "c:/temp/hl7v2Defns.xml");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document extractDefnFromStream(String path) throws Exception {
        Document result = null;
        GZIPInputStream inStream = new GZIPInputStream(new FileInputStream(path));
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        try {
            result = builder.parse(inStream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inStream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        inStream.close();
        return result;
    }

    private static void extractDefnToXML(Document doc, String outPath) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outPath);
        StreamResult result = new StreamResult(outStream);
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(new DOMSource(doc), result);
        result = null;
        outStream.close();
    }
}

