/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.formats;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.formats.StreamParser;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.ContentEscape;
import org.eclipse.ohf.hl7v2.core.message.model.ContentText;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XMLParser
extends StreamParser {
    private static final String V2_XML_NS = "urn:hl7-org:v2xml";

    public XMLParser() {
    }

    public XMLParser(InputStream stream) {
        super(stream);
    }

    public void decode(Message message) throws HL7V2Exception {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput((InputStream)this.getStream(), null);
            int eventType = xpp.next();
            if (eventType != 2) {
                throw new XmlPullParserException("Unable to process XML document");
            }
            this.readMessage(xpp, message);
            message.resolveVariableTypes();
        }
        catch (Exception e) {
            throw new HL7V2Exception(e, 22);
        }
    }

    public void decode(Segment segment) throws HL7V2Exception {
        throw new HL7V2Exception("not implemented yet", 18);
    }

    public void decode(Field field) throws HL7V2Exception {
        throw new HL7V2Exception("not implemented yet", 18);
    }

    public void decode(Component component) throws HL7V2Exception {
        throw new HL7V2Exception("not implemented yet", 18);
    }

    private void readMessage(XmlPullParser xpp, Message message) throws HL7V2Exception, XmlPullParserException, IOException {
        if (V2_XML_NS != xpp.getNamespace()) {
            throw new XmlPullParserException("Root XML Element should be in the namespace 'urn:hl7-org:v2xml', but is in '" + xpp.getNamespace() + "'");
        }
        String name = xpp.getName();
        if (!(name.length() == 7 && name.charAt(3) == '_' && MessageStructureDefnList.isValidCode(name.substring(0, 3)) && EventDefnList.isValidCode(name.substring(4, 7)) || name.length() == 3 && MessageStructureDefnList.isValidCode(name.substring(0, 3)))) {
            throw new XmlPullParserException("Root XML Element should have an HL7 structure name, but is '" + name + "'");
        }
        xpp.next();
        while (xpp.getEventType() == 2 || xpp.getEventType() == 4) {
            if (xpp.getEventType() == 2) {
                this.readSegmentOrGroup(xpp, message);
                continue;
            }
            if (xpp.getText().trim().length() != 0) {
                throw new XmlPullParserException("Message XML is wrongly formed");
            }
            xpp.next();
        }
        if (xpp.getEventType() != 3) {
            throw new XmlPullParserException("Message XML is wrongly formed");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSegmentOrGroup(XmlPullParser xpp, Message message) throws HL7V2Exception, XmlPullParserException, IOException {
        block11: {
            name = xpp.getName();
            xpp.next();
            if (!Segment.isValidCode(name)) ** GOTO lbl32
            segment = new Segment();
            message.getSegments().add(segment);
            segment.setCode(name);
            segment.buildFields();
            while (xpp.getEventType() == 2 || xpp.getEventType() == 4) {
                if (xpp.getEventType() == 2) {
                    this.readSegmentContent(xpp, segment, name);
                    continue;
                }
                if (xpp.getText().trim().length() != 0) {
                    throw new XmlPullParserException("Segment '" + name + "' XML is wrongly formed");
                }
                xpp.next();
            }
            if (xpp.getEventType() != 3) {
                throw new XmlPullParserException("Segment '" + name + "' XML is wrongly formed");
            }
            xpp.next();
            if (!name.equals("MSH")) break block11;
            this.processMSH(segment);
            break block11;
lbl-1000:
            // 1 sources

            {
                if (xpp.getEventType() == 2) {
                    this.readSegmentOrGroup(xpp, message);
                    continue;
                }
                if (xpp.getText().trim().length() != 0) {
                    throw new XmlPullParserException("Segment Group '" + name + "' XML is wrongly formed");
                }
                xpp.next();
lbl32:
                // 3 sources

                ** while (xpp.getEventType() == 2 || xpp.getEventType() == 4)
            }
lbl33:
            // 1 sources

            if (xpp.getEventType() != 3) {
                throw new XmlPullParserException("Segment Group '" + name + "' XML is wrongly formed");
            }
            xpp.next();
        }
    }

    private void processMSH(Segment segment) throws NumberFormatException, HL7V2Exception {
        Message message = (Message)segment.getOwner().getOwner();
        message.setVersion(VersionDefnList.getVersion(segment.getElement("12").getAsString()));
        segment.buildFields();
        message.bindToMSH();
        this.processDelimiters(segment, message);
    }

    private void processDelimiters(Segment segment, Message message) throws HL7V2Exception {
        String s = segment.getElement("1").getAsString();
        message.getDelimiters().setFieldDelimiter(this.readDelimiter(s, 1, '|'));
        s = segment.getElement("2").getAsString();
        message.getDelimiters().setComponentDelimiter(this.readDelimiter(s, 1, '^'));
        message.getDelimiters().setRepetitionDelimiter(this.readDelimiter(s, 2, '~'));
        message.getDelimiters().setEscapeCharacter(this.readDelimiter(s, 3, '\\'));
        message.getDelimiters().setSubComponentDelimiter(this.readDelimiter(s, 4, '&'));
    }

    private char readDelimiter(String value, int index, char defaultValue) {
        if (value.length() >= index) {
            return value.charAt(index - 1);
        }
        return defaultValue;
    }

    private boolean isValidFieldName(String code, String name) {
        return name.length() > 4 && name.substring(0, 3).equals(code) && name.substring(3, 4).equals(".") && name.substring(4) != "";
    }

    private boolean isValidCellNamePattern(String name) {
        String[] parts = StringUtils.split((String)name, (String)".");
        return parts.length == 2 && parts[0] != null && StringUtils.isNumeric((String)parts[1]);
    }

    private void readSegmentContent(XmlPullParser xpp, Segment segment, String code) throws NumberFormatException, HL7V2Exception, XmlPullParserException, IOException {
        String name = xpp.getName();
        xpp.next();
        if (!this.isValidFieldName(code, name)) {
            throw new XmlPullParserException("unexpected element name " + name);
        }
        int index = Integer.parseInt(name.substring(4)) - 1;
        segment.forceElement(String.valueOf(index + 1));
        this.readCell(xpp, segment.getFields().item(index).addRepeat(true));
        xpp.next();
    }

    /*
     * Unable to fully structure code
     */
    private void readCell(XmlPullParser xpp, Cell cell) throws XmlPullParserException, IOException, HL7V2Exception {
        isText = null;
        eventType = xpp.getEventType();
        while (eventType != 3) {
            block9: {
                block8: {
                    if (eventType != 2 || !this.isValidCellNamePattern(xpp.getName())) break block8;
                    if (isText == null || !isText.booleanValue()) ** GOTO lbl18
                    throw new XmlPullParserException("cell '" + cell.elementName() + "' has both text and complex content at " + xpp.getName());
lbl-1000:
                    // 1 sources

                    {
                        name = xpp.getName();
                        xpp.next();
                        if (!this.isValidCellNamePattern(name)) {
                            throw new XmlPullParserException("Cell Name '" + name + "' is not valid at " + cell.elementName());
                        }
                        parts = StringUtils.split((String)name, (String)".");
                        this.readCell(xpp, cell.forceElement(parts[1]));
                        if (xpp.getEventType() != 3) {
                            throw new XmlPullParserException("Cell '" + cell.elementName() + "' XML is wrongly formed");
                        }
                        xpp.next();
lbl18:
                        // 2 sources

                        ** while (xpp.getEventType() == 2)
                    }
lbl19:
                    // 1 sources

                    break block9;
                }
                if (eventType == 4 || eventType == 2) {
                    if (xpp.getText().trim().length() > 0) {
                        if (isText != null && !isText.booleanValue()) {
                            throw new XmlPullParserException("Cell '" + cell.elementName() + "' has both text and complex content at " + xpp.getText());
                        }
                        this.readCellContent(xpp, cell);
                    } else {
                        xpp.next();
                    }
                }
            }
            eventType = xpp.getEventType();
        }
    }

    private void readCellContent(XmlPullParser xpp, Cell cell) throws XmlPullParserException, IOException, HL7V2Exception {
        int eventType = xpp.getEventType();
        while (eventType != 3) {
            if (eventType == 4) {
                if (xpp.getText().trim().length() > 0) {
                    int[] holderForStartAndLength = new int[2];
                    char[] ch = xpp.getTextCharacters(holderForStartAndLength);
                    cell.getContents().add(new ContentText(0, String.copyValueOf(ch, holderForStartAndLength[0], holderForStartAndLength[1])));
                }
            } else if (eventType == 2 && xpp.getName().equals("escape")) {
                cell.getContents().add(new ContentEscape(0, xpp.getAttributeValue(null, "V")));
                eventType = xpp.next();
            } else {
                throw new XmlPullParserException("unexpected content: " + xpp.getName());
            }
            eventType = xpp.next();
        }
    }
}

