/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.ItemIterator;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class ItemList
extends Item {
    private boolean owns;
    private Vector items = new Vector();

    public ItemList(Item owner, boolean owns) {
        super(owner);
        this.owns = owns;
        this.nodeType = 1;
    }

    public void clear() {
        this.items.clear();
    }

    public void clearContent() throws HL7V2Exception {
        int i = 0;
        while (i < this.size()) {
            this.itemNode(i).clearContent();
            ++i;
        }
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public boolean matches(Item obj, boolean path) throws HL7V2Exception {
        boolean result;
        boolean bl = result = super.matches(obj, path) && obj instanceof ItemList && this.size() == ((ItemList)obj).size();
        if (result) {
            ItemList other = (ItemList)obj;
            int i = 0;
            while (i < this.size()) {
                result = result && this.itemNode(i).matches(other.itemNode(i), false);
                ++i;
            }
        }
        return result;
    }

    protected Item itemNode(int index) {
        return (Item)this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    protected void add(Item node) throws HL7V2Exception {
        this.condition(!this.owns || node.getOwner() == null, "add a node to more than one list", 1);
        if (this.owns) {
            node.setOwner(this);
        }
        this.items.add(node);
    }

    protected void insert(Item node, int index) throws HL7V2Exception {
        this.condition(!this.owns || node.getOwner() == null, "add a node to more than one list", 1);
        if (this.owns) {
            node.setOwner(this);
        }
        this.items.insertElementAt(node, index);
    }

    protected void remove(int index) throws HL7V2Exception {
        if (this.owns) {
            this.itemNode(index).setOwner(null);
        }
        this.items.remove(index);
    }

    public int indexOfItem(Item node) {
        return this.items.indexOf(node);
    }

    public String elementName() throws HL7V2Exception {
        if (this.getOwner() != null) {
            return this.getOwner().elementName();
        }
        return "";
    }

    protected Item.ElementTestResult testIsElement(String name, boolean last) throws HL7V2Exception {
        if (this.hasOwner()) {
            return this.getOwner().testIsElement(name, false);
        }
        return new Item.ElementTestResult("", false);
    }

    public ItemIterator iteratorNode() {
        return this.makeIterator();
    }

    protected ItemIterator makeIterator() {
        return new ItemIterator(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.owns) {
            int i = 0;
            while (i < this.items.size()) {
                this.itemNode(i).setOwner(this);
                ++i;
            }
        }
    }
}

