/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.utilities;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventMessageDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;
import org.eclipse.ohf.utilities.OHFException;
import org.eclipse.ohf.utilities.xml.XHTMLWriter;

public class HTMLPublisher
extends Worker {
    private String title;
    private OutputStream stream;
    private boolean fullPage;
    private ByteArrayOutputStream content;
    private XHTMLWriter writer;
    private int descLength;

    public OutputStream getStream() {
        return this.stream;
    }

    public void setStream(OutputStream stream) throws UnsupportedEncodingException {
        this.stream = stream;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isFullPage() {
        return this.fullPage;
    }

    public void setFullPage(boolean fullPage) {
        this.fullPage = fullPage;
    }

    private void start() throws OHFException, IOException {
        this.content = new ByteArrayOutputStream();
        this.writer = new XHTMLWriter((OutputStream)this.content, "UTF-8");
        this.writer.setXmlHeader(false);
        this.writer.setHeaderStyle("font-family: Verdana, helv; font-size: 14");
        this.writer.start();
    }

    private void complete() throws IOException, OHFException {
        this.writer.close();
        if (this.fullPage) {
            XHTMLWriter w = new XHTMLWriter(this.stream, "UTF-8");
            w.start();
            w.openHtml();
            w.openHead();
            w.title(this.title);
            w.closeHead();
            w.openBody("margin: 0px; font-family: Verdana, helv; font-size: 10");
            w.writeBytes(this.content.toByteArray());
            w.closeBody();
            w.closeHtml();
            w.close();
        } else {
            this.stream.write(this.content.toByteArray());
        }
    }

    private void abort(Exception e) {
        e.printStackTrace();
        OutputStreamWriter w = new OutputStreamWriter(this.stream);
        try {
            w.write(e.getMessage());
            w.flush();
        }
        catch (IOException iOException) {}
    }

    public void publish(VersionDefnList versions, String path, String prefix) {
        try {
            this.start();
            this.writer.openSpan(null);
            URLParams params = new URLParams(path);
            VersionDefn version = versions.itemByVersion(params.param("version"));
            String url = String.valueOf(prefix) + "?version=" + params.param("version") + "&";
            String view = params.param("view");
            this.publishHeader(versions, params, version, url, view);
            try {
                if (view == null || view == "") {
                    this.publishVersionHome(version, url);
                } else if (view.equals("tables")) {
                    this.publishTables(version, params, url);
                } else if (view.equals("segments")) {
                    this.publishSegments(version, params, url);
                } else if (view.equals("context")) {
                    this.publishContext(version, params, url);
                } else if (view.equals("elements")) {
                    this.publishElements(version, params, url);
                } else if (view.equals("structures")) {
                    this.publishStructures(version, params, url);
                } else if (view.equals("events")) {
                    this.publishEvents(version, params, url);
                } else if (view.equals("msgtypes")) {
                    this.publishMessageTypes(version, params, url);
                } else {
                    throw new OHFException("View \"" + view + "\" not recognised");
                }
                this.writer.closeSpan();
            }
            catch (Exception e) {
                this.writer.closeToLevel(1);
                this.writer.span("color: Maroon", "Error: " + e.getMessage());
                this.writer.closeSpan();
            }
            this.complete();
        }
        catch (Exception e) {
            this.abort(e);
        }
    }

    private void publishHeader(VersionDefnList versions, URLParams params, VersionDefn version, String url, String view) throws OHFException, IOException {
        String link = "";
        int i = 0;
        while (i < params.size()) {
            if (!params.paramName(i).equals("version")) {
                link = String.valueOf(link) + '&' + params.paramName(i) + '=' + params.paramByIndex(i);
            }
            ++i;
        }
        this.writer.openTable(0, 2, 0, 100, "background-color: #C0C0C0; border-bottom: 1px black solid");
        this.writer.openTableRow();
        this.writer.openTableCell();
        this.writer.openTable(0, 0, 0, -1, null);
        this.writer.openTableRow();
        i = 0;
        while (i < versions.count()) {
            VersionDefn v = versions.item(i);
            this.writer.openTableCell("font-family: Verdana, helv; font-size: 12");
            this.writer.nonBreakingSpace(1);
            if (v.equals(version)) {
                if (view == null || view == "") {
                    this.writer.span("color: Maroon", params.param("version"));
                } else {
                    this.writer.anchor(url, params.param("version"), "color: Maroon; text-decoration: none");
                }
            } else {
                this.writer.anchor("?version=" + VersionDefnList.display(v.getVersion()) + link, VersionDefnList.display(v.getVersion()), "text-decoration: none; color: black");
            }
            this.writer.closeTableCell();
            ++i;
        }
        this.writer.closeTableRow();
        this.writer.closeTable();
        this.writer.closeTableCell();
        this.writer.closeTableRow();
        this.writer.closeTable();
    }

    private void publishVersionHome(VersionDefn version, String url) throws OHFException, IOException {
        this.title = "HL7 Version " + VersionDefnList.display(version.getVersion());
        this.writer.header(3, this.title);
        this.writer.anchor(String.valueOf(url) + "view=segments", "Segments");
        this.writer.br();
        this.writer.anchor(String.valueOf(url) + "view=elements", "Elements");
        this.writer.br();
        this.writer.anchor(String.valueOf(url) + "view=tables", "Tables");
        this.writer.br();
        this.writer.anchor(String.valueOf(url) + "view=structures", "Structures");
        this.writer.br();
        this.writer.anchor(String.valueOf(url) + "view=events", "Events");
        this.writer.br();
        this.writer.anchor(String.valueOf(url) + "view=msgtypes", "Message Types");
        this.writer.br();
    }

    private void publishTables(VersionDefn version, URLParams params, String url) throws OHFException, IOException {
        if (params.hasParam("tableid")) {
            this.publishTable(version, params, url);
        } else {
            this.title = "v" + VersionDefnList.display(version.getVersion()) + " Tables";
            this.writer.header(3, this.title);
            this.writer.openTable(0, 1, 0, 100, "font-family: Verdana, helv; font-size: 10");
            this.writer.openTableRow(-1);
            this.writer.tableCell("Id");
            this.writer.tableCellSpacer(1);
            this.writer.tableCell("Name");
            this.writer.closeTableRow();
            int i = 0;
            while (i < version.getTables().size()) {
                TableDefn tbl = version.getTables().item(i);
                if (tbl.getId() != 0) {
                    this.writer.openTableRow(i % 2);
                    this.writer.tableCell(StringUtils.leftPad((String)Integer.toString(tbl.getId()), (int)4, (char)'0'));
                    this.writer.tableCellSpacer(1);
                    this.writer.openTableCell();
                    this.writer.anchor(String.valueOf(url) + "view=tables&tableid=" + Integer.toString(tbl.getId()), tbl.getDescription());
                    this.writer.closeTableCell();
                    this.writer.closeTableRow();
                }
                ++i;
            }
            this.writer.closeTable();
        }
    }

    private void publishTable(VersionDefn version, URLParams params, String url) throws OHFException, IOException {
        this.title = "v" + VersionDefnList.display(version.getVersion()) + " Table " + params.param("tableid");
        TableDefn table = version.getTables().itemById(Integer.parseInt(params.param("tableid")));
        if (table == null) {
            this.writer.span("font-weight:bold;", "Table " + params.param("tableid") + " not defined in version V" + VersionDefnList.display(version.getVersion()));
        } else {
            this.title = String.valueOf(this.title) + " : " + table.getDescription();
            this.writer.header(3, this.title);
            this.writer.openTable(0, 1, 0, 100, "font-family: Verdana, helv; font-size: 10");
            this.writer.openTableRow(-1);
            this.writer.tableCell("Code");
            this.writer.tableCell("ID");
            this.writer.tableCell("Description");
            this.writer.closeTableRow();
            int i = 0;
            while (i < table.getItems().size()) {
                TableItemDefn item = table.getItems().item(i);
                this.writer.openTableRow(i % 2);
                this.writer.tableCell(item.getName());
                this.writer.tableCell(Integer.toString(item.getId()));
                this.writer.tableCell(item.getDescription());
                this.writer.closeTableRow();
                ++i;
            }
            this.writer.closeTable();
        }
    }

    private String viewDataType(DataTypeDefn dataType) {
        if (dataType.getLength() != 0) {
            return String.valueOf(dataType.getName()) + ": " + dataType.getDescription() + " (" + Integer.toString(dataType.getLength()) + ")";
        }
        return String.valueOf(dataType.getName()) + ": " + dataType.getDescription();
    }

    private void publishDataElement(DataElementDefn element, URLParams params, String url, boolean id) throws OHFException, IOException {
        StructureDefn struc = element.getStructure();
        if (id) {
            this.writer.tableCell("vertical-align: top", StringUtils.leftPad((String)Integer.toString(element.getId()), (int)4, (char)'0'));
        }
        this.writer.tableCell("vertical-align: top", this.cutDesc(element.getDescription()), element.getDescription());
        if (struc == null) {
            this.writer.tableCellSpacer(1);
        } else {
            this.publishStructure(struc, params, url, true, false, false, null, -1);
        }
        this.writer.tableCell("vertical-align: top", Integer.toString(element.getLength()));
        if (element.getTableId() == 0) {
            this.writer.tableCellSpacer(1);
        } else {
            this.writer.openTableCell("vertical-align: top");
            this.writer.anchor(String.valueOf(url) + "view=tables&tableid=" + Integer.toString(element.getTableId()), element.getTable().getName());
            this.writer.closeTableCell();
        }
    }

    private String cutDesc(String desc) {
        if (this.descLength > 0 && desc.length() > this.descLength) {
            return String.valueOf(desc.substring(0, this.descLength - 1)) + "...";
        }
        return desc;
    }

    private void publishField(FieldDefn field, URLParams params, String url) throws OHFException, IOException {
        DataElementDefn element = field.getDataElement();
        StructureDefn struc = element.getStructure();
        this.writer.tableCell("vertical-align: top", this.cutDesc(element.getDescription()), element.getDescription());
        this.writer.tableCell("vertical-align: top", field.isRequired() ? "Y" : null);
        this.publishStructure(struc, params, url, true, false, false, null, -1);
        this.writer.tableCell("vertical-align: top", Integer.toString(element.getLength()));
        if (element.getTableId() == 0) {
            this.writer.tableCellSpacer(1);
        } else {
            this.writer.openTableCell("vertical-align: top");
            this.writer.anchor(String.valueOf(url) + "view=tables&tableid=" + Integer.toString(element.getTableId()), element.getTable().getName());
            this.writer.closeTableCell();
        }
        this.writer.tableCell("vertical-align: top", field.isRepeatable() ? (field.getRepeatCount() == 0 ? "Y" : "Y" + Integer.toString(field.getRepeatCount())) : null);
    }

    private void publishContext(VersionDefn version, URLParams params, String url) throws OHFException, IOException {
        SegmentDefn segment = version.getSegments().itemByName(params.param("segmentid"));
        String context = segment.getName();
        if (params.hasParam("field")) {
            context = String.valueOf(context) + "-" + params.param("field");
        }
        if (params.hasParam("comp")) {
            context = String.valueOf(context) + "-" + params.param("comp");
        }
        if (params.hasParam("subcomp")) {
            context = String.valueOf(context) + "-" + params.param("subcomp");
        }
        this.writer.header(3, "Context: " + context);
        if (params.hasParam("field")) {
            FieldDefn field;
            DataElementDefn element;
            StructureDefn structure;
            int index = Integer.parseInt(params.param("field")) - 1;
            this.split("Segment");
            this.publishSegment(version, params, url, false, index);
            if (index < segment.getFields().size() && (structure = (element = (field = segment.getFields().item(index)).getDataElement()).getStructure()).getComponents().size() > 0) {
                this.split("Field");
                if (params.hasParam("comp")) {
                    index = Integer.parseInt(params.param("comp")) - 1;
                    this.publishStructure(structure, params, url, false, true, false, version, index);
                    if (index < field.getDataElement().getStructure().getComponents().size()) {
                        ComponentDefn comp = field.getDataElement().getStructure().getComponents().item(index);
                        structure = comp.getStructure();
                        if (structure.getComponents().size() > 0) {
                            this.split("Component");
                            index = Integer.parseInt(params.param("comp")) - 1;
                            this.publishStructure(structure, params, url, false, true, false, version, index);
                        }
                        if (params.hasParam("subcomp") && (index = Integer.parseInt(params.param("subcomp")) - 1) < structure.getComponents().size()) {
                            index = Integer.parseInt(params.param("comp"));
                            comp = structure.getComponents().item(index);
                            if ((structure = comp.getStructure()).getComponents().size() > 0) {
                                this.split("Sub-Component");
                                this.publishStructure(structure, params, url, false, true, false, version, index);
                            }
                        }
                    }
                } else {
                    this.publishStructure(structure, params, url, false, true, false, version, -1);
                }
            }
        } else {
            this.publishSegment(version, params, url, false, -1);
        }
        this.title = "v" + VersionDefnList.display(version.getVersion()) + " " + context;
    }

    private void split(String text) throws IOException {
        this.writer.hr(100);
        this.writer.header(5, text);
    }

    private void publishSegment(VersionDefn version, URLParams params, String url, boolean showEvents, int index) throws OHFException, IOException {
        this.title = "v" + VersionDefnList.display(version.getVersion()) + " Segment " + params.param("segmentid");
        SegmentDefn segment = version.getSegments().itemByName(params.param("segmentid"));
        if (segment == null) {
            this.writer.span("font-weight:bold;", "Segment " + params.param("segmentid") + " not defined in version V" + VersionDefnList.display(version.getVersion()));
        } else {
            int i;
            this.writer.header(3, "Segment " + segment.getName() + " " + segment.getDescription());
            this.writer.openTable(0, 1, 0, 100, "font-family: Verdana, helv; font-size: 10");
            this.writer.openTableRow(-1);
            this.writer.tableCell("vertical-align: top", "#");
            this.writer.tableCell("vertical-align: top", "Desc");
            this.writer.tableCell("vertical-align: top", "Req");
            this.writer.tableCell("vertical-align: top", "Type");
            this.writer.tableCell("vertical-align: top", "Size");
            this.writer.tableCell("vertical-align: top", "Tbl");
            this.writer.tableCell("vertical-align: top", "Rep");
            this.writer.closeTableRow();
            if (index == -1) {
                i = 0;
                while (i < segment.getFields().size()) {
                    this.writer.openTableRow(i % 2);
                    this.writer.tableCell("vertical-align: top", Integer.toString(i + 1));
                    this.publishField(segment.getFields().item(i), params, url);
                    this.writer.closeTableRow();
                    ++i;
                }
            } else {
                this.writer.openTableRow("background: yellow");
                this.writer.tableCell("vertical-align: top", Integer.toString(index + 1));
                this.publishField(segment.getFields().item(index), params, url);
                this.writer.closeTableRow();
            }
            this.writer.closeTable();
            this.writer.paragraph();
            if (showEvents) {
                this.writer.span("font-weight:bold;", "Events using this segment");
                this.writer.openList(false);
                i = 0;
                while (i < version.getEvents().size()) {
                    EventDefn event = version.getEvents().item(i);
                    int j = 0;
                    while (j < event.getMessages().size()) {
                        EventMessageDefn msg = event.getMessages().item(j);
                        if (msg.hasStructure() && msg.getStructure().usesSegment(segment)) {
                            this.writer.openItem();
                            this.writer.text(String.valueOf(event.getName()) + " : ");
                            this.writer.anchor(String.valueOf(url) + "view=msgtypes&msgid=" + msg.getStructure().getName(), msg.getStructure().getName());
                            this.writer.closeItem();
                        }
                        if (msg.hasReplyStructure() && msg.getReplyStructure().usesSegment(segment)) {
                            this.writer.openItem();
                            this.writer.text(String.valueOf(event.getName()) + " : ");
                            this.writer.anchor(String.valueOf(url) + "view=msgtypes&msgid=" + msg.getReplyStructure().getName(), msg.getReplyStructure().getName());
                            this.writer.closeItem();
                        }
                        ++j;
                    }
                    ++i;
                }
                this.writer.closeList(false);
            }
        }
    }

    private void publishSegments(VersionDefn version, URLParams params, String url) throws OHFException, IOException {
        if (params.hasParam("segmentid")) {
            this.publishSegment(version, params, url, true, -1);
        } else {
            this.title = "v" + VersionDefnList.display(version.getVersion()) + " Segments";
            this.writer.header(3, this.title);
            this.writer.openTable(0, 2, 0, 100, "font-family: Verdana, helv; font-size: 10");
            int i = 0;
            while (i < version.getSegments().size()) {
                SegmentDefn segment = version.getSegments().item(i);
                if (segment.getName().length() == 3) {
                    this.writer.openTableRow(i % 2);
                    this.writer.openTableCell();
                    this.writer.anchor(String.valueOf(url) + "view=segments&segmentid=" + segment.getName(), segment.getName());
                    this.writer.closeTableCell();
                    this.writer.tableCell(segment.getDescription());
                    this.writer.closeTableRow();
                }
                ++i;
            }
            this.writer.closeTable();
        }
    }

    private void publishElements(VersionDefn version, URLParams params, String url) throws OHFException, IOException {
        this.title = "v" + VersionDefnList.display(version.getVersion()) + " Elements";
        this.writer.span("font-weight:bold;", this.title);
        this.writer.paragraph();
        this.writer.openTable(0, 3, 0, 100, "font-family: Verdana, helv; font-size: 10");
        this.writer.openTableRow(-1);
        this.writer.tableCell("Id");
        this.writer.tableCell("Name");
        this.writer.tableCell("Type");
        this.writer.tableCell("Len");
        this.writer.tableCell("Tbl");
        this.writer.closeTableRow();
        int i = 0;
        while (i < version.getDataElements().size() - 1) {
            this.writer.openTableRow(i % 2);
            this.publishDataElement(version.getDataElements().item(i), params, url, true);
            this.writer.closeTableRow();
            ++i;
        }
        this.writer.closeTable();
    }

    private void publishComponent(ComponentDefn component, URLParams params, String url, boolean expand) throws OHFException, IOException {
        this.writer.tableCell("vertical-align: top", component.getName());
        if (component.getStructure() != null && component.getStructure().getComponents().size() > 0) {
            this.writer.openTableCell("vertical-align: top");
            this.writer.anchor(String.valueOf(url) + "view=structures&structureid=" + component.getStructure().getName(), this.viewDataType(component.getDatatype()));
            this.writer.closeTableCell();
        } else if (component.getDatatype() != null) {
            this.writer.tableCell("vertical-align: top", this.viewDataType(component.getDatatype()));
        } else {
            this.writer.tableCell("vertical-align: top", "Unknown Data Type");
        }
        if (component.getTable() != null) {
            this.writer.openTableCell("vertical-align: top");
            this.writer.anchor(String.valueOf(url) + "view=tables&tableid=" + Integer.toString(component.getTableId()), StringUtils.leftPad((String)Integer.toString(component.getTable().getId()), (int)4, (char)'0'));
            this.writer.text(" : " + component.getTable().getDescription());
            this.writer.closeTableCell();
        } else {
            this.writer.tableCell("vertical-align: top", null);
        }
    }

    private String cutName(String name) {
        int i = name.indexOf("_");
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    private void publishStructure(StructureDefn structure, URLParams params, String url, boolean quick, boolean structureTableView, boolean alterTitle, VersionDefn version, int index) throws OHFException, IOException {
        if (quick) {
            if (structure.getComponents().size() > 0) {
                this.writer.openTableCell("vertical-align: top");
                this.writer.anchor(String.valueOf(url) + "view=structures&structureid=" + structure.getName(), this.cutName(structure.getName()));
                this.writer.closeTableCell();
            } else if (structure.getDataType() != null) {
                this.writer.tableCell("vertical-align: top", structure.getDataTypeCode());
            }
            if (structureTableView) {
                this.writer.tableCell("vertical-align: top", structure.getDescription());
            }
        } else {
            this.title = "v" + VersionDefnList.display(version.getVersion()) + " Structure " + structure.getName();
            if (structure.getComponents().size() == 0) {
                this.writer.header(3, "Data Type " + structure.getName() + " has no components in this version of HL7");
            } else {
                this.writer.header(3, "Structure " + structure.getName());
                this.writer.paragraph(String.valueOf(structure.getDescription()) + " Components: ");
                this.writer.openTable(0, 1, 0, 100, "font-family: Verdana, helv; font-size: 10");
                this.writer.openTableRow(-1);
                this.writer.tableCell("ID");
                this.writer.tableCell("Name");
                this.writer.tableCell("Data Type");
                this.writer.tableCell("Table");
                this.writer.closeTableRow();
                if (index == -1) {
                    int i = 0;
                    while (i < structure.getComponents().size()) {
                        this.writer.openTableRow(i % 2);
                        this.writer.tableCell(Integer.toString(i + 1));
                        this.publishComponent(structure.getComponents().item(i), params, url, true);
                        this.writer.closeTableRow();
                        ++i;
                    }
                } else {
                    this.writer.openTableRow("background: yellow");
                    this.writer.tableCell(Integer.toString(index + 1));
                    this.publishComponent(structure.getComponents().item(index), params, url, true);
                    this.writer.closeTableRow();
                }
                this.writer.closeTable();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void publishStructures(VersionDefn version, URLParams params, String url) throws OHFException, IOException {
        if (params.hasParam("structureid")) {
            if (version.getStructures().itemByName(params.param("structureid")) == null) throw new OHFException("Structure '" + params.param("structureid") + "' not found");
            this.publishStructure(version.getStructures().itemByName(params.param("structureid")), params, url, false, true, false, version, -1);
            return;
        } else {
            this.title = "v" + VersionDefnList.display(version.getVersion()) + " Structures";
            this.writer.span("font-weight:bold", this.title);
            this.writer.openTable(0, 1, 0, 100, "font-family: Verdana, helv; font-size: 10");
            this.writer.openTableRow(-1);
            this.writer.tableCell("Type");
            this.writer.tableCell("Description");
            this.writer.closeTableRow();
            int i = 0;
            while (i < version.getStructures().size()) {
                if (version.getStructures().item(i).getName().length() < 3 || !version.getStructures().item(i).getName().substring(0, 3).equals("CE_")) {
                    this.writer.openTableRow(i % 2);
                    this.publishStructure(version.getStructures().item(i), params, url, true, true, false, null, -1);
                    this.writer.closeTableRow();
                }
                ++i;
            }
            this.writer.closeTable();
        }
    }

    private String viewMessageSummary(EventDefn event, URLParams params, String url) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < event.getMessages().size()) {
            EventMessageDefn msg = event.getMessages().item(i);
            buff.append(String.valueOf(msg.getMessage()) + ":" + msg.getReply());
            ++i;
        }
        return buff.toString();
    }

    private void publishEvent(EventDefn event, URLParams params, String url, VersionDefn version, boolean setTitle) throws OHFException, IOException {
        if (setTitle) {
            this.title = "v" + VersionDefnList.display(version.getVersion()) + " Event " + event.getName();
        }
        this.writer.header(3, "v" + VersionDefnList.display(version.getVersion()) + " Event " + event.getName());
        EventMessageDefn msg = null;
        if (event.getMessages().size() == 1) {
            msg = event.getMessages().item(0);
            this.writer.span("font-weight:bold;", "Message: " + msg.getMessage() + "/" + msg.getStructureCode());
            if (msg.getStructure() != null) {
                this.publishMessageType(version, msg.getStructure(), params, url, false, false);
            }
            this.writer.paragraph();
            this.writer.span("font-weight:bold;", "Reply: " + msg.getReply() + "/" + msg.getReplyStructureCode());
            if (msg.getReplyStructure() != null) {
                this.publishMessageType(version, msg.getReplyStructure(), params, url, false, false);
            }
        } else {
            this.writer.openList(false);
            int i = 0;
            while (i < event.getMessages().size()) {
                msg = event.getMessages().item(i);
                this.writer.openItem();
                this.writer.text("Message: " + msg.getMessage() + "/" + msg.getStructureCode() + "; Reply : " + msg.getReply() + "/" + msg.getReplyStructureCode());
                this.writer.closeItem();
                ++i;
            }
            this.writer.closeList(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void publishEvents(VersionDefn version, URLParams params, String url) throws OHFException, IOException {
        if (params.hasParam("eventid")) {
            if (version.getEvents().itemByName(params.param("eventid")) == null) throw new OHFException("Event '" + params.param("eventid") + "' not found");
            this.publishEvent(version.getEvents().itemByName(params.param("eventid")), params, url, version, false);
            return;
        } else {
            this.title = "v" + VersionDefnList.display(version.getVersion()) + " Events";
            this.writer.header(3, this.title);
            this.writer.openTable(0, 1, 0, 100, "font-family: Verdana, helv; font-size: 10");
            this.writer.openTableRow(-1);
            this.writer.tableCell("Code");
            this.writer.tableCellSpacer(1);
            this.writer.tableCell("Description");
            this.writer.closeTableRow();
            int i = 0;
            while (i < version.getEvents().size()) {
                EventDefn event = version.getEvents().item(i);
                this.writer.openTableRow(i % 2);
                this.writer.openTableCell();
                this.writer.anchor(String.valueOf(url) + "view=events&eventid=" + event.getName(), event.getName());
                this.writer.closeTableCell();
                this.writer.tableCellSpacer(1);
                this.writer.tableCell(String.valueOf(event.getDescription()) + ": " + this.viewMessageSummary(event, params, url));
                this.writer.closeTableRow();
                ++i;
            }
            this.writer.closeTable();
        }
    }

    private String describeCardinality(SegmentGroupDefn group) {
        String result = group.isOptional() ? "0.." : "1..";
        result = group.isRepeating() ? String.valueOf(result) + "*" : String.valueOf(result) + "1";
        return result;
    }

    private void publishSegmentMap(SegmentGroupDefn group, URLParams params, String url, int iLevel) throws OHFException, IOException {
        if (group == null) {
            this.writer.openTableRow();
            this.writer.tableCell("not loaded");
            this.writer.tableCellSpacer(1);
            this.writer.closeTableRow();
        } else if (group.getGroupType() == 0) {
            this.writer.openTableRow();
            this.writer.openTableCell();
            this.writer.nonBreakingSpace(iLevel * 3);
            this.writer.anchor(String.valueOf(url) + "view=segments&segmentid=" + group.getName(), group.getName());
            this.writer.closeTableCell();
            this.writer.tableCell(this.describeCardinality(group));
            this.writer.closeTableRow();
        } else {
            if (iLevel > 0) {
                this.writer.openTableRow();
                this.writer.openTableCell();
                this.writer.nonBreakingSpace(iLevel * 3);
                if (group.getGroupType() == 2) {
                    this.writer.text("<Choice of:");
                } else {
                    if (group.isOptional()) {
                        this.writer.text("[");
                    }
                    if (group.isRepeating()) {
                        this.writer.text("{");
                    }
                    this.writer.text(group.getName());
                }
                this.writer.closeTableCell();
                this.writer.tableCell(this.describeCardinality(group));
                this.writer.closeTableRow();
            }
            int i = 0;
            while (i < group.getChildren().size()) {
                this.publishSegmentMap(group.getChildren().item(i), params, url, iLevel + 1);
                ++i;
            }
            if (iLevel > 0) {
                if (group.getGroupType() == 2) {
                    this.writer.openTableRow();
                    this.writer.openTableCell();
                    this.writer.nonBreakingSpace(iLevel * 3);
                    this.writer.text(">");
                    this.writer.closeTableCell();
                    this.writer.tableCellSpacer(1);
                    this.writer.closeTableRow();
                } else {
                    this.writer.openTableRow();
                    this.writer.openTableCell();
                    this.writer.nonBreakingSpace(iLevel * 3);
                    if (group.isRepeating()) {
                        this.writer.text("}");
                    }
                    if (group.isOptional()) {
                        this.writer.text("]");
                    }
                    this.writer.closeTableCell();
                    this.writer.tableCellSpacer(1);
                    this.writer.closeTableRow();
                }
            }
        }
    }

    private void publishMessageType(VersionDefn version, MessageStructureDefn struc, URLParams params, String url, boolean bEvents, boolean bTitle) throws OHFException, IOException {
        String sTitle = "v" + VersionDefnList.display(version.getVersion()) + " Message Type " + struc.getName();
        this.writer.header(3, sTitle);
        if (bTitle) {
            this.title = sTitle;
        }
        this.writer.openTable(0, 1, 0, 100, "font-family: Verdana, helv; font-size: 10");
        this.writer.openTableRow(-1);
        this.writer.tableCell("Segment");
        this.writer.tableCell("Cardinality");
        this.writer.closeTableRow();
        this.publishSegmentMap(struc.getMap(), params, url, 0);
        this.writer.closeTable();
        if (bEvents && version != null) {
            this.writer.span("font-weight:bold;", "Events using this structure");
            this.writer.openList(false);
            int i = 0;
            while (i < version.getEvents().size()) {
                EventDefn event = version.getEvents().item(i);
                if (event.usesStructure(struc)) {
                    this.writer.openItem();
                    this.writer.anchor(String.valueOf(url) + "view=events&eventid=" + event.getName(), event.getName());
                    this.writer.text(" : " + event.getDescription());
                    this.writer.closeItem();
                }
                ++i;
            }
            this.writer.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void publishMessageTypes(VersionDefn version, URLParams params, String url) throws OHFException, IOException {
        if (params.hasParam("msgid")) {
            if (version.getMessageStructures().itemByName(params.param("msgid")) == null) throw new OHFException("Message Type '" + params.param("msgid") + "' not found");
            this.publishMessageType(version, version.getMessageStructures().itemByName(params.param("msgid")), params, url, true, false);
            return;
        } else {
            this.writer.header(3, "v" + VersionDefnList.display(version.getVersion()) + " Message Types");
            this.writer.openList(false);
            int i = 0;
            while (i < version.getMessageStructures().size()) {
                this.writer.openItem();
                this.writer.anchor(String.valueOf(url) + "view=msgtypes&msgid=" + version.getMessageStructures().item(i).getName(), version.getMessageStructures().item(i).getName());
                this.writer.closeItem();
                ++i;
            }
            this.writer.closeList(false);
        }
    }

    public int getDescLength() {
        return this.descLength;
    }

    public void setDescLength(int descLength) {
        this.descLength = descLength;
    }

    public class URLParams
    extends HashMap {
        private static final long serialVersionUID = 1L;
        private Vector names = new Vector();

        public URLParams(String path) {
            String[] pathParts = StringUtils.split((String)("_" + path), (char)'?');
            if (pathParts.length > 1) {
                String[] params = StringUtils.split((String)pathParts[1], (char)'&');
                int i = 0;
                while (i < params.length) {
                    String[] parts = StringUtils.split((String)params[i], (char)'=');
                    this.put(parts[0], parts[1]);
                    this.names.add(parts[0]);
                    ++i;
                }
            }
        }

        public String param(String name) {
            return (String)this.get(name);
        }

        public String paramName(int index) {
            return (String)this.names.get(index);
        }

        public String paramByIndex(int index) {
            return this.param(this.paramName(index));
        }

        public boolean hasParam(String name) {
            return this.names.contains(name);
        }
    }
}

