/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pdq.consumer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.message.ParsingOptions;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.HL7_Constants;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.Client;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerDemographicQuery;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerResponse;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerVisitQuery;

public class PdqConsumer
extends Client
implements HL7_Constants {
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.pdq.consumer.PdqConsumer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public PdqConsumer() throws ClientException {
    }

    public PdqConsumer(InputStream conformanceProfile) throws ClientException {
        super(conformanceProfile);
    }

    public PdqConsumerDemographicQuery createDemographicQuery() throws PdqConsumerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: createDemographicQuery - Entry ");
        }
        PdqConsumerDemographicQuery query = new PdqConsumerDemographicQuery(this.getMessageManager(), this.getCPProfile());
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = query.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: createDemographicQuery - Exit controlId: " + controlId));
        }
        return query;
    }

    public PdqConsumerVisitQuery createVisitQuery() throws PdqConsumerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: createVisitQuery - Entry ");
        }
        PdqConsumerVisitQuery query = new PdqConsumerVisitQuery(this.getMessageManager(), this.getCPProfile());
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = query.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: createVisitQuery - Exit controlId: " + controlId));
        }
        return query;
    }

    public String sendDemographicQuery(String rawHL7, boolean verify) throws PdqConsumerException {
        String queryResponse = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: sendQuery - Entry ");
        }
        try {
            queryResponse = this.sendHL7(rawHL7, verify, "OHF_PdqConsumer");
        }
        catch (ClientException e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: sendQuery - Exit ");
        }
        return queryResponse;
    }

    public Message sendDemographicQuery(Message msg, boolean verify) throws PdqConsumerException {
        Message queryResponse = null;
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: sendQuery - Entry controlId: " + controlId + " run verification? " + verify + " user: " + PixPdqMessageUtilities.getAuditUser()));
        }
        try {
            queryResponse = this.sendMsg(msg, verify, "OHF_PdqConsumer");
        }
        catch (ClientException e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PdqConsumer: sendQuery - Exit controlId: " + controlId));
        }
        return queryResponse;
    }

    public PdqConsumerResponse sendDemographicQuery(PdqConsumerDemographicQuery msg, boolean verify) throws PdqConsumerException {
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: sendQuery - Entry controlId: " + controlId + " run verification? " + verify + " user: " + PixPdqMessageUtilities.getAuditUser()));
        }
        PdqConsumerResponse pdqRsp = this.sendPdqQuery((Message)msg, verify);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PdqConsumer: sendQuery - Exit controlId: " + controlId));
        }
        return pdqRsp;
    }

    public String sendVisitQuery(String rawHL7, boolean verify) throws PdqConsumerException {
        String queryResponse = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: sendQuery - Entry ");
        }
        try {
            queryResponse = this.sendHL7(rawHL7, verify, "OHF_PdqVisitConsumer");
        }
        catch (ClientException e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumer: sendQuery - Exit ");
        }
        return queryResponse;
    }

    public Message sendVisitQuery(Message msg, boolean verify) throws PdqConsumerException {
        Message queryResponse = null;
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: sendVisitQuery - Entry controlId: " + controlId + " run verification? " + verify + " user: " + PixPdqMessageUtilities.getAuditUser()));
        }
        try {
            queryResponse = this.sendMsg(msg, verify, "OHF_PdqVisitConsumer");
        }
        catch (ClientException e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PdqConsumer: sendQuery - Exit controlId: " + controlId));
        }
        return queryResponse;
    }

    public PdqConsumerResponse sendVisitQuery(PdqConsumerVisitQuery msg, boolean verify) throws PdqConsumerException {
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement("MSH-10").getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PdqConsumer: sendVisitQuery - Entry controlId: " + controlId + " run verification? " + verify + " user: " + PixPdqMessageUtilities.getAuditUser()));
        }
        PdqConsumerResponse pdqRsp = this.sendPdqQuery((Message)msg, verify);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PdqConsumer: sendVisitQuery - Exit controlId: " + controlId));
        }
        return pdqRsp;
    }

    private PdqConsumerResponse sendPdqQuery(Message query, boolean verify) throws PdqConsumerException {
        String hl7;
        Message msgResponse = null;
        PdqConsumerResponse queryResponse = new PdqConsumerResponse(this.getMessageManager());
        try {
            msgResponse = this.sendMsg(query, verify, "OHF_PdqConsumer");
            hl7 = PixPdqMessageUtilities.msgToString((Message)msgResponse);
        }
        catch (ClientException e) {
            throw new PdqConsumerException(e);
        }
        catch (PixPdqMessageException e) {
            throw new PdqConsumerException(e);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(hl7.getBytes());
        ParsingOptions pOptions = new ParsingOptions();
        try {
            pOptions.setFormat(1);
            if (hl7.compareTo("") == 0) {
                return queryResponse;
            }
            this.getMessageManager().load((InputStream)inStream, (Message)queryResponse, pOptions);
            queryResponse.init();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return queryResponse;
    }
}

