/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.config.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.ohf.ihe.common.config.Audit;
import org.eclipse.ohf.ihe.common.config.ConfigFactory;
import org.eclipse.ohf.ihe.common.config.ConfigPackage;
import org.eclipse.ohf.ihe.common.config.ConfigType;
import org.eclipse.ohf.ihe.common.config.DocumentRoot;
import org.eclipse.ohf.ihe.common.config.IheUri;
import org.eclipse.ohf.ihe.common.config.MessageQueryName;
import org.eclipse.ohf.ihe.common.config.Pix;
import org.eclipse.ohf.ihe.common.config.PixProperties;
import org.eclipse.ohf.ihe.common.config.Registry;
import org.eclipse.ohf.ihe.common.config.Repository;
import org.eclipse.ohf.ihe.common.config.Rhio;
import org.eclipse.ohf.ihe.common.config.RhioConfigurationsType;
import org.eclipse.ohf.ihe.common.config.XcaGateway;
import org.eclipse.ohf.ihe.common.config.XdsVersion;
import org.eclipse.ohf.ihe.common.config.impl.AuditImpl;
import org.eclipse.ohf.ihe.common.config.impl.ConfigTypeImpl;
import org.eclipse.ohf.ihe.common.config.impl.DocumentRootImpl;
import org.eclipse.ohf.ihe.common.config.impl.IheUriImpl;
import org.eclipse.ohf.ihe.common.config.impl.MessageQueryNameImpl;
import org.eclipse.ohf.ihe.common.config.impl.PixImpl;
import org.eclipse.ohf.ihe.common.config.impl.PixPropertiesImpl;
import org.eclipse.ohf.ihe.common.config.impl.RegistryImpl;
import org.eclipse.ohf.ihe.common.config.impl.RepositoryImpl;
import org.eclipse.ohf.ihe.common.config.impl.RhioConfigurationsTypeImpl;
import org.eclipse.ohf.ihe.common.config.impl.RhioImpl;
import org.eclipse.ohf.ihe.common.config.impl.XcaGatewayImpl;

public class ConfigFactoryImpl
extends EFactoryImpl
implements ConfigFactory {
    public static ConfigFactory init() {
        try {
            ConfigFactory theConfigFactory = (ConfigFactory)EPackage.Registry.INSTANCE.getEFactory("http://config.common.ihe.ohf.eclipse.org");
            if (theConfigFactory != null) {
                return theConfigFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ConfigFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createAudit();
            }
            case 1: {
                return this.createConfigType();
            }
            case 2: {
                return this.createDocumentRoot();
            }
            case 3: {
                return this.createIheUri();
            }
            case 4: {
                return this.createMessageQueryName();
            }
            case 5: {
                return this.createPix();
            }
            case 6: {
                return this.createPixProperties();
            }
            case 7: {
                return this.createRegistry();
            }
            case 8: {
                return this.createRepository();
            }
            case 9: {
                return this.createRhio();
            }
            case 10: {
                return this.createRhioConfigurationsType();
            }
            case 11: {
                return this.createXcaGateway();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.createXdsVersionFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createXdsVersionObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.convertXdsVersionToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertXdsVersionObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Audit createAudit() {
        AuditImpl audit = new AuditImpl();
        return audit;
    }

    public ConfigType createConfigType() {
        ConfigTypeImpl configType = new ConfigTypeImpl();
        return configType;
    }

    public DocumentRoot createDocumentRoot() {
        DocumentRootImpl documentRoot = new DocumentRootImpl();
        return documentRoot;
    }

    public IheUri createIheUri() {
        IheUriImpl iheUri = new IheUriImpl();
        return iheUri;
    }

    public MessageQueryName createMessageQueryName() {
        MessageQueryNameImpl messageQueryName = new MessageQueryNameImpl();
        return messageQueryName;
    }

    public Pix createPix() {
        PixImpl pix = new PixImpl();
        return pix;
    }

    public PixProperties createPixProperties() {
        PixPropertiesImpl pixProperties = new PixPropertiesImpl();
        return pixProperties;
    }

    public Registry createRegistry() {
        RegistryImpl registry = new RegistryImpl();
        return registry;
    }

    public Repository createRepository() {
        RepositoryImpl repository = new RepositoryImpl();
        return repository;
    }

    public Rhio createRhio() {
        RhioImpl rhio = new RhioImpl();
        return rhio;
    }

    public RhioConfigurationsType createRhioConfigurationsType() {
        RhioConfigurationsTypeImpl rhioConfigurationsType = new RhioConfigurationsTypeImpl();
        return rhioConfigurationsType;
    }

    public XcaGateway createXcaGateway() {
        XcaGatewayImpl xcaGateway = new XcaGatewayImpl();
        return xcaGateway;
    }

    public XdsVersion createXdsVersionFromString(EDataType eDataType, String initialValue) {
        XdsVersion result = XdsVersion.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertXdsVersionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public XdsVersion createXdsVersionObjectFromString(EDataType eDataType, String initialValue) {
        return this.createXdsVersionFromString((EDataType)ConfigPackage.Literals.XDS_VERSION, initialValue);
    }

    public String convertXdsVersionObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertXdsVersionToString((EDataType)ConfigPackage.Literals.XDS_VERSION, instanceValue);
    }

    public ConfigPackage getConfigPackage() {
        return (ConfigPackage)this.getEPackage();
    }

    public static ConfigPackage getPackage() {
        return ConfigPackage.eINSTANCE;
    }
}

