/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.cdar2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class CompressionAlgorithm
extends AbstractEnumerator {
    public static final int DF = 0;
    public static final int GZ = 1;
    public static final int Z = 2;
    public static final int ZL = 3;
    public static final CompressionAlgorithm DF_LITERAL = new CompressionAlgorithm(0, "DF", "DF");
    public static final CompressionAlgorithm GZ_LITERAL = new CompressionAlgorithm(1, "GZ", "GZ");
    public static final CompressionAlgorithm Z_LITERAL = new CompressionAlgorithm(2, "Z", "Z");
    public static final CompressionAlgorithm ZL_LITERAL = new CompressionAlgorithm(3, "ZL", "ZL");
    private static final CompressionAlgorithm[] VALUES_ARRAY = new CompressionAlgorithm[]{DF_LITERAL, GZ_LITERAL, Z_LITERAL, ZL_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static CompressionAlgorithm get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompressionAlgorithm result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompressionAlgorithm getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompressionAlgorithm result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompressionAlgorithm get(int value) {
        switch (value) {
            case 0: {
                return DF_LITERAL;
            }
            case 1: {
                return GZ_LITERAL;
            }
            case 2: {
                return Z_LITERAL;
            }
            case 3: {
                return ZL_LITERAL;
            }
        }
        return null;
    }

    private CompressionAlgorithm(int value, String name, String literal) {
        super(value, name, literal);
    }
}

