/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.cdar2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ValignType
extends AbstractEnumerator {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int BASELINE = 3;
    public static final ValignType TOP_LITERAL = new ValignType(0, "top", "top");
    public static final ValignType MIDDLE_LITERAL = new ValignType(1, "middle", "middle");
    public static final ValignType BOTTOM_LITERAL = new ValignType(2, "bottom", "bottom");
    public static final ValignType BASELINE_LITERAL = new ValignType(3, "baseline", "baseline");
    private static final ValignType[] VALUES_ARRAY = new ValignType[]{TOP_LITERAL, MIDDLE_LITERAL, BOTTOM_LITERAL, BASELINE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ValignType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValignType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValignType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValignType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValignType get(int value) {
        switch (value) {
            case 0: {
                return TOP_LITERAL;
            }
            case 1: {
                return MIDDLE_LITERAL;
            }
            case 2: {
                return BOTTOM_LITERAL;
            }
            case 3: {
                return BASELINE_LITERAL;
            }
        }
        return null;
    }

    private ValignType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

