/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.AuditSourceIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.ParticipantObjectIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.syslog.util.SyslogUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AuditMessage {
    Logger logger;
    public static String DB_AuditMessage = "atna_message";
    public static int VARCHAR_LENGTH = 200;
    private String eventDateTime;
    private Element auditMessageNode;
    private Document doc;
    private String messagetype;
    protected EventIdentificationType eventIdentification;
    private Node EventIdentificationNode;
    private Node auditSourceIdentificatinNode;
    private ParticipantObjectIdentificationType participantObject;
    private ActiveParticipantType activeParticipantDocRegistry;
    private ActiveParticipantType activeParticipantDocConsumer;
    protected List activeParticipant;
    protected List auditSourceIdentification;
    protected List participantObjectIdentification;
    static /* synthetic */ Class class$0;

    protected AuditMessage() throws ATNAException, ParserConfigurationException, FactoryConfigurationError {
        this(null);
    }

    public AuditMessage(String auditSourceId) throws ATNAException, ParserConfigurationException, FactoryConfigurationError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = Logger.getLogger((Class)clazz);
        this.eventDateTime = "";
        this.messagetype = "";
        this.EventIdentificationNode = null;
        this.auditSourceIdentificatinNode = null;
        this.activeParticipantDocRegistry = null;
        this.activeParticipantDocConsumer = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.newDocument();
        this.auditMessageNode = this.doc.createElement("AuditMessage");
        this.auditMessageNode.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.auditMessageNode.setAttribute("xsi:noNamespaceSchemaLocation", "healthcare-security-audit.xsd");
        this.eventIdentification = new EventIdentificationType();
        this.setEventIdentification(this.eventIdentification);
        this.activeParticipant = new LinkedList();
        this.auditSourceIdentification = new LinkedList();
        AuditSourceIdentificationType auditSource = new AuditSourceIdentificationType();
        String sourceId = null;
        if (auditSourceId != null && !auditSourceId.equals("")) {
            sourceId = auditSourceId;
        } else {
            this.logger.warn((Object)"Defaulting to IP Address for AuditSourceID.  This should be set by calling setAuditSourceId.");
            InetAddress addr = null;
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {}
            if (addr != null) {
                sourceId = addr.getHostAddress();
            }
        }
        if (sourceId == null) {
            this.logger.fatal((Object)"Unable to produce audit message.  The audit source id is not set.");
            throw new ATNAException("The audit source id is not set.");
        }
        auditSource.setAuditSourceID(sourceId);
        this.setAuditSourceIdentification(auditSource);
        this.participantObjectIdentification = new LinkedList();
    }

    public void setEventOutcomeIndicator(int eventOutcomeIndicator) {
        if (this.getEventIdentification() != null) {
            try {
                this.getEventIdentification().setEventOutcomeIndicator(eventOutcomeIndicator);
            }
            catch (ATNAException e) {
                e.printStackTrace();
            }
        }
    }

    public void setEventDateTime(String eventDateTime) {
        if (this.getEventIdentification() != null) {
            this.getEventIdentification().setEventDateTime(eventDateTime);
        }
    }

    public EventIdentificationType getEventIdentification() {
        return this.eventIdentification;
    }

    public void setEventIdentification(EventIdentificationType value) {
        this.eventIdentification = value;
        Node n = this.doc.importNode(value.getEventIdentificationNode(), true);
        if (this.EventIdentificationNode == null) {
            this.auditMessageNode.appendChild(n);
            this.EventIdentificationNode = n;
        } else {
            this.auditMessageNode.replaceChild(n, this.EventIdentificationNode);
            this.EventIdentificationNode = n;
        }
    }

    private List getActiveParticipant() {
        if (this.activeParticipant == null) {
            this.activeParticipant = new ArrayList();
        }
        return this.activeParticipant;
    }

    public void setActiveParticipant(ActiveParticipantType participant) {
        this.getActiveParticipant().add(participant);
        Node n = this.doc.importNode(participant.getActiveParticipantNode(), true);
        if (this.auditSourceIdentificatinNode == null) {
            this.auditMessageNode.appendChild(n);
        } else {
            this.auditMessageNode.insertBefore(n, this.auditSourceIdentificatinNode);
        }
    }

    public List getAuditSourceIdentification() {
        if (this.auditSourceIdentification == null) {
            this.auditSourceIdentification = new ArrayList();
        }
        return this.auditSourceIdentification;
    }

    public void setAuditSourceIdentification(AuditSourceIdentificationType identificationType) {
        this.getAuditSourceIdentification().add(identificationType);
        Node n = this.doc.importNode(identificationType.getAuditSourceIdentificationNode(), true);
        if (this.auditSourceIdentificatinNode == null) {
            this.auditSourceIdentificatinNode = n;
            this.auditMessageNode.appendChild(n);
        } else {
            Node next = this.auditSourceIdentificatinNode.getNextSibling();
            if (next == null) {
                this.auditMessageNode.appendChild(n);
            } else {
                this.auditMessageNode.insertBefore(n, next);
            }
            this.auditSourceIdentificatinNode = n;
        }
        this.auditMessageNode.appendChild(n);
    }

    public List getParticipantObjectIdentification() {
        if (this.participantObjectIdentification == null) {
            this.participantObjectIdentification = new ArrayList();
        }
        return this.participantObjectIdentification;
    }

    public void setParticipationObjectIdentification(ParticipantObjectIdentificationType participantObject) {
        this.getParticipantObjectIdentification().add(participantObject);
        Node n = this.doc.importNode(participantObject.getParticipantObjectIdentificationNode(), true);
        this.auditMessageNode.appendChild(n);
    }

    public String toHtml() {
        StringBuffer finalString = new StringBuffer();
        finalString.append(this.eventIdentification.toHtml());
        int i = 0;
        while (i < this.activeParticipant.size()) {
            finalString.append(((ActiveParticipantType)this.activeParticipant.get(i)).toHtml(i + 1));
            ++i;
        }
        i = 0;
        while (i < this.auditSourceIdentification.size()) {
            finalString.append(((AuditSourceIdentificationType)this.auditSourceIdentification.get(i)).toHtml());
            ++i;
        }
        i = 0;
        while (i < this.participantObjectIdentification.size()) {
            finalString.append(((ParticipantObjectIdentificationType)this.participantObjectIdentification.get(i)).toHtml());
            ++i;
        }
        return finalString.toString();
    }

    public String toXml() {
        return SyslogUtil.XMLElementToString(this.auditMessageNode);
    }

    public static boolean IsValid(Element el) {
        if (el.getNodeName().equals("AuditMessage")) {
            NodeList childNodes = el.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element childElement;
                if (childNodes.item(i).getNodeType() == 1 && ((childElement = (Element)childNodes.item(i)).getNodeName().equals("EventIdentification") ? !EventIdentificationType.isValidElement(childElement) : (childElement.getNodeName().equals("ActiveParticipant") ? !ActiveParticipantType.isValidElement(childElement) : (childElement.getNodeName().equals("AuditSourceIdentification") ? !AuditSourceIdentificationType.isValidElement(childElement) : childElement.getNodeName().equals("ParticipantObjectIdentification") && !ParticipantObjectIdentificationType.IsValidElement(childElement))))) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public void parse(Element el) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        if (AuditMessage.IsValid(el)) {
            NodeList childNodes = el.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                if (childNodes.item(i).getNodeType() == 1) {
                    Element childElement = (Element)childNodes.item(i);
                    if (childElement.getNodeName().equals("EventIdentification")) {
                        EventIdentificationType eventIdentificationType = new EventIdentificationType();
                        eventIdentificationType.parse(childElement);
                        this.setEventIdentification(eventIdentificationType);
                    } else if (childElement.getNodeName().equals("ActiveParticipant")) {
                        ActiveParticipantType active = new ActiveParticipantType();
                        active.parse(childElement);
                        this.setActiveParticipant(active);
                    } else if (childElement.getNodeName().equals("AuditSourceIdentification")) {
                        AuditSourceIdentificationType auditSource = new AuditSourceIdentificationType();
                        auditSource.parse(childElement);
                        this.setAuditSourceIdentification(auditSource);
                    } else if (childElement.getNodeName().equals("ParticipantObjectIdentification")) {
                        ParticipantObjectIdentificationType participant = new ParticipantObjectIdentificationType();
                        participant.parse(childElement);
                        this.setParticipationObjectIdentification(participant);
                    }
                }
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        try {
            AuditMessage message = new AuditMessage("EHR_IBM");
            EventIdentificationType eventId = new EventIdentificationType(0);
            eventId.setEventActionCode("E");
            CodedValueType valueType = new CodedValueType();
            valueType.setCode("110112");
            valueType.setCodeSystemName("DCM");
            valueType.setDisplayName("Query");
            eventId.setEventID(valueType);
            message.setEventIdentification(eventId);
            ActiveParticipantType active = new ActiveParticipantType("AWT-EventQueue-0");
            active.setUserIsRequestor(false);
            active.setUserName("com.ibm.ihii.xdsconsumer.Consumer");
            CodedValueType value = new CodedValueType();
            value.setCode("110153");
            value.setCodeSystemName("DCM");
            value.setDisplayName("Source");
            active.setRoleIDCode(value);
            message.setActiveParticipant(active);
            AuditSourceIdentificationType auditSource = new AuditSourceIdentificationType("9.48.116.130");
            message.setAuditSourceIdentification(auditSource);
            ParticipantObjectIdentificationType participantObject = new ParticipantObjectIdentificationType();
            participantObject.setParticipantObjectID("NETWORK SERVICE");
            CodedValueType value1 = new CodedValueType();
            value1.setCode("10");
            participantObject.setParticipantObjectIDTypeCode(value1);
            participantObject.setParticipantObjectTypeCode((short)2);
            participantObject.setParticipantObjectTypeCodeRole((short)24);
            byte[] b = "UEQ5NGJXd2dkbVZ5YzJsdmJqMGlNUzR3SWlCbGJtTnZaR2x1WnowaVZWUkdMVGdpUHo0S1BFRmthRzlqVVhWbGNubFNaWEYxWlhOMElIaHRiRzV6UFNKMWNtNDZiMkZ6YVhNNmJtRnRaWE02ZEdNNlpXSjRiV3d0Y21WbmNtVndPbkpsWjJsemRISjVPbmh6WkRveUxqRWlJSGh0Ykc1ek9uRjFaWEo1UFNKMWNtNDZiMkZ6YVhNNmJtRnRaWE02ZEdNNlpXSjRiV3d0Y21WbmNtVndPbkYxWlhKNU9uaHpaRG95TGpFaUlIaHRiRzV6T25KcGJUMGlkWEp1T205aGMybHpPbTVoYldWek9uUmpPbVZpZUcxc0xYSmxaM0psY0RweWFXMDZlSE5rT2pJdU1TSWdlRzFzYm5NNmNuTTlJblZ5YmpwdllYTnBjenB1WVcxbGN6cDBZenBsWW5odGJDMXlaV2R5WlhBNmNtVm5hWE4wY25rNmVITmtPakl1TVNJZ2VHMXNibk02ZEc1elBTSjFjbTQ2YjJGemFYTTZibUZ0WlhNNmRHTTZaV0o0Yld3dGNtVm5jbVZ3T25KcGJUcDRjMlE2TWk0eElpQjRiV3h1Y3pwNGMyazlJbWgwZEhBNkx5OTNkM2N1ZHpNdWIzSm5Mekl3TURFdldFMU1VMk5vWlcxaExXbHVjM1JoYm1ObElpQjRjMms2YzJOb1pXMWhURzlqWVhScGIyNDlJblZ5YmpwdllYTnBjenB1WVcxbGN6cDBZenBsWW5odGJDMXlaV2R5WlhBNmNtVm5hWE4wY25rNmVITmtPakl1TVNCb2RIUndPaTh2ZDNkM0xtOWhjMmx6TFc5d1pXNHViM0puTDJOdmJXMXBkSFJsWlhNdmNtVm5jbVZ3TDJSdlkzVnRaVzUwY3k4eUxqRXZjMk5vWlcxaEwzSnpMbmh6WkNJK!1BIRjFaWEo1T2xKbGMzQnZibk5sVDNCMGFXOXVJSEpsZEhWeWJrTnZiWEJ2YzJWa1QySnFaV04wY3owaWRISjFaU0lnY21WMGRYSnVWSGx3WlQwaVRHVmhaa05zWVhOeklpOCtDanh5YVcwNlUxRk1VWFZsY25rK0NsTkZURVZEVkNCa2IyTXVhV1FnUmxKUFRTQkZlSFJ5YVc1emFXTlBZbXBsWTNRZ1pHOWpMQ0JGZUhSbGNtNWhiRWxrWlc1MGFXWnBaWElnY0dGMFNXUUtJRmRJUlZKRklHUnZZeTV2WW1wbFkzUlVlWEJsSUQwZ0ozVnlianAxZFdsa09qZGxaR05oT0RKbUxUQTFOR1F0TkRkbU1pMWhNRE15TFRsaU1tRTFZalV4T0Raak1TY0tRVTVFSUNnZ1pHOWpMbWxrSUQwZ2NHRjBTV1F1Y21WbmFYTjBjbmx2WW1wbFkzUWdRVTVFSUhCaGRFbGtMbWxrWlc1MGFXWnBZMkYwYVc5dVUyTm9aVzFsUFNkMWNtNDZkWFZwWkRvMU9HRTJaamcwTVMwNE4ySXpMVFJoTTJVdE9USm1aQzFoT0dabVpXWm1PVGcwTWpjbkNrRk9SQ0J3WVhSSlpDNTJZV3gxWlNBOUlDZE5RVVJVVUVsRU16TXhOVEJlWGw1SVNVMVRVekl3TURVbVlXMXdPekV1TXk0MkxqRXVOQzR4TGpJeE16WTNMakl3TURVdU1TNHhKbUZ0Y0R0SlUwOG5LU0FnUVU1RUlHUnZZeTV6ZEdGMGRYTWdTVTRnS0NkQmNIQnliM1psWkNjcENqd3ZjbWx0T2xOUlRGRjFaWEo1UGp3dlFXUm9iMk5SZFdWeWVWSmxjWFZsYzNRK0NnPT0=".getBytes();
            participantObject.setParticipantObjectQuery(b);
            message.setParticipationObjectIdentification(participantObject);
            System.out.println(message.toString());
            try {
                Element el = SyslogUtil.StringToXMLElement(message.toString());
                AuditMessage message2 = new AuditMessage("EHR_IBM");
                message2.parse(el);
                System.err.println(message2.toString());
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (FactoryConfigurationError e1) {
            e1.printStackTrace();
        }
        catch (ATNAException e) {
            e.printStackTrace();
        }
    }

    public void setUserIDActiveParticipantConsumer(String userIDActiveParticipantRegistry) {
        try {
            if (this.getMessagetype().equalsIgnoreCase("query")) {
                this.setActiveParticipantDocConsumer(new ActiveParticipantType(userIDActiveParticipantRegistry));
                this.getActiveParticipantDocConsumer().setUserIsRequestor(false);
                CodedValueType valueSource = new CodedValueType();
                valueSource.setCode("110153");
                valueSource.setCodeSystemName("DCM");
                valueSource.setDisplayName("Source");
                this.getActiveParticipantDocConsumer().setRoleIDCode(valueSource);
                this.setActiveParticipant(this.getActiveParticipantDocConsumer());
            } else if (this.getMessagetype().equalsIgnoreCase("import")) {
                this.setActiveParticipantDocConsumer(new ActiveParticipantType(userIDActiveParticipantRegistry));
                this.getActiveParticipantDocConsumer().setUserIsRequestor(false);
                CodedValueType valueSource = new CodedValueType();
                valueSource.setCode("110152");
                valueSource.setCodeSystemName("DCM");
                valueSource.setDisplayName("Source");
                this.getActiveParticipantDocConsumer().setRoleIDCode(valueSource);
                this.setActiveParticipant(this.getActiveParticipantDocConsumer());
            } else if (this.getMessagetype().equalsIgnoreCase("export")) {
                this.setActiveParticipantDocConsumer(new ActiveParticipantType(userIDActiveParticipantRegistry));
                this.getActiveParticipantDocConsumer().setUserIsRequestor(false);
                CodedValueType valueSource = new CodedValueType();
                valueSource.setCode("110152");
                valueSource.setCodeSystemName("DCM");
                valueSource.setDisplayName("Source");
                this.getActiveParticipantDocConsumer().setRoleIDCode(valueSource);
                this.setActiveParticipant(this.getActiveParticipantDocConsumer());
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setUserIDActiveParticipantRegistry(String userIDActiveParticipantConsumer) {
        try {
            if (this.getMessagetype().equalsIgnoreCase("query")) {
                this.setActiveParticipantDocRegistry(new ActiveParticipantType(userIDActiveParticipantConsumer));
                this.getActiveParticipantDocRegistry().setUserIsRequestor(false);
                CodedValueType valueDest = new CodedValueType();
                valueDest.setCode("110153");
                valueDest.setCodeSystemName("DCM");
                valueDest.setDisplayName("Destination");
                this.getActiveParticipantDocRegistry().setRoleIDCode(valueDest);
                this.setActiveParticipant(this.getActiveParticipantDocRegistry());
            } else if (this.getMessagetype().equalsIgnoreCase("import")) {
                this.setActiveParticipantDocRegistry(new ActiveParticipantType(userIDActiveParticipantConsumer));
                this.getActiveParticipantDocRegistry().setUserIsRequestor(false);
                CodedValueType valueDest = new CodedValueType();
                valueDest.setCode("110152");
                valueDest.setCodeSystemName("DCM");
                valueDest.setDisplayName("Destination");
                this.getActiveParticipantDocRegistry().setRoleIDCode(valueDest);
                this.setActiveParticipant(this.getActiveParticipantDocRegistry());
            } else if (this.getMessagetype().equalsIgnoreCase("export")) {
                this.setActiveParticipantDocRegistry(new ActiveParticipantType(userIDActiveParticipantConsumer));
                this.getActiveParticipantDocRegistry().setUserIsRequestor(false);
                CodedValueType valueDest = new CodedValueType();
                valueDest.setCode("110152");
                valueDest.setCodeSystemName("DCM");
                valueDest.setDisplayName("Destination");
                this.getActiveParticipantDocRegistry().setRoleIDCode(valueDest);
                this.setActiveParticipant(this.getActiveParticipantDocRegistry());
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setAuditSourceId(String auditSourceId) {
        try {
            AuditSourceIdentificationType auditSource = new AuditSourceIdentificationType(auditSourceId);
            this.setAuditSourceIdentification(auditSource);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setParticipantObjectId(String participantObjectId) {
        try {
            this.setParticipantObject(new ParticipantObjectIdentificationType());
            this.getParticipantObject().setParticipantObjectID(participantObjectId);
            this.getParticipantObject().setParticipantObjectTypeCodeRoleName("report");
            this.getParticipantObject().setParticipantObjectTypeCode((short)2);
            CodedValueType value1 = new CodedValueType();
            value1.setCode("11081");
            value1.setCodeSystemName("DCM");
            value1.setDisplayName("SOP Class UID");
            this.getParticipantObject().setParticipantObjectIDTypeCode(value1);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (ATNAException e) {
            e.printStackTrace();
        }
    }

    public void setParticipantObjectQuery(String participantObjectQuery) {
        try {
            if (this.getParticipantObject() != null) {
                byte[] b = participantObjectQuery.getBytes();
                this.getParticipantObject().setParticipantObjectQuery(b);
                this.setParticipationObjectIdentification(this.getParticipantObject());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setMessagetype(String messagetype) {
        this.messagetype = messagetype;
    }

    protected String getMessagetype() {
        return this.messagetype;
    }

    protected void setParticipantObject(ParticipantObjectIdentificationType participantObject) {
        this.participantObject = participantObject;
    }

    protected ParticipantObjectIdentificationType getParticipantObject() {
        return this.participantObject;
    }

    private void setActiveParticipantDocRegistry(ActiveParticipantType activeParticipantDocRegistry) {
        this.activeParticipantDocRegistry = activeParticipantDocRegistry;
    }

    private ActiveParticipantType getActiveParticipantDocRegistry() {
        return this.activeParticipantDocRegistry;
    }

    private void setActiveParticipantDocConsumer(ActiveParticipantType activeParticipantDocConsumer) {
        this.activeParticipantDocConsumer = activeParticipantDocConsumer;
    }

    private ActiveParticipantType getActiveParticipantDocConsumer() {
        return this.activeParticipantDocConsumer;
    }
}

