/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.ParticipantObjectIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.util.AddressUtils;

public class PatientRecordMessage
extends AuditMessage
implements Serializable {
    public static final String READ = "R";
    public static final String CREATE = "C";
    public static final String UPDATE = "U";
    public static final String DELETE = "D";
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public PatientRecordMessage(String eventDateTime, int eventOutcomeIndicator, String eventActionCode, String userIDActiveParticipantUser, String participantObjectPatientId, String sourceId) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        super(sourceId);
        EventIdentificationType eventId = new EventIdentificationType(0);
        eventId.setEventActionCode(eventActionCode);
        eventId.setEventID(new AuditEventID.PatientRecord());
        eventId.setEventDateTime(eventDateTime);
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        this.setEventIdentification(eventId);
        ActiveParticipantType activeParticipantUser = null;
        activeParticipantUser = new ActiveParticipantType(userIDActiveParticipantUser);
        activeParticipantUser.setUserIsRequestor(true);
        AddressUtils.setNetworkAccessPointCodes(activeParticipantUser, AddressUtils.getLocalAddress());
        this.setActiveParticipant(activeParticipantUser);
        ParticipantObjectIdentificationType participantObjectPatient = new ParticipantObjectIdentificationType();
        participantObjectPatient.setParticipantObjectTypeCode((short)1);
        participantObjectPatient.setParticipantObjectTypeCodeRoleName("patient");
        CodedValueType value2 = new CodedValueType();
        value2.setCode("2");
        participantObjectPatient.setParticipantObjectIDTypeCode(value2);
        participantObjectPatient.setParticipantObjectID(participantObjectPatientId);
        this.setParticipationObjectIdentification(participantObjectPatient);
    }

    public PatientRecordMessage() throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this.setMessagetype("patient record");
        if (this.getEventIdentification() != null) {
            this.getEventIdentification().setEventActionCode(READ);
            this.getEventIdentification().setEventID(new AuditEventID.PatientRecord());
        }
    }
}

