/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.ErrorType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryResponseType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.StatusType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.util.RegistryResourceFactoryImpl;
import org.eclipse.ohf.ihe.common.ebxml._3._0.query.AdhocQueryResponseType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rs.RegistryErrorListType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rs.RegistryErrorType;
import org.eclipse.ohf.ihe.xds.XDSResponseParserException;
import org.eclipse.ohf.ihe.xds.response.ResponseFactory;
import org.eclipse.ohf.ihe.xds.response.XDSErrorCode;
import org.eclipse.ohf.ihe.xds.response.XDSErrorType;
import org.eclipse.ohf.ihe.xds.response.XDSResponseType;
import org.eclipse.ohf.ihe.xds.response.XDSStatusType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XDSResponseParser {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.XDSResponseParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static XDSResponseType processResponse(Element response, boolean isQuery) throws XDSResponseParserException, IOException {
        if (response == null) {
            logger.error((Object)"Error: Response from Server was null.");
            throw new XDSResponseParserException("Error: Response from Server was null.");
        }
        if (response.getNamespaceURI().compareTo("urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1") == 0) {
            return XDSResponseParser.parseEbXML_2_1(response, isQuery);
        }
        if (response.getNamespaceURI().compareTo("urn:oasis:names:tc:ebxml-regrep:xsd:rs:3.0") == 0) {
            return XDSResponseParser.parseEbXML_3_0(response, isQuery);
        }
        if (response.getNamespaceURI().compareTo("urn:oasis:names:tc:ebxml-regrep:xsd:query:3.0") == 0) {
            return XDSResponseParser.parseEbXML_3_0(response, isQuery);
        }
        logger.error((Object)"Server response was coded with an unrecognized namespace. ");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Response was:");
        }
        throw new XDSResponseParserException("Server response was coded with an unrecognized namespace. ");
    }

    public static boolean getHackMetadataFlag() {
        String val = System.getProperty("relax.validation");
        if (val == null) {
            return false;
        }
        if ((val = val.trim()).length() <= 0) {
            return false;
        }
        if (val.equals("true") || val.equals("yes")) {
            logger.warn((Object)"RELAXING EMF VALIDATION FOR PARSING SERVER RESPONSE");
            return true;
        }
        return false;
    }

    private static XDSResponseType parseEbXML_2_1(Element responseElement, boolean isQuery) throws XDSResponseParserException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading response in EMF.");
        }
        XMLResource resources = (XMLResource)new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
        if (XDSResponseParser.getHackMetadataFlag()) {
            XMLResource xResource = resources;
            xResource.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        try {
            resources.load((Node)responseElement, null);
        }
        catch (IOException e) {
            throw new XDSResponseParserException("Error parsing ebXML 2. 1 response with EMF. Response is:\n ", e);
        }
        EList list = resources.getContents();
        Object o = list.get(0);
        if (o instanceof DocumentRoot) {
            DocumentRoot root = (DocumentRoot)list.get(0);
            RegistryResponseType response = root.getRegistryResponse();
            if (response == null) {
                resources.unload();
                logger.error((Object)"EbXML 2.1 RegistryResponse is null");
                throw new XDSResponseParserException("EbXML 2.1 RegistryResponse is null");
            }
            XDSResponseType xdsResponse = null;
            xdsResponse = isQuery ? ResponseFactory.eINSTANCE.createXDSQueryResponseType() : ResponseFactory.eINSTANCE.createXDSResponseType();
            if (response.getStatus() == null) {
                logger.warn((Object)"RegistryResponse status is null");
            } else if (response.getStatus().equals(StatusType.SUCCESS_LITERAL)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Success.");
                }
                xdsResponse.setStatus(XDSStatusType.SUCCESS_LITERAL);
            } else if (response.getStatus().equals(StatusType.FAILURE_LITERAL)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Failure.");
                }
                xdsResponse.setStatus(XDSStatusType.FAILURE_LITERAL);
            } else if (response.getStatus().equals(StatusType.UNAVAILABLE_LITERAL)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Unavailable.");
                }
                xdsResponse.setStatus(XDSStatusType.UNAVAILABLE_LITERAL);
            } else if (response.getStatus().equals(StatusType.PARTIAL_SUCCESS_LITERAL)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Partial Success.");
                }
                xdsResponse.setStatus(XDSStatusType.PARTIAL_SUCCESS_LITERAL);
            } else {
                logger.warn((Object)"RegistryResponse status is unrecognized");
            }
            if (response.getRegistryErrorList() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list is null.");
                }
            } else if (response.getRegistryErrorList().getRegistryError() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list contains no errors.");
                }
            } else if (response.getRegistryErrorList().getRegistryError().isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list contains no errors.");
                }
            } else {
                XDSErrorType[] errors = XDSResponseParser.convert(response.getRegistryErrorList());
                xdsResponse.setErrorList(ResponseFactory.eINSTANCE.createXDSErrorListType());
                if (response.getRegistryErrorList().getHighestSeverity() != null) {
                    if (response.getRegistryErrorList().getHighestSeverity().equals(ErrorType.ERROR_LITERAL)) {
                        xdsResponse.getErrorList().setHighestSeverity(XDSStatusType.ERROR_LITERAL);
                    } else if (response.getRegistryErrorList().getHighestSeverity().equals(ErrorType.WARNING_LITERAL)) {
                        xdsResponse.getErrorList().setHighestSeverity(XDSStatusType.WARNING_LITERAL);
                    }
                }
                StringBuffer errorMsg = new StringBuffer();
                int i = 0;
                while (i < errors.length) {
                    xdsResponse.getErrorList().getError().add((Object)errors[i]);
                    if (logger.isInfoEnabled()) {
                        errorMsg.append("Error #" + i + "\n\tSeverity=" + errors[i].getSeverity().getName() + "\n\tCode=" + errors[i].getErrorCode().getName() + "\n\tCode Context=" + errors[i].getCodeContext() + "\n\tLocation= " + errors[i].getLocation() + "\n\n");
                    }
                    ++i;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)errorMsg);
                }
            }
            resources.unload();
            return xdsResponse;
        }
        resources.unload();
        logger.error((Object)("Unexpected class found as document root " + o.getClass().getName()));
        throw new XDSResponseParserException("Unexpected class found as document root " + o.getClass().getName());
    }

    private static XDSResponseType parseEbXML_3_0(Element responseElement, boolean isQuery) throws XDSResponseParserException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading response in EMF.");
        }
        XMLResource resources = (XMLResource)new org.eclipse.ohf.ihe.common.ebxml._3._0.rs.util.RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:xsd:rs:3.0"));
        if (XDSResponseParser.getHackMetadataFlag()) {
            XMLResource xResource = resources;
            xResource.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        try {
            resources.load((Node)responseElement, null);
        }
        catch (IOException e) {
            throw new XDSResponseParserException("Error parsing ebXML 3.0 response with EMF. Response is:\n FIX ME BY ADDING RESPONSE", e);
        }
        EList list = resources.getContents();
        Object o = list.get(0);
        if (o instanceof org.eclipse.ohf.ihe.common.ebxml._3._0.rs.DocumentRoot) {
            org.eclipse.ohf.ihe.common.ebxml._3._0.rs.DocumentRoot root = (org.eclipse.ohf.ihe.common.ebxml._3._0.rs.DocumentRoot)list.get(0);
            org.eclipse.ohf.ihe.common.ebxml._3._0.rs.RegistryResponseType response = root.getRegistryResponse();
            if (response == null) {
                resources.unload();
                logger.error((Object)"EbXML 3.0 RegistryResponse is null");
                throw new XDSResponseParserException("EbXML 3.0 RegistryResponse is null");
            }
            XDSResponseType xdsResponse = null;
            xdsResponse = isQuery ? ResponseFactory.eINSTANCE.createXDSQueryResponseType() : ResponseFactory.eINSTANCE.createXDSResponseType();
            if (response.getStatus() == null) {
                logger.warn((Object)"RegistryResponse status is null");
            } else if (response.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:" + XDSStatusType.SUCCESS_LITERAL.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Success.");
                }
                xdsResponse.setStatus(XDSStatusType.SUCCESS_LITERAL);
            } else if (response.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:" + XDSStatusType.FAILURE_LITERAL.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Failure.");
                }
                xdsResponse.setStatus(XDSStatusType.FAILURE_LITERAL);
            } else if (response.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:" + XDSStatusType.UNAVAILABLE_LITERAL.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Unavailable.");
                }
                xdsResponse.setStatus(XDSStatusType.UNAVAILABLE_LITERAL);
            } else if (response.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:" + XDSStatusType.PARTIAL_SUCCESS_LITERAL.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Partial Success.");
                }
                xdsResponse.setStatus(XDSStatusType.PARTIAL_SUCCESS_LITERAL);
            } else {
                logger.warn((Object)"RegistryResponse status is unrecognized");
            }
            if (response.getRegistryErrorList() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list is null.");
                }
            } else if (response.getRegistryErrorList().getRegistryError() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list contains no errors.");
                }
            } else if (response.getRegistryErrorList().getRegistryError().isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list contains no errors.");
                }
            } else {
                XDSErrorType[] errors = XDSResponseParser.convert(response.getRegistryErrorList());
                xdsResponse.setErrorList(ResponseFactory.eINSTANCE.createXDSErrorListType());
                if (response.getRegistryErrorList().getHighestSeverity() != null) {
                    if (response.getRegistryErrorList().getHighestSeverity().equals(ErrorType.ERROR_LITERAL)) {
                        xdsResponse.getErrorList().setHighestSeverity(XDSStatusType.ERROR_LITERAL);
                    } else if (response.getRegistryErrorList().getHighestSeverity().equals(ErrorType.WARNING_LITERAL)) {
                        xdsResponse.getErrorList().setHighestSeverity(XDSStatusType.WARNING_LITERAL);
                    }
                }
                StringBuffer errorMsg = new StringBuffer();
                int i = 0;
                while (i < errors.length) {
                    xdsResponse.getErrorList().getError().add((Object)errors[i]);
                    if (logger.isInfoEnabled()) {
                        errorMsg.append("Error #" + i + "\n\tSeverity=" + errors[i].getSeverity().getName() + "\n\tCode=" + errors[i].getErrorCode().getName() + "\n\tCode Context=" + errors[i].getCodeContext() + "\n\tLocation= " + errors[i].getLocation() + "\n\n");
                    }
                    ++i;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)errorMsg);
                }
            }
            resources.unload();
            return xdsResponse;
        }
        if (o instanceof org.eclipse.ohf.ihe.common.ebxml._3._0.query.DocumentRoot) {
            org.eclipse.ohf.ihe.common.ebxml._3._0.query.DocumentRoot root = (org.eclipse.ohf.ihe.common.ebxml._3._0.query.DocumentRoot)o;
            AdhocQueryResponseType response = root.getAdhocQueryResponse();
            resources.unload();
            if (response == null) {
                resources.unload();
                logger.error((Object)"EbXML 3.0 AdhocQueryResponse is null");
                throw new XDSResponseParserException("EbXML 3.0 AdhocQueryResponse is null");
            }
            XDSResponseType xdsResponse = null;
            xdsResponse = isQuery ? ResponseFactory.eINSTANCE.createXDSQueryResponseType() : ResponseFactory.eINSTANCE.createXDSResponseType();
            if (response.getStatus() == null) {
                logger.warn((Object)"RegistryResponse status is null");
            } else if (response.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:" + XDSStatusType.SUCCESS_LITERAL.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Success.");
                }
                xdsResponse.setStatus(XDSStatusType.SUCCESS_LITERAL);
            } else if (response.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:" + XDSStatusType.FAILURE_LITERAL.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Failure.");
                }
                xdsResponse.setStatus(XDSStatusType.FAILURE_LITERAL);
            } else if (response.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:" + XDSStatusType.UNAVAILABLE_LITERAL.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Unavailable.");
                }
                xdsResponse.setStatus(XDSStatusType.UNAVAILABLE_LITERAL);
            } else if (response.getStatus().equals("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:" + XDSStatusType.PARTIAL_SUCCESS_LITERAL.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Partial Success.");
                }
                xdsResponse.setStatus(XDSStatusType.PARTIAL_SUCCESS_LITERAL);
            } else {
                logger.warn((Object)"RegistryResponse status is unrecognized");
            }
            if (response.getRegistryErrorList() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list is null.");
                }
            } else if (response.getRegistryErrorList().getRegistryError() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list contains no errors.");
                }
            } else if (response.getRegistryErrorList().getRegistryError().isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RegistryResponse error list contains no errors.");
                }
            } else {
                XDSErrorType[] errors = XDSResponseParser.convert(response.getRegistryErrorList());
                xdsResponse.setErrorList(ResponseFactory.eINSTANCE.createXDSErrorListType());
                if (response.getRegistryErrorList().getHighestSeverity() != null) {
                    if (response.getRegistryErrorList().getHighestSeverity().equals(ErrorType.ERROR_LITERAL)) {
                        xdsResponse.getErrorList().setHighestSeverity(XDSStatusType.ERROR_LITERAL);
                    } else if (response.getRegistryErrorList().getHighestSeverity().equals(ErrorType.WARNING_LITERAL)) {
                        xdsResponse.getErrorList().setHighestSeverity(XDSStatusType.WARNING_LITERAL);
                    }
                }
                StringBuffer errorMsg = new StringBuffer();
                int i = 0;
                while (i < errors.length) {
                    xdsResponse.getErrorList().getError().add((Object)errors[i]);
                    if (logger.isInfoEnabled()) {
                        errorMsg.append("Error #" + i + "\n\tSeverity=" + errors[i].getSeverity().getName() + "\n\tCode=" + errors[i].getErrorCode().getName() + "\n\tCode Context=" + errors[i].getCodeContext() + "\n\tLocation= " + errors[i].getLocation() + "\n\n");
                    }
                    ++i;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)errorMsg);
                }
            }
            resources.unload();
            return xdsResponse;
        }
        resources.unload();
        logger.error((Object)("Unexpected class found as document root " + o.getClass().getName()));
        throw new XDSResponseParserException("Unexpected class found as document root " + o.getClass().getName());
    }

    private static XDSErrorType[] convert(org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryErrorListType errorList) {
        XDSErrorType[] errors = new XDSErrorType[errorList.getRegistryError().size()];
        Iterator i = errorList.getRegistryError().iterator();
        int count = 0;
        while (i.hasNext()) {
            org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryErrorType e = (org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryErrorType)i.next();
            errors[count] = ResponseFactory.eINSTANCE.createXDSErrorType();
            if (e.getSeverity() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RegistryResponse error " + count + " severity is null."));
                }
            } else if (e.getSeverity().equals(ErrorType.ERROR_LITERAL)) {
                errors[count].setSeverity(XDSStatusType.ERROR_LITERAL);
            } else if (e.getSeverity().equals(ErrorType.WARNING_LITERAL)) {
                errors[count].setSeverity(XDSStatusType.WARNING_LITERAL);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("RegistryResponse error " + count + " severity is unrecognized."));
            }
            if (e.getErrorCode() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RegistryResponse error " + count + " code is null."));
                }
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_DUPLICATE_UNIQUE_ID_IN_REGISTRY_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_DUPLICATE_UNIQUE_ID_IN_REGISTRY_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_EXTRA_METADATA_NOT_SAVED_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_EXTRA_METADATA_NOT_SAVED_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_MISSING_DOCUMENT_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_MISSING_DOCUMENT_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_MISSING_DOCUMENT_METADATA_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_MISSING_DOCUMENT_METADATA_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_NON_IDENTICAL_HASH_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_NON_IDENTICAL_HASH_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_PATIENT_ID_DOES_NOT_MATCH_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_PATIENT_ID_DOES_NOT_MATCH_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_BUSY_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_BUSY_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_DUPLICATE_UNIQUE_ID_IN_MESSAGE_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_DUPLICATE_UNIQUE_ID_IN_MESSAGE_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_METADATA_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_METADATA_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_NOT_AVAILABLE_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_NOT_AVAILABLE_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_OUT_OF_RESOURCES_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_OUT_OF_RESOURCES_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_BUSY_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_BUSY_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_DUPLICATE_UNIQUE_ID_IN_MESSAGE_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_DUPLICATE_UNIQUE_ID_IN_MESSAGE_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_METADATA_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_METADATA_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_OUT_OF_RESOURCES_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_OUT_OF_RESOURCES_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_SQL_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_SQL_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_STORED_QUERY_MISSING_PARAM_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_STORED_QUERY_MISSING_PARAM_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_STORED_QUERY_PARAM_NUMBER_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_STORED_QUERY_PARAM_NUMBER_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_TOO_MAY_RESULTS_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_TOO_MAY_RESULTS_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_UNKNOWN_PATIENT_ID_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_UNKNOWN_PATIENT_ID_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_UNKNOWN_STORED_QUERY_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_UNKNOWN_STORED_QUERY_LITERAL);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RegistryResponse error " + count + " code is unrecognized."));
                }
                errors[count].setErrorCode(XDSErrorCode.UNKNOWNERROR_LITERAL);
            }
            if (e.getCodeContext() != null) {
                errors[count].setCodeContext(e.getCodeContext());
            }
            if (e.getLocation() != null) {
                errors[count].setLocation(e.getLocation());
            }
            if (e.getValue() != null) {
                errors[count].setValue(e.getValue());
            }
            ++count;
        }
        return errors;
    }

    private static XDSErrorType[] convert(RegistryErrorListType errorList) {
        XDSErrorType[] errors = new XDSErrorType[errorList.getRegistryError().size()];
        Iterator i = errorList.getRegistryError().iterator();
        int count = 0;
        while (i.hasNext()) {
            RegistryErrorType e = (RegistryErrorType)i.next();
            errors[count] = ResponseFactory.eINSTANCE.createXDSErrorType();
            if (e.getSeverity() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RegistryResponse error " + count + " severity is null."));
                }
            } else if (e.getSeverity().equals("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:" + XDSStatusType.ERROR_LITERAL.getName())) {
                errors[count].setSeverity(XDSStatusType.ERROR_LITERAL);
            } else if (e.getSeverity().equals("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:" + (Object)((Object)XDSStatusType.WARNING_LITERAL))) {
                errors[count].setSeverity(XDSStatusType.WARNING_LITERAL);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("RegistryResponse error " + count + " severity is unrecognized."));
            }
            if (e.getErrorCode() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RegistryResponse error " + count + " code is null."));
                }
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_DUPLICATE_UNIQUE_ID_IN_REGISTRY_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_DUPLICATE_UNIQUE_ID_IN_REGISTRY_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_EXTRA_METADATA_NOT_SAVED_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_EXTRA_METADATA_NOT_SAVED_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_MISSING_DOCUMENT_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_MISSING_DOCUMENT_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_MISSING_DOCUMENT_METADATA_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_MISSING_DOCUMENT_METADATA_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_NON_IDENTICAL_HASH_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_NON_IDENTICAL_HASH_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_PATIENT_ID_DOES_NOT_MATCH_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_PATIENT_ID_DOES_NOT_MATCH_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_BUSY_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_BUSY_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_DUPLICATE_UNIQUE_ID_IN_MESSAGE_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_DUPLICATE_UNIQUE_ID_IN_MESSAGE_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_METADATA_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_METADATA_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_NOT_AVAILABLE_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_NOT_AVAILABLE_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REGISTRY_OUT_OF_RESOURCES_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REGISTRY_OUT_OF_RESOURCES_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_BUSY_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_BUSY_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_DUPLICATE_UNIQUE_ID_IN_MESSAGE_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_DUPLICATE_UNIQUE_ID_IN_MESSAGE_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_METADATA_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_METADATA_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_REPOSITORY_OUT_OF_RESOURCES_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_REPOSITORY_OUT_OF_RESOURCES_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_SQL_ERROR_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_SQL_ERROR_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_STORED_QUERY_MISSING_PARAM_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_STORED_QUERY_MISSING_PARAM_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_STORED_QUERY_PARAM_NUMBER_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_STORED_QUERY_PARAM_NUMBER_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_TOO_MAY_RESULTS_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_TOO_MAY_RESULTS_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_UNKNOWN_PATIENT_ID_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_UNKNOWN_PATIENT_ID_LITERAL);
            } else if (e.getErrorCode().equals(XDSErrorCode.XDS_UNKNOWN_STORED_QUERY_LITERAL.getName())) {
                errors[count].setErrorCode(XDSErrorCode.XDS_UNKNOWN_STORED_QUERY_LITERAL);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RegistryResponse error " + count + " code is unrecognized."));
                }
                errors[count].setErrorCode(XDSErrorCode.UNKNOWNERROR_LITERAL);
            }
            if (e.getCodeContext() != null) {
                errors[count].setCodeContext(e.getCodeContext());
            }
            if (e.getLocation() != null) {
                errors[count].setLocation(e.getLocation());
            }
            if (e.getValue() != null) {
                errors[count].setValue(e.getValue());
            }
            ++count;
        }
        return errors;
    }
}

