/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.soda.devicekit.editor.dkml.DkmlDomErrorHandler;
import org.eclipse.soda.devicekit.editor.dkml.ITreeSelectionListener;
import org.eclipse.soda.devicekit.editor.dkml.TagHolderSelectionChangedEvent;
import org.eclipse.soda.devicekit.editor.dkml.parse.AttributeHolder;
import org.eclipse.soda.devicekit.editor.dkml.parse.DkmlTagManager;
import org.eclipse.soda.devicekit.editor.dkml.parse.TagHolder;
import org.eclipse.soda.devicekit.editor.dkml.schema.DkmlSchema;
import org.eclipse.soda.devicekit.editor.dkml.schema.DkmlSchemaUtil;
import org.eclipse.soda.devicekit.util.DkSsiProjectInputStream;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public class DkmlModel {
    private static DkmlSchema schema = new DkmlSchema();
    private boolean changed = false;
    private Hashtable dirtyFiles;
    private Document document;
    boolean errors = false;
    private DocumentBuilderFactory factory;
    private IFile file;
    private Object input;
    private DkmlTagManager manager;
    private IDocumentProvider provider;
    private Hashtable referencedFiles;
    private TagHolder selectedHolder;
    private Vector selectionListeners;
    private long timestamp = 0L;
    private DkmlSchemaUtil util;

    public DkmlModel(IFile file, IDocumentProvider provider, Object input) {
        this.file = file;
        this.setDocumentProvider(provider);
        this.setInput(input);
        this.init();
        this.build(file);
    }

    public static DkmlSchema getSchema() {
        return schema;
    }

    public void addAttribute(String attribute, String value) {
        this.selectedHolder.addAttribute(attribute, value);
    }

    public void addModelChangedListener() {
    }

    public void addSelectionChangedListener(ITreeSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public boolean anchorFileChanged() {
        return this.getDocumentProvider().getModificationStamp(this.getInput()) == this.timestamp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(IFile file) {
        if (file == null) {
            return;
        }
        this.document = null;
        InputStream inputStream = null;
        try {
            block11: {
                try {
                    IDocument eDocument = this.getDocumentProvider().getDocument(this.getInput());
                    String eDocumentString = eDocument.get();
                    ByteArrayInputStream stream = new ByteArrayInputStream(eDocumentString.getBytes());
                    inputStream = new DkSsiProjectInputStream((InputStream)stream, this.getFile(), this.getFile().getProject());
                    DkmlDomErrorHandler errorHandler = new DkmlDomErrorHandler(this.getFile(), this.getDocumentProvider(), this.getInput());
                    this.document = ParserUtilities.parseDeviceKit((InputStream)stream, (ErrorHandler)errorHandler);
                    if (errorHandler.getErrorCount() == 0) {
                        this.createManager(this.document);
                        this.errors = false;
                        break block11;
                    }
                    this.errors = true;
                }
                catch (Exception exception) {
                    this.errors = true;
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                inputStream = null;
                throw throwable;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw throwable;
        }
        try {}
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        if (inputStream == null) return;
        inputStream.close();
    }

    private void createManager(Document document) {
        this.manager = new DkmlTagManager(document);
    }

    public TagHolder createNewTag(String tag) {
        TagHolder newTag = this.util.createNewTagHolder(this.selectedHolder.getName(), tag);
        int index = this.util.getChildInsertIndex(newTag.getName(), this.selectedHolder);
        newTag.setParent(this.selectedHolder);
        this.selectedHolder.addChild(newTag, index);
        return newTag;
    }

    public IFile getChangedFile(TagHolder changed) {
        return this.getFile();
    }

    public IDocumentProvider getDocumentProvider() {
        return this.provider;
    }

    public IFile getFile() {
        return this.file;
    }

    public Object getInput() {
        return this.input;
    }

    public DkmlTagManager getManager() {
        return this.manager;
    }

    public TagHolder getParentFile() {
        return this.selectedHolder;
    }

    public IFile getReferencedFile(String name) {
        return (IFile)this.referencedFiles.get(name);
    }

    public Hashtable getReferencedFiles() {
        return this.referencedFiles;
    }

    public TagHolder getSelection() {
        return this.selectedHolder;
    }

    public String getTagContents() {
        return this.manager.toString();
    }

    public Object getUpdatedFileContents(IFile file) {
        if (this.getManager() != null) {
            return this.getManager().toString();
        }
        return this.getDocumentProvider().getDocument(this.getInput()).get();
    }

    public String[] getValidAttributes(TagHolder holder) {
        return this.util.getValidAttributeNames(holder);
    }

    public String[] getValidChildren(TagHolder holder) {
        return this.util.getValidChildrenNames(holder);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean hasErrors() {
        this.rebuild();
        return this.errors;
    }

    private void init() {
        this.selectedHolder = null;
        this.document = null;
        this.dirtyFiles = new Hashtable();
        this.selectionListeners = new Vector();
        this.util = new DkmlSchemaUtil(DkmlModel.getSchema());
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setIgnoringComments(false);
        this.factory.setIgnoringElementContentWhitespace(false);
    }

    public boolean isOpenFile(IFile file) {
        return this.file == file;
    }

    private void notifySelectionListeners() {
        int i = 0;
        while (i < this.selectionListeners.size()) {
            TagHolderSelectionChangedEvent event = new TagHolderSelectionChangedEvent(this.getSelection());
            ((ITreeSelectionListener)this.selectionListeners.elementAt(i)).holderSelectionChanged(event);
            ++i;
        }
    }

    public void rebuild() {
        this.build(this.getFile());
    }

    public void removeAttributes(Object[] atts) {
        Vector currAtts = this.selectedHolder.getAttributes();
        int i = 0;
        while (i < atts.length) {
            int j = 0;
            while (j < currAtts.size()) {
                AttributeHolder ah = (AttributeHolder)currAtts.elementAt(j);
                if (ah.getName().equals(atts[i])) {
                    currAtts.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.selectedHolder.setAttributes(currAtts);
    }

    public void removeFromParent() {
        TagHolder parent = this.selectedHolder.getParent();
        parent.removeChild(this.selectedHolder);
        this.selectedHolder = parent;
    }

    public void removeSelectionChangedLIstener(ITreeSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    /*
     * Unable to fully structure code
     */
    public boolean saveFile(IFile file, boolean fromDocProvider) throws CoreException {
        block14: {
            block11: {
                stream = null;
                if (fromDocProvider) ** GOTO lbl24
                if (this.dirtyFiles.get(file) != null) break block11;
                while (true) {
                    var6_4 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                            stream = null;
                        }
                    }
                    catch (IOException v0) {}
                    return false;
                }
            }
            con = this.getUpdatedFileContents(file);
            contents = "";
            if (con == null) ** continue;
            contents = (String)con;
            stream = new ByteArrayInputStream(contents.getBytes());
            break block14;
lbl24:
            // 1 sources

            contents = this.getDocumentProvider().getDocument(this.getInput()).get();
            stream = new ByteArrayInputStream(contents.getBytes());
        }
        file.refreshLocal(2, null);
        file.setContents(stream, false, true, null);
        this.dirtyFiles.remove(file);
        var6_5 = null;
        try {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
        catch (IOException v1) {}
        return true;
        catch (Throwable var7_10) {
            var6_6 = null;
            try {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
            }
            catch (IOException v2) {}
            throw var7_10;
        }
    }

    public void setAttribute(String name, String value) {
        AttributeHolder ah = this.selectedHolder.getAttribute(name);
        ah.setValue(value);
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setContents() {
        TagHolder selection;
        TagHolder top = selection = this.getSelection();
        while (top.getParent() != null) {
            top = top.getParent();
        }
        this.getManager().replaceTopHolder(top);
    }

    public void setData(String text) {
        this.selectedHolder.setData(text);
    }

    public void setDocumentProvider(IDocumentProvider provider) {
        this.provider = provider;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setSelected(TagHolder selectedHolder) {
        this.selectedHolder = selectedHolder;
        this.notifySelectionListeners();
    }

    public void updateFile(IFile file, String newContents) {
        this.dirtyFiles.put(file, newContents);
    }

    public void updateModel(IFile file) {
        this.rebuild();
    }
}

