/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml.schema;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaBuild
extends DefaultHandler {
    private Node rootNode = null;
    private Hashtable types = new Hashtable();
    private Hashtable attributeGroups = new Hashtable();
    private Hashtable elements = new Hashtable();
    private Hashtable attributes = new Hashtable();

    public static void main(String[] args) {
        SchemaBuild test = new SchemaBuild();
        test.run();
    }

    public void addAttribute(String key, Node node) {
        this.attributes.put(key, node);
    }

    public void addAttributeGroup(String key, Node node) {
        this.attributeGroups.put(key, node);
    }

    public void addElement(String key, Node node) {
        if (this.getRootNode() == null) {
            this.setRootNode(node);
        }
        this.elements.put(key, node);
    }

    public void addType(String key, Node node) {
        this.types.put(key, node);
    }

    public Vector collectElements(Node node) {
        Object object;
        Vector<Node> result = new Vector<Node>();
        String name = node.getLocalName();
        if ("element".equals(name)) {
            result.addElement(node);
        }
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            result.addAll(this.collectElements(childNode));
            ++i;
        }
        Node typeNode = null;
        String typeName = this.findAttribute(node, "type");
        if (typeName != null && (object = this.types.get(typeName)) instanceof Node) {
            typeNode = (Node)object;
            result.addAll(this.collectElements(typeNode));
        }
        return result;
    }

    public StringWriter createStringWriter() {
        return new StringWriter();
    }

    public void error(SAXParseException e) {
        System.out.println(e);
        System.out.println("error line number=" + e.getLineNumber());
    }

    public void fatalError(SAXParseException e) {
        System.out.println(e);
        System.out.println("error line number=" + e.getLineNumber());
    }

    public String findAttribute(Node element, String attributeName) {
        if (element != null) {
            NamedNodeMap attributes = element.getAttributes();
            String value = "";
            if (attributes != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    Node attribute = attributes.item(i);
                    String name = attribute.getLocalName();
                    if (attributeName.equals(name)) {
                        value = attribute.getNodeValue();
                        return value;
                    }
                    ++i;
                }
            }
        }
        return "";
    }

    public Hashtable getAttributeGroups() {
        return this.attributeGroups;
    }

    public String getAttributeType(Node node) {
        String type = this.findAttribute(node, "type");
        if (type.length() == 0) {
            return "string";
        }
        return type;
    }

    public String getAttributeUse(Node node) {
        String use = this.findAttribute(node, "use");
        if (use.length() == 0) {
            return "optional";
        }
        return use;
    }

    public String getDocumentation(Node node) {
        String name = node.getLocalName();
        if ("documentation".equals(name)) {
            StringBuffer buffer = new StringBuffer();
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node childNode = list.item(i);
                buffer.append(childNode.getNodeValue());
                ++i;
            }
            return buffer.toString();
        }
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            String doc;
            Node childNode = list.item(i);
            String cname = childNode.getLocalName();
            if (("annotation".equals(cname) || "documentation".equals(cname)) && (doc = this.getDocumentation(childNode)).length() > 0) {
                return doc;
            }
            ++i;
        }
        return "";
    }

    public String getDocumentationType(Node node) {
        String typeName = this.findAttribute(node, "type");
        Object typeNode = this.types.get(typeName);
        if (typeNode instanceof Node) {
            return this.getDocumentation((Node)typeNode);
        }
        return this.getDocumentation(node);
    }

    public String getElementUse(Node node) {
        StringBuffer buffer = new StringBuffer();
        String min = this.findAttribute(node, "minOccurs");
        if (min.length() == 0) {
            min = "1";
        }
        buffer.append(min);
        String max = this.findAttribute(node, "maxOccurs");
        if (max.length() == 0) {
            max = "1";
        }
        buffer.append(" to ");
        buffer.append(max);
        return buffer.toString();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    protected InputStream getSchemaStream() throws Exception {
        return ParserUtilities.getDeviceKitSchema();
    }

    public Hashtable getTypes() {
        return this.types;
    }

    public boolean includes(Vector list, Node node) {
        if (node == null) {
            return true;
        }
        if (list != null) {
            if (list.indexOf(node) >= 0) {
                return true;
            }
            String name = this.findAttribute(node, "name");
            int i = 0;
            while (i < list.size()) {
                Node anode = (Node)list.elementAt(i);
                String aname = this.findAttribute(anode, "name");
                if (name.equals(aname)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String printAttributeType(String type) {
        if (type.startsWith("xsd:")) {
            return type.substring(4);
        }
        return type;
    }

    public String printElement(String key) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("&lt;");
        buffer.append(key);
        buffer.append("&gt;");
        return buffer.toString();
    }

    public void process(Node node) {
        String name = node.getLocalName();
        if ("element".equals(name)) {
            this.processElement(node);
        } else if ("attribute".equals(name)) {
            this.processAttribute(node);
        } else if ("attributeGroup".equals(name)) {
            this.processAttributeGroup(node);
        } else if (name != null && name.endsWith("Type")) {
            this.processType(node);
        } else {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node childNode = list.item(i);
                this.process(childNode);
                ++i;
            }
        }
    }

    public void processAttribute(Node element) {
        NamedNodeMap attributes = element.getAttributes();
        String value = "";
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            value = this.processSchemaAttribute(element, attribute);
            if (value.length() > 0) {
                this.addAttribute(value, element);
            }
            ++i;
        }
        NodeList list = element.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            Node childNode = list.item(i2);
            this.process(childNode);
            ++i2;
        }
    }

    public void processAttributeGroup(Node element) {
        NamedNodeMap attributes = element.getAttributes();
        String value = "";
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            value = this.processSchemaAttribute(element, attribute);
            if (value.length() > 0) {
                this.addAttributeGroup(value, element);
            }
            ++i;
        }
        NodeList list = element.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            Node childNode = list.item(i2);
            this.process(childNode);
            ++i2;
        }
    }

    public void processElement(Node element) {
        NamedNodeMap attributes = element.getAttributes();
        String value = "";
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            value = this.processSchemaAttribute(element, attribute);
            if (value.length() > 0) {
                this.addElement(value, element);
            }
            ++i;
        }
        NodeList list = element.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            Node childNode = list.item(i2);
            this.process(childNode);
            ++i2;
        }
    }

    public String processSchemaAttribute(Node element, Node attribute) {
        String name = attribute.getLocalName();
        String value = attribute.getNodeValue();
        String nameValue = "";
        if ("name".equals(name)) {
            nameValue = value;
        }
        return nameValue;
    }

    public void processType(Node element) {
        NamedNodeMap attributes = element.getAttributes();
        String value = "";
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            value = this.processSchemaAttribute(element, attribute);
            if (value.length() > 0) {
                this.addType(value, element);
            }
            ++i;
        }
        NodeList list = element.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            Node childNode = list.item(i2);
            this.process(childNode);
            ++i2;
        }
    }

    public void run() {
        try {
            InputStream stream = this.getSchemaStream();
            if (stream != null) {
                Document document = ParserUtilities.parse((InputStream)stream, (ErrorHandler)this, null);
                NodeList list = document.getElementsByTagName("xs:schema");
                int i = 0;
                while (i < list.getLength()) {
                    this.process(list.item(i));
                    ++i;
                }
            }
        }
        catch (Throwable exp1) {
            exp1.printStackTrace();
        }
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
    }

    public void warning(SAXParseException e) {
        System.out.println(e);
        System.out.println("warning line number=" + e.getLineNumber());
    }
}

