/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.agent.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.agent.service.AgentService;
import org.eclipse.soda.dk.agent.test.AgentTestResourceBundle;
import org.eclipse.soda.dk.agent.test.service.AgentTestService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.client.NotificationClient;
import org.eclipse.soda.dk.notification.client.NotificationController;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.service.ConnectionTransportService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class AgentTest
extends NotificationClient
implements AgentTestService,
Runnable,
CommandListener,
SignalListener,
MeasurementListener,
DeviceListener {
    public static final String CLASS_NAME;
    public static final int DEFAULT_PRIORITY = 3;
    public static final int DEFAULT_TEST_COUNT = 2;
    public static final long DEFAULT_TEST_DELAY = 0L;
    public static final boolean DEFAULT_TEST_EXECUTE = false;
    public static final boolean DEFAULT_TEST_EXECUTE_READ = true;
    public static final boolean DEFAULT_TEST_EXECUTE_WRITE = false;
    public static final boolean DEFAULT_TEST_READ = false;
    public static final boolean DEFAULT_TEST_TRIGGER = false;
    public static final long DEFAULT_TOTAL_TEST_TIME = 60000L;
    public static final long DEFAULT_READ_TIMEOUT = 10000L;
    protected static final int DEVICE_TEST_DEAD_STATE_RESOURCE = 6500;
    protected static final int DEVICE_TEST_CREATED_STATE_RESOURCE = 6501;
    protected static final int DEVICE_TEST_ALIVE_STATE_RESOURCE = 6502;
    protected static final int DEVICE_TEST_CONNECTED_STATE_RESOURCE = 6503;
    protected static final int DEVICE_TEST_ACTIVE_STATE_RESOURCE = 6504;
    protected static final int DEVICE_TEST_STARTED_STATE_RESOURCE = 6505;
    protected static final int[] DEVICE_TEST_STATE_RESOURCE_TABLE;
    protected static final int DEVICE_TEST_ERROR_NOTIFICATION_RESOURCE = 6506;
    protected static final int DEVICE_TEST_SIGNAL_NOTIFICATION_RESOURCE = 6507;
    protected static final int DEVICE_TEST_SIGNAL_DATA_NOTIFICATION_RESOURCE = 6508;
    protected static final int DEVICE_TEST_COMMAND_NOTIFICATION_RESOURCE = 6509;
    protected static final int DEVICE_TEST_COMMAND_DATA_NOTIFICATION_RESOURCE = 6510;
    protected static final int DEVICE_TEST_MEASUREMENT_NOTIFICATION_RESOURCE = 6511;
    protected static final int DEVICE_TEST_MEASUREMENT_VALUE_NOTIFICATION_RESOURCE = 6512;
    protected static final int DEVICE_TEST_START_RESOURCE = 6513;
    protected static final int DEVICE_TEST_STOP_RESOURCE = 6514;
    protected static final int DEVICE_TEST_WAITING_RESOURCE = 6515;
    protected static final int DEVICE_TEST_SEND_EXCEPTION_RESOURCE = 6516;
    protected static final int DEVICE_TEST_COMMAND_NOT_FOUND_RESOURCE = 6517;
    protected static final int DEVICE_TEST_MEASUREMENT_NOT_FOUND_RESOURCE = 6518;
    protected static final int DEVICE_TEST_SIGNAL_NOT_FOUND_RESOURCE = 6519;
    protected static final int DEVICE_TEST_COMMAND_EXCEPTION_RESOURCE = 6520;
    protected static final int DEVICE_TEST_MEASUREMENT_EXCEPTION_RESOURCE = 6521;
    protected static final int DEVICE_TEST_SIGNAL_EXCEPTION_RESOURCE = 6522;
    protected static final int DEVICE_TEST_START_EXECUTION_RESOURCE = 6523;
    protected static final int DEVICE_TEST_STOP_EXECUTION_RESOURCE = 6524;
    protected static final int DEVICE_TEST_CONTROL_NOTIFICATION_RESOURCE = 6525;
    protected static final int DEVICE_TEST_EXIT_RESOURCE = 6526;
    protected static final int DEVICE_TEST_DEVICE_CONFIGURATION_MISCOMPARE_RESOURCE = 6527;
    protected static final int DEVICE_TEST_DATA_NOTIFICATION_RESOURCE = 6528;
    private static ResourceBundle DefaultResourceBundle;
    private boolean active = false;
    private DeviceService device = null;
    private AgentService agent = null;
    private int testCount = AgentTest.getStaticInt((String)"devicetest.testcount", (int)2);
    private long testDelay = this.getLong("devicetest.testdelay", 0L);
    private boolean testExecute = AgentTest.getStaticBoolean((String)"devicetest.testexecute", (boolean)false);
    private boolean testExecuteRead = AgentTest.getStaticBoolean((String)"devicetest.testexecuteread", (boolean)true);
    private boolean testExecuteWrite = AgentTest.getStaticBoolean((String)"devicetest.testexecutewrite", (boolean)false);
    private boolean testRead = AgentTest.getStaticBoolean((String)"devicetest.testread", (boolean)false);
    private boolean testTrigger = AgentTest.getStaticBoolean((String)"devicetest.testtrigger", (boolean)false);
    private long totalTestTime = AgentTest.getStaticLong((String)"devicetest.totaltesttime", (long)0L);
    private long readTimeout = 0L;
    private int priority = AgentTest.getStaticInt((String)"devicetest.priority", (int)3);
    private Thread thread = null;
    private final Object stateChanged = new Object();
    private ConfigurationService configurationService = null;
    protected Dictionary deviceConfigurationInformation = null;
    private long startTime = System.currentTimeMillis();
    protected boolean configurationSave = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.agent.test.AgentTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        DEVICE_TEST_STATE_RESOURCE_TABLE = new int[]{6500, 6501, 6502, 6503, 6504, 6505};
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.soda.dk.agent.test.AgentTestResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz2);
    }

    public void checkNotification() {
        NotificationController notificationController;
        NotificationService notificationService;
        if (this.device != null && (notificationService = this.device.getNotificationService()) != null && (notificationController = this.getNotificationController()) == null) {
            this.setNotificationService(notificationService);
            this.register("*");
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        if (data == null) {
            this.report(null, 6509, source, Nls.formatTimestamp((Object)timestamp));
        } else {
            this.report(null, 6510, source, Nls.formatTimestamp((Object)timestamp), data);
        }
    }

    public void controlChanged(DeviceService container, Object timestamp, ControlService control, int code) {
        this.report(null, 6525, control, Nls.formatTimestamp((Object)timestamp), new Integer(code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceChanged(DeviceService deviceService, Object timestamp, int newState, int oldState) {
        this.report(null, DEVICE_TEST_STATE_RESOURCE_TABLE[newState], Transport.STATE_STRINGS[oldState]);
        this.checkNotification();
        if (newState >= 5) {
            this.test();
        }
        Object object = this.stateChanged;
        synchronized (object) {
            this.stateChanged.notifyAll();
        }
    }

    public void deviceConfigurationCompare() {
        DeviceService device = this.getDevice();
        if (device != null) {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
            Enumeration enumeration = device.elements();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!(object instanceof MeasurementService)) continue;
                MeasurementService measurement = (MeasurementService)object;
                String key = measurement.getKey();
                Object value = measurement.getValue();
                if (value == null || !(value instanceof String) && !(value instanceof Number) && !(value instanceof Boolean)) continue;
                ((Dictionary)dictionary).put(key, value);
            }
            this.setDeviceConfigurationInformation(dictionary);
            String className = this.getClass().getName();
            int index = className.lastIndexOf(46);
            if (index > 0) {
                String simpleName = className.substring(index + 1, className.length());
                InputStream cis = this.getClass().getResourceAsStream(String.valueOf(simpleName) + ".properties");
                if (cis != null) {
                    Properties properties = new Properties();
                    try {
                        BufferedInputStream is = new BufferedInputStream(cis);
                        properties.load(is);
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    enumeration = ((Dictionary)dictionary).keys();
                    while (enumeration.hasMoreElements()) {
                        Object key = enumeration.nextElement();
                        if (key.equals("state")) continue;
                        Object configurationValue = properties.get(key);
                        Object value = ((Dictionary)dictionary).get(key);
                        if (configurationValue == null || value.equals(configurationValue) || value.toString().equals(configurationValue.toString())) continue;
                        this.report(null, 6527, key, configurationValue, value);
                    }
                }
            }
        }
    }

    public void deviceConfigurationSave() {
        String className;
        int index;
        Dictionary dictionary = this.getDeviceConfigurationInformation();
        if (dictionary != null && (index = (className = this.getClass().getName()).lastIndexOf(46)) > 0) {
            String simpleName = className.substring(index + 1, className.length());
            int size = dictionary.size();
            InputStream is = this.getClass().getResourceAsStream(String.valueOf(simpleName) + ".properties");
            if (is == null || this.isConfigurationSave()) {
                Object[] keys = new String[size];
                int i = 0;
                Enumeration enumeration = dictionary.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    keys[i++] = String.valueOf(key);
                }
                Arrays.sort(keys);
                StringBuffer buffer = new StringBuffer(1024);
                Calendar calendar = Calendar.getInstance();
                int year = calendar.get(1);
                buffer.append(Nls.format((String)this.getCopyright(), (Object[])new Object[]{this.getVendor(), new Integer(year)}));
                buffer.append("# Date: ");
                buffer.append(calendar.getTime());
                buffer.append('\r');
                buffer.append('\n');
                int j = 0;
                while (j < size) {
                    Object key = keys[j];
                    if (!((String)key).equals("state")) {
                        buffer.append((String)key);
                        buffer.append('=');
                        Object value = dictionary.get(key);
                        buffer.append(value);
                        buffer.append('\r');
                        buffer.append('\n');
                    }
                    ++j;
                }
                try {
                    StringBuffer cbuffer = new StringBuffer(1024);
                    cbuffer.append("src");
                    cbuffer.append('/');
                    cbuffer.append(className.replace('.', '/'));
                    cbuffer.append(".properties");
                    File file = new File(cbuffer.toString());
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(buffer.toString().getBytes());
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void endTests() {
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        this.report(null, 6506, Nls.formatTimestamp((Object)timestamp), data);
    }

    public void exit() {
        this.stop();
        this.setDevice(null);
    }

    public String formatData(Object data) {
        StringBuffer buffer = new StringBuffer(256);
        Nls.formatData((StringBuffer)buffer, (Object)data);
        return buffer.toString();
    }

    public AgentService getAgent() {
        return this.agent;
    }

    public Dictionary getConfigurationInformation() {
        if (this.configurationService == null) {
            return null;
        }
        return this.configurationService.getProperties();
    }

    public Object getConfigurationInformation(String propertyName) {
        if (this.configurationService == null) {
            return null;
        }
        return this.getConfigurationInformation().get(propertyName);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public String getCopyright() {
        return "# (C) Copyright {0} Corp. {1} All Rights Reserved\r\n";
    }

    public AgentService getDefaultAgent() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return null;
    }

    public DeviceService getDefaultDevice() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return null;
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public Dictionary getDeviceConfigurationInformation() {
        return this.deviceConfigurationInformation;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 6506: 
            case 6516: 
            case 6517: 
            case 6518: 
            case 6519: 
            case 6520: 
            case 6521: 
            case 6522: 
            case 6527: {
                return 2;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public Object getLogDetails4() {
        TransportService transport = this.getTransport();
        ConnectionService connection = null;
        if (transport instanceof ConnectionTransportService) {
            connection = ((ConnectionTransportService)transport).getConnection();
        }
        return String.valueOf(connection);
    }

    public Object getLogDetails5() {
        return String.valueOf(this.getTransport());
    }

    public Object getLogDetails6() {
        return String.valueOf(this.getDevice());
    }

    public int getPriority() {
        return this.priority;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(AgentTestResourceBundle.getKey(resourceId));
        }
        catch (Exception exception) {
            return super.getResource(resourceId);
        }
    }

    public int getTestCount() {
        return this.testCount;
    }

    public long getTestDelay() {
        return this.testDelay;
    }

    public boolean getTestExecute() {
        return this.testExecute;
    }

    public boolean getTestExecuteRead() {
        return this.testExecuteRead;
    }

    public boolean getTestExecuteWrite() {
        return this.testExecuteWrite;
    }

    public boolean getTestRead() {
        return this.testRead;
    }

    public boolean getTestTrigger() {
        return this.testTrigger;
    }

    public Thread getThread() {
        return this.thread;
    }

    public long getTotalTestTime() {
        return this.totalTestTime;
    }

    public TransportService getTransport() {
        TransportService transport = null;
        DeviceService device = this.getDevice();
        if (device != null) {
            transport = device.getTransport();
        }
        return transport;
    }

    public String getVendor() {
        return "IBM";
    }

    public boolean isActive() {
        DeviceService device = this.getDevice();
        return this.active && device != null && device.getState() >= 5;
    }

    public boolean isConfigurationSave() {
        return this.configurationSave;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.report(null, 6511, source, Nls.formatTimestamp((Object)timestamp), newValue, oldValue);
    }

    public void notificationReceived(String externalKey, Object data) {
        this.report(null, 6528, externalKey, Nls.formatTimestamp((Object)AgentTest.getCurrentTimestamp()), data);
        super.notificationReceived(externalKey, data);
    }

    public void putConfigurationInformation(String propertyName, Object value) {
        if (this.configurationService == null) {
            this.setConfigurationInformation(new Hashtable());
        }
        this.getConfigurationInformation().put(propertyName, value);
    }

    public void run() {
        this.checkNotification();
        this.waitForStarted();
        this.report(null, 6523, null);
        int testCount = this.getTestCount();
        this.startTests();
        int i = 0;
        while (i < testCount) {
            this.runTests();
            ++i;
        }
        this.endTests();
        long end = System.currentTimeMillis();
        this.report(null, 6524, new Long(end - this.startTime));
        this.deviceConfigurationCompare();
    }

    public void run(String[] args) {
        try {
            System.gc();
            System.gc();
            long timeStart = System.currentTimeMillis();
            long freeMemoryStart = Runtime.getRuntime().freeMemory();
            Notification notification = new Notification();
            notification.start();
            this.setNotificationService((NotificationService)notification);
            this.register("*");
            AgentService agent = this.getDefaultAgent();
            Hashtable<String, String> configurationInformation = new Hashtable<String, String>();
            agent.setNotificationService((NotificationService)notification);
            configurationInformation.put("id", "0");
            agent.setConfigurationInformation(configurationInformation);
            this.setAgent(agent);
            DeviceService device = this.getDefaultDevice();
            device.setNotificationService((NotificationService)notification);
            device.setConfigurationInformation(configurationInformation);
            this.setDevice(device);
            this.start();
            device.start();
            this.sleep(this.getTotalTestTime());
            long timeEnd = System.currentTimeMillis();
            System.gc();
            System.gc();
            long freeMemoryEnd = Runtime.getRuntime().freeMemory();
            TransportService transportService = device.getTransport();
            this.stop();
            device.exit();
            if (transportService != null) {
                transportService.exit();
            }
            this.report(null, 6526, new Long(timeEnd - timeStart), new Long(freeMemoryStart - freeMemoryEnd));
            this.deviceConfigurationSave();
            notification.exit();
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
    }

    public void runTests() {
        if (this.device != null) {
            this.checkNotification();
            Enumeration enumeration = this.getDevice().elements();
            while (enumeration.hasMoreElements()) {
                this.waitForStarted();
                Object control = enumeration.nextElement();
                if (control instanceof MeasurementService) {
                    this.testMeasurement(((MeasurementService)control).getKey());
                }
                if (control instanceof SignalService) {
                    this.testSignal(((SignalService)control).getKey());
                }
                if (control instanceof CommandService) {
                    this.testCommand(((CommandService)control).getKey());
                }
                this.sleep(10L);
            }
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setAgent(AgentService agent) {
        this.agent = agent;
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        this.configurationService = new EscConfiguration(configurationInformation);
    }

    public void setConfigurationSave(boolean configurationSave) {
        this.configurationSave = configurationSave;
    }

    public void setDevice(DeviceService device) {
        Object control;
        Enumeration enumeration;
        if (this.device != null) {
            this.device.removeDeviceListener((DeviceListener)this);
            enumeration = this.getDevice().elements();
            while (enumeration.hasMoreElements()) {
                control = enumeration.nextElement();
                if (control instanceof MeasurementService) {
                    ((MeasurementService)control).removeMeasurementListener((MeasurementListener)this);
                }
                if (control instanceof SignalService) {
                    ((SignalService)control).removeSignalListener((SignalListener)this);
                }
                if (!(control instanceof CommandService)) continue;
                ((CommandService)control).removeCommandListener((CommandListener)this);
            }
            NotificationService notificationService = this.getNotificationService();
            if (notificationService != null) {
                this.unregister();
                this.setNotificationService(null);
            }
        }
        this.device = device;
        if (this.device != null) {
            this.device.addDeviceListener((DeviceListener)this);
            enumeration = this.getDevice().elements();
            while (enumeration.hasMoreElements()) {
                control = enumeration.nextElement();
                if (control instanceof MeasurementService) {
                    ((MeasurementService)control).addMeasurementListener((MeasurementListener)this);
                }
                if (control instanceof SignalService) {
                    ((SignalService)control).addSignalListener((SignalListener)this);
                }
                if (!(control instanceof CommandService)) continue;
                ((CommandService)control).addCommandListener((CommandListener)this);
            }
        }
        this.checkNotification();
        if (this.isActive()) {
            this.test();
        }
    }

    public void setDeviceConfigurationInformation(Dictionary deviceConfigurationInformation) {
        this.deviceConfigurationInformation = deviceConfigurationInformation;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setTestCount(int testCount) {
        this.testCount = testCount;
    }

    public void setTestDelay(long testDelay) {
        this.testDelay = testDelay;
    }

    public void setTestExecute(boolean testExecute) {
        this.testExecute = testExecute;
    }

    public void setTestExecuteRead(boolean testExecuteRead) {
        this.testExecuteRead = testExecuteRead;
    }

    public void setTestExecuteWrite(boolean testExecuteWrite) {
        this.testExecuteWrite = testExecuteWrite;
    }

    public void setTestRead(boolean testRead) {
        this.testRead = testRead;
    }

    public void setTestTrigger(boolean testTrigger) {
        this.testTrigger = testTrigger;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setTotalTestTime(long totalTestTime) {
        this.totalTestTime = totalTestTime;
    }

    public void setup() {
        this.setPriority(this.getInt("devicetest.priority", 3));
        this.setTotalTestTime(this.getLong("devicetest.totaltesttime", 60000L));
        this.setTotalTestTime(this.getLong("devicetest.readtimeout", 10000L));
        this.setTestCount(this.getInt("devicetest.testcount", 2));
        this.setTestDelay(this.getLong("devicetest.testdelay", 0L));
        this.setTestExecute(this.getBoolean("devicetest.testexecute", false));
        this.setTestExecuteRead(this.getBoolean("devicetest.testexecuteread", true));
        this.setTestExecuteWrite(this.getBoolean("devicetest.testexecutewrite", false));
        this.setTestRead(this.getBoolean("devicetest.testread", false));
        this.setTestTrigger(this.getBoolean("devicetest.testtrigger", false));
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (data == null) {
            this.report(null, 6507, source, Nls.formatTimestamp((Object)timestamp));
        } else {
            this.report(null, 6508, source, Nls.formatTimestamp((Object)timestamp), data);
        }
    }

    public void start() {
        this.setup();
        this.setActive(true);
        if (this.getDevice() != null) {
            this.report(null, 6513, null);
            this.test();
        }
    }

    public void startTests() {
    }

    public void stop() {
        this.setActive(false);
        Thread thread = this.getThread();
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join(2000L);
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setThread(null);
        }
        this.report(null, 6514, null);
    }

    public void test() {
        Thread thread = this.getThread();
        if (thread == null) {
            this.setThread(new Thread((Runnable)this, String.valueOf(this.getOutputName())));
            this.getThread().setPriority(this.getPriority());
            this.getThread().start();
        } else if (!thread.isAlive()) {
            this.setThread(null);
        }
    }

    public void testCommand(String commandName) {
        if (this.isActive()) {
            try {
                CommandService command = this.getDevice().getCommand(commandName);
                if (command == null) {
                    this.report(null, 6517, commandName);
                } else if (this.getTestExecute() && this.isActive()) {
                    command.execute();
                }
            }
            catch (Exception exception) {
                this.report(exception, 6520, commandName);
            }
        }
    }

    public void testMeasurement(String measurementName) {
        if (this.isActive()) {
            try {
                MeasurementService measurement = this.getDevice().getMeasurement(measurementName);
                if (measurement == null) {
                    this.report(null, 6518, measurementName);
                } else {
                    Object value;
                    if (this.getTestRead() && this.isActive()) {
                        value = measurement.read(this.getReadTimeout());
                        this.report(null, 6512, measurement, value);
                        this.broadcast(measurement + "/read", null);
                    }
                    if (this.getTestExecuteRead() && this.isActive()) {
                        measurement.executeRead();
                        this.broadcast(measurement + "/read", null);
                    }
                    value = measurement.getValue();
                    this.report(null, 6512, measurement, value);
                    this.broadcast(measurement + "/get", null);
                    if (value != null && this.getTestExecuteWrite() && this.isActive()) {
                        measurement.executeWrite(value);
                        Hashtable<String, Object> data = new Hashtable<String, Object>();
                        data.put("value", value);
                        this.broadcast(measurement + "/write", data);
                    }
                }
            }
            catch (Exception exception) {
                this.report(exception, 6521, measurementName);
            }
        }
    }

    public void testSignal(String signalName) {
        if (this.isActive()) {
            try {
                SignalService signal = this.getDevice().getSignal(signalName);
                if (signal == null) {
                    this.report(null, 6519, signalName);
                } else if (this.getTestTrigger() && this.isActive()) {
                    signal.trigger();
                }
            }
            catch (Exception exception) {
                this.report(exception, 6522, signalName);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getOutputName());
        Dictionary configuration = this.getConfigurationInformation();
        if (configuration != null) {
            buffer.append(configuration);
        } else {
            buffer.append('{');
            buffer.append("testcount=");
            buffer.append(this.getTestCount());
            buffer.append(",testdelay=");
            buffer.append(this.getTestDelay());
            buffer.append(",totaltesttime=");
            buffer.append(this.getTotalTestTime());
            buffer.append('}');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStarted() {
        long startTime = System.currentTimeMillis();
        long waitTime = 1000L;
        while (!this.isActive() && this.getDevice() != null) {
            try {
                long currentTime = System.currentTimeMillis();
                Long time = new Long(currentTime - startTime);
                this.report(null, 6515, time);
                Object object = this.stateChanged;
                synchronized (object) {
                    this.stateChanged.wait(waitTime);
                    if ((waitTime <<= 1) > this.getTotalTestTime()) {
                        waitTime = this.getTotalTestTime();
                    }
                }
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
        }
    }
}

