/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.profile.managed;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.bundle.ServiceInterestBundle;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.profile.DeviceProfile;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public abstract class ProfileManaged
extends ServiceInterestBundle
implements ManagedService {
    private ProfileService profile;

    public Object createService() {
        DeviceService device = this.getDevice();
        if (this.profile == null) {
            this.profile = this.createService(device);
        } else if (this.profile instanceof DeviceProfile) {
            ((Profile)this.profile).setDevice(device);
        }
        if (this.profile instanceof Profile) {
            ((Profile)this.profile).setBundleContext(this.getBundleContext());
        }
        this.profile.start();
        return this.profile;
    }

    public ProfileService createService(DeviceService device) {
        return null;
    }

    protected void deactivate() {
        if (this.getProfile() != null) {
            try {
                this.getProfile().exit();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
        }
    }

    public DeviceService getDevice() {
        Object intest = this.getInterest();
        if (intest instanceof DeviceService) {
            return (DeviceService)intest;
        }
        return null;
    }

    public String getDeviceServiceName() {
        return "";
    }

    public String getInterestServiceName() {
        return this.getDeviceServiceName();
    }

    public String[] getMatchAdapterClasses() {
        return new String[0];
    }

    public ProfileService getProfile() {
        if (this.getService() instanceof ProfileService) {
            return (ProfileService)this.getService();
        }
        return null;
    }

    public String getServiceName() {
        return ProfileService.SERVICE_NAME;
    }

    public void setInterest(Object interest) {
        super.setInterest(interest);
        if (this.profile instanceof DeviceProfile) {
            ((Profile)this.profile).setDevice((DeviceService)interest);
        }
    }

    public void updateProperties(Dictionary table, Dictionary from) {
        if (from != null) {
            Enumeration enumeration = from.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = from.get(key);
                table.put(key, value);
            }
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        ProfileService object;
        ProfileService profileOld = this.getProfile();
        if (profileOld != null) {
            this.removeExportedService(ProfileService.SERVICE_NAME);
            profileOld.exit();
            this.setService(null);
        }
        if ((object = this.createService(null)) instanceof ProfileService) {
            ProfileService profileService = object;
            profileService.setConfigurationInformation(properties);
            try {
                profileService.start();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setService(object);
            String[] names = this.getExportedServiceNames();
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            this.addExportedServices(names, object, serviceProperties);
        }
    }
}

