/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport.factory;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.ManagedServiceFactoryBundleActivator;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

public abstract class TransportFactory
extends ManagedServiceFactoryBundleActivator
implements ManagedServiceFactory,
IManagedServiceFactoryAdvisor {
    public static final String ID_KEY_FILTER = "(id=";
    public static final String[] OPTIONAL_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    public static final String METATYPE_SERVICE;
    public static final String[] OPTIONAL_SERVICE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.metatype.MetaTypeService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        METATYPE_SERVICE = clazz.getName();
        OPTIONAL_SERVICE = new String[]{METATYPE_SERVICE};
    }

    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        ConnectionService connection = this.isFactoryConnection(properties) ? (ConnectionService)manager.getImportedService(this.getInterestServiceName()) : null;
        TransportService transport = this.createService(connection);
        if (transport != null) {
            transport.setConfigurationInformation(properties);
            try {
                transport.start();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getExportedServiceNames(pid, new Hashtable(), properties, manager), (Object)transport, (Dictionary)serviceProperties);
        }
        return transport;
    }

    protected IManagedServiceFactoryAdvisor createAdvisor() {
        return this;
    }

    public void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        if (this.isFactoryConnection(properties)) {
            Object idFilter = properties.get("idimportfilter");
            String idFilterString = String.valueOf(idFilter);
            if (idFilter != null && idFilterString.length() > 0) {
                manager.addImportedServiceFilter(this.getInterestServiceName(), idFilterString);
            } else {
                String id = String.valueOf(properties.get("id"));
                String idString = String.valueOf(id);
                if (id != null && idString.length() > 0) {
                    StringBuffer buffer = new StringBuffer(ID_KEY_FILTER);
                    buffer.append(idString);
                    buffer.append(')');
                    String filter = buffer.toString();
                    manager.addImportedServiceFilter(this.getInterestServiceName(), filter);
                }
            }
        }
    }

    public Hashtable createProperties() {
        Hashtable properties = new Hashtable(37);
        return properties;
    }

    public abstract TransportService createService(ConnectionService var1);

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        try {
            TransportService transport = (TransportService)object;
            transport.exit();
            int count = 0;
            while (count < 20 && transport.getState() != 0) {
                Thread.sleep(100L);
                ++count;
            }
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
    }

    public String[] getExportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        return new String[]{TransportService.SERVICE_NAME};
    }

    public String[] getImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager manager) {
        return BaseBundleActivator.NO_SERVICES;
    }

    public String getInterestServiceName() {
        return "org.eclipse.soda.dk.connection.service.ConnectionService";
    }

    public String[] getOptionalImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return OPTIONAL_SERVICES;
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICE;
    }

    public void handleAcquiredOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof TransportService) {
            TransportService transport = (TransportService)object;
            if (importedService instanceof NotificationService) {
                transport.setNotificationService((NotificationService)importedService);
            }
        }
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
    }

    public void handleReleasedOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        if (object instanceof TransportService) {
            TransportService transport = (TransportService)object;
            transport.setNotificationService(null);
        }
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
    }

    public boolean isFactoryConnection(Dictionary properties) {
        Object value = properties.get("connection");
        return "factory".equals(value);
    }

    public synchronized Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        try {
            TransportService transport = (TransportService)object;
            manager.removeExportedService(TransportService.SERVICE_NAME, object);
            Thread.yield();
            transport.exit();
        }
        catch (Exception e) {
            EscObject.handleStaticException((Throwable)e);
        }
        return this.create(pid, properties, manager);
    }

    public void updateProperties(Dictionary table, Dictionary from) {
        Enumeration enumeration = from.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = from.get(key);
            table.put(key, value);
        }
    }

    public void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
        Object service;
        String idFilter;
        Object idFilterObject = properties.get("idimportfilter");
        if (idFilterObject != null && (idFilter = idFilterObject.toString()).length() > 0) {
            try {
                this.getBundleContext().createFilter(idFilter);
            }
            catch (Exception exception) {
                this.handleException((Exception)new ConfigurationException("idimportfilter", idFilter, (Throwable)exception));
            }
        }
        if ((service = this.getOptionalImportedService(METATYPE_SERVICE)) instanceof MetaTypeService) {
            MetaTypeService metatypeService = (MetaTypeService)service;
            MetaTypeInformation info = metatypeService.getMetaTypeInformation(this.getBundle());
            ConfigurableObject.validateConfiguration((String)pid, (Dictionary)properties, (MetaTypeInformation)info);
        }
    }
}

