/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;

public class Commands
extends Command
implements CommandListener {
    private CommandService[] commands;

    public Commands(String key, CommandService[] commands) {
        super(key);
        this.setCommands(commands);
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            try {
                commandListener.commandExecuted((CommandService)this, timestamp, data);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void execute() {
        int length = this.commands.length;
        int i = 0;
        while (i < length) {
            this.commands[i].execute();
            ++i;
        }
    }

    public void execute(Object object) {
        int length = this.commands.length;
        int i = 0;
        while (i < length) {
            this.commands[i].execute(object);
            ++i;
        }
    }

    public CommandService[] getCommands() {
        return this.commands;
    }

    protected void setCommands(CommandService[] commands) {
        this.commands = commands;
    }
}

