/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.SimpleMessageCommand;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class SimpleDataCommand
extends SimpleMessageCommand {
    public SimpleDataCommand(String key, MessageService message) {
        super(key, message);
    }

    public void execute(Object data) {
        if (data == null) {
            this.execute();
        } else {
            try {
                MessageService newMessage = (MessageService)this.getMessage().clone();
                this.getDevice().send(newMessage.encodeMessage(newMessage, data));
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
            CommandListener commandListener = this.getCommandListener();
            if (commandListener != null) {
                try {
                    this.fireCommandExecuted(commandListener, EscObject.getCurrentTimestamp(), data);
                }
                catch (Exception exception) {
                    this.log(1, this.toString(), exception);
                }
            }
        }
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        MessageService matchMessage;
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null && (matchMessage = this.getMessage().matches(message)) != null) {
            try {
                this.fireCommandExecuted(commandListener, timestamp, matchMessage.decodeMessage(message));
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
        }
    }
}

