/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.SimpleTransformCommand;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class SimpleParameterCommand
extends SimpleTransformCommand {
    private ParameterService parameter;

    public SimpleParameterCommand(String key, MessageService message, TransformService transform, ParameterService parameter) {
        super(key, message, transform);
        this.setParameter(parameter);
    }

    public void execute(Object data) {
        if (data == null) {
            this.execute();
        } else {
            try {
                Object writeData = this.encode(data);
                MessageService newMessage = (MessageService)this.getMessage().clone();
                this.getDevice().send(newMessage.encodeMessage(newMessage, this.getParameter(), writeData));
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
        }
    }

    public ParameterService getParameter() {
        return this.parameter;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        MessageService matchMessage;
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null && (matchMessage = this.getMessage().matches(message)) != null) {
            try {
                this.fireCommandExecuted(commandListener, timestamp, this.decode(matchMessage.decodeMessage(message, this.getParameter())));
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
        }
    }

    public void setParameter(ParameterService parameter) throws IllegalArgumentException {
        this.parameter = parameter;
    }
}

