/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.transform.service.TransformService;

public class StateCommand
extends Command {
    private ControlService control;
    private TransformService transform;
    private Object value;

    public StateCommand(String key, ControlService control, Object value, TransformService transform) {
        super(key);
        this.control = control;
        this.value = value;
        this.transform = transform;
    }

    public void execute() {
        Object value = this.getValue();
        this.execute(value);
    }

    public void execute(Object value) {
        ControlService control = this.getControl();
        if (control instanceof MeasurementService) {
            ((MeasurementService)control).executeWrite(value);
        } else {
            if (control instanceof CommandService) {
                ((CommandService)control).execute(value);
            }
            super.execute(value);
        }
    }

    public ControlService getControl() {
        return this.control;
    }

    public TransformService getTransform() {
        return this.transform;
    }

    public Object getValue() {
        Object value = null;
        ControlService control = this.getControl();
        if (control instanceof MeasurementService) {
            value = ((MeasurementService)control).getValue();
        }
        if (value == null) {
            return this.value;
        }
        TransformService transform = this.getTransform();
        if (transform == null) {
            return value;
        }
        return transform.decode(value);
    }
}

