/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import org.eclipse.soda.dk.device.ControlRegistry;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceRegistryService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;

public class DeviceRegistry
extends Device
implements DeviceService,
ControlRegistry,
DeviceRegistryService {
    private static DeviceRegistry DefaultDeviceRegistry = null;
    private DeviceService[] devices = new DeviceService[0];

    public DeviceRegistry() {
        this.setKey("DeviceRegistry");
        this.setState(1);
        this.initialize();
    }

    public static DeviceRegistry getDefaultDeviceRegistry() {
        return DefaultDeviceRegistry;
    }

    public static final synchronized void setDefaultDeviceRegistry(DeviceRegistry defaultDeviceRegistry) {
        DefaultDeviceRegistry = defaultDeviceRegistry;
    }

    public void exit() {
        super.exit();
        this.setDevices(null);
    }

    protected void finalize() throws Throwable {
        if (this.getState() > 0) {
            this.exit();
        }
    }

    public String getDefaultKey() {
        return "DeviceManager";
    }

    public DeviceService getDevice(String key) {
        return (DeviceService)this.get(key);
    }

    protected DeviceService[] getDevices() {
        return this.devices;
    }

    private void initialize() {
        this.capabilities = new Measurement("Device/Capabilities");
        this.status = new Measurement("Device/Status");
        this.configuration = new Measurement("Device/Configuration");
        this.put(this.configuration);
        this.put(this.status);
        this.put(this.capabilities);
    }

    protected void setDevices(DeviceService[] devices) {
        this.devices = devices;
        if (devices != null) {
            int i = 0;
            while (i < devices.length) {
                this.put(devices[i].getKey(), (ControlService)devices[i]);
                ++i;
            }
        }
    }

    public void start() {
        super.start();
        int i = 0;
        while (i < this.getDevices().length) {
            this.getDevices()[i].start();
            ++i;
        }
        this.setState(5);
    }

    public void stop() {
        int i = 0;
        while (i < this.getDevices().length) {
            this.getDevices()[i].stop();
            ++i;
        }
        this.setState(1);
    }
}

