/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Container;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.osgi.framework.BundleContext;

public class NotificationController
implements NotificationService,
NotificationListener,
SignalListener,
MeasurementListener,
CommandListener {
    protected char idSperator = (char)47;
    private NotificationService notificationService = null;
    private Hashtable controlsExternal;
    private String id = null;
    private Container container = null;
    private BundleContext bundleContext;
    private String symbolicName = "";

    public NotificationController(NotificationService notificationService, Container container) {
        this(notificationService, container, null);
    }

    public NotificationController(NotificationService notificationService, Container container, String id) {
        this.setId(id);
        this.setContainer(container);
        this.setNotificationService(notificationService);
    }

    public NotificationController() {
    }

    public void addData(Dictionary data) {
        if (data.get("timestamp") == null) {
            data.put("timestamp", EscObject.getCurrentTimestamp());
        }
        if (this.bundleContext != null && data.get("bundle.symbolicName") == null) {
            data.put("bundle.symbolicName", this.symbolicName);
        }
    }

    public void addQualifiedKeys(String id) {
        this.setId(id);
        this.removeQualifiedKeys();
        Hashtable controls = this.getContainer().getControls();
        int idLength = id != null ? id.length() : 0;
        Iterator iterator = controls.entrySet().iterator();
        StringBuffer buffer = new StringBuffer(idLength + 65);
        if (id != null) {
            buffer.append(id);
            buffer.append(this.idSperator);
        }
        int baseLength = buffer.length();
        buffer.append(this.container.getKey());
        String externalKeyDevice = buffer.toString();
        buffer.delete(baseLength, buffer.length());
        this.container.setQualifiedKey(externalKeyDevice);
        Hashtable capabilities = new Hashtable(1023);
        Hashtable controlMap = new Hashtable(13);
        if (this.notificationService != null) {
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = String.valueOf(entry.getKey());
                Control control = (Control)((Object)entry.getValue());
                buffer.append(key);
                String externalKey = buffer.toString();
                control.setQualifiedKey(externalKey);
                buffer.delete(baseLength, buffer.length());
                capabilities.put(key, controlMap);
                if (control instanceof SignalService) {
                    SignalService signal = (SignalService)control;
                    signal.addSignalListener((SignalListener)this);
                    String triggerKey = String.valueOf(externalKey) + "/trigger";
                    this.controlsExternal.put(triggerKey, control);
                    capabilities.put(String.valueOf(key) + "/execute", controlMap);
                }
                if (control instanceof MeasurementService) {
                    MeasurementService measurementService = (MeasurementService)control;
                    measurementService.addMeasurementListener((MeasurementListener)this);
                    String readKey = String.valueOf(externalKey) + "/read";
                    this.controlsExternal.put(readKey, control);
                    String writeKey = String.valueOf(externalKey) + "/write";
                    this.controlsExternal.put(writeKey, control);
                    String getKey = String.valueOf(externalKey) + "/get";
                    this.controlsExternal.put(getKey, control);
                    capabilities.put(String.valueOf(key) + "/get", controlMap);
                    capabilities.put(String.valueOf(key) + "/read", controlMap);
                    capabilities.put(String.valueOf(key) + "/write", controlMap);
                }
                if (!(control instanceof CommandService)) continue;
                CommandService commandService = (CommandService)control;
                commandService.addCommandListener((CommandListener)this);
                String executeKey = String.valueOf(externalKey) + "/execute";
                this.controlsExternal.put(executeKey, control);
                capabilities.put(String.valueOf(key) + "/execute", controlMap);
            }
            Set keySet = this.controlsExternal.keySet();
            String[] topics = new String[keySet.size()];
            topics = keySet.toArray(topics);
            this.notificationService.register(topics, (NotificationListener)this);
            this.container.capabilities.setValue(capabilities, Container.getCurrentTimestamp());
        }
    }

    public void broadcast(String externalKey, Dictionary data) {
        if (data != null) {
            this.addData(data);
        }
        this.getNotificationService().broadcast(externalKey, data);
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        Hashtable<String, Object> notifyData = new Hashtable<String, Object>(13);
        String key = source.getKey();
        notifyData.put("timestamp", timestamp);
        if (data != null) {
            notifyData.put("value", data);
        }
        notifyData.put("source", source.getKey());
        notifyData.put("keys", new String[]{key});
        this.notificationService.broadcast(source.toString(), notifyData);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        Hashtable<String, Object> notifyData = new Hashtable<String, Object>(13);
        notifyData.put("timestamp", timestamp);
        if (data != null) {
            notifyData.put("value", data);
        }
        if (data instanceof Exception) {
            notifyData.put("exception", data);
            notifyData.put("message", data.toString());
        }
        notifyData.put("source", source.toString());
        String sourceName = this.container.getQualifiedKey();
        if (source instanceof Control) {
            sourceName = ((Control)((Object)source)).getQualifiedKey();
        }
        this.notificationService.broadcast(String.valueOf(sourceName) + "/error", notifyData);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getId() {
        return this.id;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        Hashtable<String, Object> notifyData = new Hashtable<String, Object>(13);
        String key = source.getKey();
        notifyData.put("timestamp", timestamp);
        if (newValue != null) {
            notifyData.put("value", newValue);
            notifyData.put(key, newValue);
        }
        if (oldValue != null) {
            notifyData.put("value_old", oldValue);
        }
        notifyData.put("source", source.getKey());
        notifyData.put("keys", new String[]{key});
        this.notificationService.broadcast(source.toString(), notifyData);
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        Control control = (Control)((Object)this.controlsExternal.get(externalKey));
        if (control == null) {
            this.container.notificationReceived(externalKey, data);
            return;
        }
        Object value = null;
        if (data != null && (value = data.get("value")) == null) {
            value = data.get(control.getKey());
        }
        if (control instanceof SignalService) {
            SignalService signal = (SignalService)control;
            if (value == null) {
                signal.trigger();
            } else {
                signal.trigger(value);
            }
        }
        if (control instanceof MeasurementService) {
            MeasurementService measurement = (MeasurementService)control;
            if (externalKey.endsWith("/get")) {
                Hashtable<String, Object> notifyData = new Hashtable<String, Object>(13);
                Object measurementValue = measurement.getValue();
                if (measurementValue != null) {
                    notifyData.put("value", measurementValue);
                    notifyData.put(measurement.getKey(), measurementValue);
                    notifyData.put("timestamp", measurement.getTimestamp());
                } else {
                    notifyData.put("timestamp", EscObject.getCurrentTimestamp());
                }
                notifyData.put("source", measurement.getKey());
                notifyData.put("received_key", externalKey);
                this.notificationService.broadcast(measurement.toString(), notifyData);
            } else if (externalKey.endsWith("/write")) {
                measurement.executeWrite(value);
            } else if (externalKey.endsWith("/read")) {
                measurement.executeRead();
            } else if (externalKey.endsWith("/set")) {
                measurement.setValue(value);
            }
        }
        if (control instanceof CommandService) {
            CommandService commandService = (CommandService)control;
            if (value == null) {
                commandService.execute();
            } else {
                commandService.execute(value);
            }
        }
    }

    public void register(String externalKey, NotificationListener listener) {
        this.getNotificationService().register(externalKey, (NotificationListener)this);
    }

    public void register(String externalKey) {
        this.getNotificationService().register(externalKey, (NotificationListener)this);
    }

    public void register(String[] externalKeys, NotificationListener listener) {
        this.getNotificationService().register(externalKeys, (NotificationListener)this);
    }

    public void register(String[] externalKeys) {
        this.getNotificationService().register(externalKeys, (NotificationListener)this);
    }

    public void removeQualifiedKeys() {
        if (this.controlsExternal == null) {
            this.controlsExternal = new Hashtable();
        } else {
            Collection collection = this.controlsExternal.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object control = iterator.next();
                if (control instanceof CommandService) {
                    ((CommandService)control).removeCommandListener((CommandListener)this);
                }
                if (control instanceof SignalService) {
                    ((SignalService)control).removeSignalListener((SignalListener)this);
                }
                if (!(control instanceof MeasurementService)) continue;
                ((MeasurementService)control).removeMeasurementListener((MeasurementListener)this);
            }
            this.controlsExternal.clear();
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        if (this.bundleContext != null) {
            this.setSymbolicName(this.bundleContext.getBundle().getSymbolicName());
        }
    }

    public void setContainer(Container container) {
        this.container = container;
        if (this.container != null) {
            this.bundleContext = this.container.getBundleContext();
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNotificationService(NotificationService notificationService) {
        if (this.notificationService != null) {
            this.unregister();
            this.removeQualifiedKeys();
        }
        this.notificationService = notificationService;
        if (this.notificationService != null) {
            this.addQualifiedKeys(this.getId());
        }
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        Hashtable<String, Object> notifyData = new Hashtable<String, Object>(13);
        String key = source.getKey();
        notifyData.put("timestamp", timestamp);
        if (data != null) {
            notifyData.put("value", data);
            notifyData.put(source.getKey(), data);
        }
        notifyData.put("keys", new String[]{key});
        notifyData.put("source", key);
        this.notificationService.broadcast(source.toString(), notifyData);
    }

    public void unregister(NotificationListener listener) {
        this.notificationService.unregister(listener);
    }

    public void unregister() {
        this.unregister(this);
    }
}

