/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;

public class Measurements
extends Measurement
implements MeasurementListener {
    private MeasurementService[] measurements;

    public Measurements(String key, Object value, MeasurementService[] measurements) {
        super(key, value);
        this.setMeasurements(measurements);
        this.setValue(value, Measurements.getCurrentTimestamp());
        this.addInternalMeasurementListener();
    }

    public void addInternalMeasurementListener() {
        MeasurementService[] measurements = this.getMeasurements();
        int length = measurements.length;
        int i = 0;
        while (i < length) {
            measurements[i].addMeasurementListener((MeasurementListener)this);
            ++i;
        }
    }

    public void executeRead() {
        MeasurementService[] measurements = this.getMeasurements();
        int length = measurements.length;
        int i = 0;
        while (i < length) {
            measurements[i].executeRead();
            ++i;
        }
        super.executeRead();
    }

    public void executeWrite(Object value) {
        MeasurementService[] measurements = this.getMeasurements();
        int length = measurements.length;
        int i = 0;
        while (i < length) {
            measurements[i].executeWrite(value);
            ++i;
        }
        super.executeWrite(value);
    }

    public MeasurementService[] getMeasurements() {
        return this.measurements;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        MeasurementListener measurementListener = this.getMeasurementListener();
        if (measurementListener != null) {
            try {
                measurementListener.measurementChanged((MeasurementService)this, timestamp, newValue, oldValue);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public Object read(long timeout) throws RuntimeException {
        Object results = null;
        MeasurementService[] measurements = this.getMeasurements();
        int length = measurements.length;
        int i = 0;
        while (i < length) {
            results = measurements[i].read(timeout);
            ++i;
        }
        return results;
    }

    protected void setMeasurements(MeasurementService[] measurements) {
        this.measurements = measurements;
    }

    public void setValue(Object value) {
        Object timestamp = Measurements.getCurrentTimestamp();
        super.setValue(value, timestamp);
        MeasurementService[] measurements = this.getMeasurements();
        if (measurements != null) {
            int length = measurements.length;
            int i = 0;
            while (i < length) {
                measurements[i].setValue(value);
                ++i;
            }
        }
    }
}

