/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.profile.test.agent;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.test.agent.ProfileTestAgent;
import org.eclipse.soda.dk.testagent.framework.NotificationClientTestCase;
import org.eclipse.soda.dk.testagent.util.NotificationProbe;

public abstract class ProfileAbstractTestCase
extends NotificationClientTestCase {
    public static final char TOPIC_DELIMITER = '/';
    protected static final String EMPTY_STRING = "";
    public static final String STATUS_EXTERNAL_KEY = "/Status";
    public static final int DEFAULT_MAX_RESPONSE_WAITING_TIME = 2000;
    public static final int DEFAULT_MAX_STATUS_WAITING_TIME = 60000;
    protected String prefixProperty;
    protected int maxResponseWaitingTimeProperty;
    protected int maxStatusWaitingTimeProperty;

    protected ProfileAbstractTestCase(String name) {
        super(name);
    }

    public static String[] parseDelimitedByToken(String target, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(target, delimiter);
        String[] values = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            values[index++] = tokenizer.nextToken().trim();
        }
        return values;
    }

    public static byte[] parseHexSpaceDelimited(String spaceDelimitedHex) {
        StringTokenizer tokenizer = new StringTokenizer(spaceDelimitedHex);
        byte[] value = new byte[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String byteHex = tokenizer.nextToken();
            byte byteValue = 0;
            byteValue = (byte)Integer.parseInt(byteHex, 16);
            value[index++] = byteValue;
        }
        return value;
    }

    public static InterestService parseInterestMask(String maskConfig) {
        try {
            String[] configParam = ProfileAbstractTestCase.parseDelimitedByToken(maskConfig, ",");
            int offset = Integer.parseInt(configParam[1]);
            int length = Integer.parseInt(configParam[2]);
            byte[] pattern = ProfileAbstractTestCase.parseHexSpaceDelimited(configParam[3]);
            return new InterestMask(offset, length, pattern);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.valueOf(ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7400))) + maskConfig);
        }
    }

    public static byte[] toBytes(String string) throws RuntimeException {
        char[] characters = string.toCharArray();
        int length = characters.length + 1 >> 1;
        byte[] tag = new byte[length];
        int index = characters.length % 2;
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            int digit = character - 48;
            if (digit < 0) {
                throw new NumberFormatException();
            }
            if (digit > 9 && ((digit = character - 87) & 0xFFFFFFF0) != 0 && ((digit = character - 55) & 0xFFFFFFF0) != 0) {
                throw new NumberFormatException();
            }
            tag[index >> 1] = index % 2 == 0 ? (byte)(digit << 4) : (byte)((tag[index >> 1] & 0xF0) + digit);
            ++index;
            ++i;
        }
        return tag;
    }

    protected void executeCommand(String topicKey, String dataKey, Object dataValue) {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        ((Dictionary)data).put(dataKey, dataValue);
        this.broadcast(String.valueOf(topicKey) + "/execute", data);
    }

    protected void executeCommand(String topicKey, Object dataValue) {
        this.executeCommand(topicKey, "value", dataValue);
    }

    protected String[] getExternalKeys() {
        return new String[]{this.prependPrefix("*")};
    }

    protected void getKeysAndSettingsFromProperties() {
        this.prefixProperty = this.getString("prefix", EMPTY_STRING);
        this.maxResponseWaitingTimeProperty = this.getInt("max.response.waiting.ms", 2000);
        this.maxStatusWaitingTimeProperty = this.getInt("max.status.waiting.ms", 60000);
    }

    protected Object getMeasurement(String topicKey, String dataKey) throws InterruptedException {
        NotificationProbe probe = this.getProbe();
        probe.setMark();
        this.broadcast(String.valueOf(topicKey) + "/get", new Hashtable());
        ProfileAbstractTestCase.assertTrue((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7401)), (Object)topicKey), (boolean)probe.wasKeyPublished(topicKey, this.maxResponseWaitingTimeProperty));
        ProfileAbstractTestCase.assertFalse((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7402)), (Object)topicKey), (boolean)probe.wasKeyPublished(String.valueOf(topicKey) + "/error"));
        Object data = probe.getLastPublishedValue(topicKey, dataKey);
        probe.clearMark();
        return data;
    }

    protected Object getMeasurement(String topicKey) throws InterruptedException {
        return this.getMeasurement(topicKey, "value");
    }

    protected String prependPrefix(String topic) {
        if (this.prefixProperty.length() == 0) {
            return topic;
        }
        StringBuffer result = new StringBuffer(this.prefixProperty.length() + topic.length() + 1);
        result.append(this.prefixProperty);
        result.append('/');
        result.append(topic);
        return result.toString();
    }

    protected Object readMeasurement(String topicKey, String dataKey) throws InterruptedException {
        NotificationProbe probe = this.getProbe();
        probe.setMark();
        this.broadcast(String.valueOf(topicKey) + "/read", new Hashtable());
        ProfileAbstractTestCase.assertTrue((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7403)), (Object)topicKey), (boolean)probe.wasKeyPublished(topicKey, this.maxResponseWaitingTimeProperty));
        ProfileAbstractTestCase.assertFalse((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7404)), (Object)topicKey), (boolean)probe.wasKeyPublished(String.valueOf(topicKey) + "/error"));
        Object data = probe.getLastPublishedValue(topicKey, dataKey);
        probe.clearMark();
        return data;
    }

    protected Object readMeasurement(String topicKey) throws InterruptedException {
        return this.readMeasurement(topicKey, "value");
    }

    protected void reportMeasurement(String topicKey, String dataKey, Object dataValue) {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        ((Dictionary)data).put(dataKey, dataValue);
        this.broadcast(topicKey, data);
    }

    protected void reportMeasurement(String topicKey, Object dataValue) {
        this.reportMeasurement(topicKey, "value", dataValue);
    }

    protected void setUp() throws Exception {
        this.getContext().log(4, Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7405)), (Object)this.toString()));
        this.getKeysAndSettingsFromProperties();
        super.setUp();
    }

    protected void waitForProfileStart(String profileName) throws InterruptedException {
        this.waitForProfileState(profileName, 5);
    }

    protected void waitForProfileState(String profileName, int expectedState) throws InterruptedException {
        NotificationProbe probe = this.getProbe();
        String profileStatusTopic = this.prependPrefix(String.valueOf(profileName) + STATUS_EXTERNAL_KEY);
        Integer expectedStateData = new Integer(expectedState);
        Object stateData = null;
        probe.clear();
        this.broadcast(String.valueOf(profileStatusTopic) + "/get", new Hashtable());
        long now = System.currentTimeMillis();
        long limitTime = now + (long)this.maxStatusWaitingTimeProperty;
        while (!expectedStateData.equals(stateData) && now < limitTime) {
            Map value;
            int time = (int)(limitTime - now);
            if (probe.wasKeyPublished(profileStatusTopic, time) && (value = (Map)probe.getLastPublishedValue(profileStatusTopic, "value")) != null) {
                stateData = value.get("state");
            }
            probe.clear();
            now = System.currentTimeMillis();
        }
        ProfileAbstractTestCase.assertEquals((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7413)), (Object)profileName), (Object)expectedStateData, stateData);
    }

    protected int waitForSignal(String topicKey, int expectedCount, int duration) throws InterruptedException {
        NotificationProbe probe = this.getProbe();
        int count = probe.waitKeyPublished(topicKey, expectedCount, duration);
        ProfileAbstractTestCase.assertFalse((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7406)), (Object)topicKey), (boolean)probe.wasKeyPublished(String.valueOf(topicKey) + "/error"));
        return count;
    }

    protected void writeInvalidMeasurement(String topicKey, Object dataValue) throws InterruptedException {
        NotificationProbe probe = this.getProbe();
        Object dataValueOld = this.getMeasurement(topicKey);
        probe.setMark();
        this.writeMeasurement(topicKey, "value", dataValue);
        ProfileAbstractTestCase.assertTrue((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7407)), (Object)topicKey), (boolean)probe.wasKeyPublished(String.valueOf(topicKey) + "/error", this.maxResponseWaitingTimeProperty));
        probe.clearMark();
        probe.setMark();
        ProfileAbstractTestCase.assertEquals((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7408)), (Object)topicKey), (Object)dataValueOld, (Object)this.getMeasurement(topicKey));
        probe.clearMark();
    }

    protected void writeMeasurement(String topicKey, String dataKey, Object dataValue) {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        ((Dictionary)data).put(dataKey, dataValue);
        this.broadcast(String.valueOf(topicKey) + "/write", data);
    }

    protected void writeMeasurement(String topicKey, Object dataValue) throws InterruptedException {
        NotificationProbe probe = this.getProbe();
        Object dataValueOld = this.getMeasurement(topicKey);
        probe.setMark();
        this.writeMeasurement(topicKey, "value", dataValue);
        if (!dataValue.equals(dataValueOld)) {
            ProfileAbstractTestCase.assertTrue((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7409)), (Object)topicKey), (boolean)probe.wasKeyPublished(topicKey, this.maxResponseWaitingTimeProperty));
            ProfileAbstractTestCase.assertFalse((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7410)), (Object)topicKey), (boolean)probe.wasKeyPublished(String.valueOf(topicKey) + "/error"));
            Dictionary data = probe.getLastPublishedData(topicKey);
            ProfileAbstractTestCase.assertEquals((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7411)), (Object)topicKey), (Object)dataValue, data.get("value"));
            ProfileAbstractTestCase.assertEquals((String)Nls.format((String)ProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7412)), (Object)topicKey), (Object)dataValueOld, data.get("value_old"));
        }
        probe.clearMark();
    }
}

