/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.metadata.servlet;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;
import org.eclipse.soda.dk.metadata.servlet.DeviceMetadataServletContext;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class DeviceMetadataServlet
extends DeviceServlet
implements DeviceServletService,
Servlet {
    private static final long serialVersionUID = 4926120901389443395L;
    private int colorValue = 0xFFFFFF;
    private ConfigurationAdmin configurationAdmin = null;
    private MetaTypeService metaTypeService = null;

    public boolean changeConfiguration(Hashtable table, Hashtable oldTable) {
        ConfigurationAdmin configurationAdmin = this.getConfigurationAdmin();
        if (configurationAdmin != null) {
            Object factoryPid = oldTable.get("service.factoryPid");
            Object pid = oldTable.get("service.pid");
            if (pid != null && pid.toString().length() > 0) {
                try {
                    Configuration configuration = configurationAdmin.getConfiguration(pid.toString());
                    if (configuration != null) {
                        configuration.update((Dictionary)table);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (factoryPid != null) {
                try {
                    table.remove("service.pid");
                    table.remove("service.factoryPid");
                    Configuration configuration = configurationAdmin.createFactoryConfiguration(factoryPid.toString(), null);
                    if (configuration != null) {
                        configuration.update((Dictionary)table);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DeviceMetadataServletContext context = new DeviceMetadataServletContext(request, response, this.getServletAlias());
        context.saveMetaData(this.getBundles(), this.getMetaTypeService());
        return context;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DeviceServletContext context = this.createContext(request, response);
        this.setup(context);
        context.begin();
        Enumeration enumeration = request.getParameterNames();
        Hashtable<String, String> table = new Hashtable<String, String>();
        Hashtable<String, String> extraTable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            String key = String.valueOf(enumeration.nextElement());
            String value = request.getParameter(key);
            if (key.startsWith("_")) {
                extraTable.put(key, value);
                continue;
            }
            table.put(key, value);
        }
        Hashtable newTable = this.validateConfiguration(context, table);
        if (newTable != null) {
            this.changeConfiguration(newTable, table);
            context.template("updatebegin");
            this.processRequest(context);
        }
        context.template("end");
    }

    public int getColorValue() {
        return this.colorValue;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public Hashtable getConfigurationAttributes(AttributeDefinition[] attributeDefinitions) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        int i = 0;
        while (i < attributeDefinitions.length) {
            AttributeDefinition attributeDefinition = attributeDefinitions[i];
            String id = attributeDefinition.getID();
            String value = "";
            String[] defaultValue = attributeDefinition.getDefaultValue();
            if (defaultValue != null && defaultValue.length > 0) {
                value = defaultValue[0];
            }
            table.put(id, value);
            ++i;
        }
        return table;
    }

    public MetaTypeService getMetaTypeService() {
        return this.metaTypeService;
    }

    public AttributeDefinition processConfigurationAttributes(DeviceServletContext context, Dictionary properties, AttributeDefinition[] attributeDefinitions, boolean required) {
        AttributeDefinition specialAttributeDefinition = null;
        int i = 0;
        while (i < attributeDefinitions.length) {
            AttributeDefinition attributeDefinition = attributeDefinitions[i];
            String id = attributeDefinition.getID();
            CharSequence value = "";
            if (properties != null) {
                value = properties.get(id);
            } else {
                String[] defaultValue = attributeDefinition.getDefaultValue();
                if (defaultValue != null && defaultValue.length > 0) {
                    StringBuffer multi = new StringBuffer();
                    multi.append(defaultValue[0]);
                    if (defaultValue.length > 1) {
                        int j = 1;
                        while (j < defaultValue.length) {
                            multi.append(", ");
                            multi.append(defaultValue[j]);
                            ++j;
                        }
                    }
                    value = multi;
                }
            }
            if ("connection".equals(id) && "factory".equals(value)) {
                specialAttributeDefinition = attributeDefinition;
            }
            String name = context.formatData((Object)attributeDefinition.getName());
            context.addEntity("Name", (Object)name);
            context.addEntity("Required", (Object)String.valueOf(required));
            if (required) {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("<b>");
                context.formatData(buffer, (Object)name);
                buffer.append("</b>");
                context.addEntity("Label", (Object)buffer.toString());
            } else {
                context.addEntity("Label", (Object)name);
            }
            String description = "";
            try {
                description = attributeDefinition.getDescription();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            context.addEntity("Description", (Object)description);
            context.addEntity("Key", (Object)context.formatData((Object)id));
            context.addEntity("Value", (Object)context.formatData((Object)value));
            String[] labels = attributeDefinition.getOptionLabels();
            String[] values = attributeDefinition.getOptionValues();
            if (labels != null && values != null) {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("<select name=\"");
                buffer.append(context.formatData((Object)id));
                buffer.append("\" title=\"");
                buffer.append(attributeDefinition.getDescription());
                buffer.append("\">");
                int k = 0;
                while (k < values.length) {
                    String label = labels[k];
                    String svalue = values[k];
                    if (svalue.equals(value)) {
                        buffer.append("<option selected value=\"");
                    } else {
                        buffer.append("<option value=\"");
                    }
                    buffer.append(svalue);
                    buffer.append("\">");
                    buffer.append(label);
                    buffer.append("</option>");
                    ++k;
                }
                buffer.append("</select>");
                context.addEntity("ValueField", (Object)buffer.toString());
                context.template("configurationentry2");
            } else {
                context.template("configurationentry");
            }
            ++i;
        }
        return specialAttributeDefinition;
    }

    public void processFactory(DeviceMetadataServletContext context, MetaTypeProvider metaTypeProvider, String factoryPid) {
        String[] options;
        ObjectClassDefinition objectClassDefinition;
        AttributeDefinition sAttributeDefinitions = null;
        this.updateColorValue();
        context.addEntity("FactoryPid", factoryPid);
        String[] locales = metaTypeProvider.getLocales();
        int lindex = context.findBestLanguage(context.getLanguage(), locales);
        if (locales.length > 0 && (sAttributeDefinitions = this.processObjectClass(context, objectClassDefinition = metaTypeProvider.getObjectClassDefinition(factoryPid, locales[lindex]), null)) != null && (options = sAttributeDefinitions.getOptionValues()) != null) {
            int i = 0;
            while (i < options.length) {
                String option = options[i];
                if (!"factory".equals(option)) {
                    ObjectClassDefinition cobjectClassDefinition = (ObjectClassDefinition)context.getConnectionMetadata().get(option);
                    AttributeDefinition[] attributeDefinitions = objectClassDefinition.getAttributeDefinitions(-1);
                    Hashtable table = this.getConfigurationAttributes(attributeDefinitions);
                    this.processObjectClass(context, cobjectClassDefinition, table);
                }
                ++i;
            }
        }
    }

    public void processMetaData(DeviceMetadataServletContext context) {
        this.resetColorValue();
        MetaTypeService metaTypeService = this.getMetaTypeService();
        Hashtable<String, Bundle> allFactoryPidsTable = new Hashtable<String, Bundle>(100);
        Hashtable<String, Bundle> allPidsTable = new Hashtable<String, Bundle>(100);
        if (metaTypeService != null) {
            MetaTypeInformation metaTypeProvider;
            Bundle bundle;
            Bundle[] bundles = this.getBundles();
            int i = bundles.length - 1;
            while (i >= 0) {
                Bundle bundle2 = bundles[i];
                try {
                    String[] pids;
                    MetaTypeInformation metaTypeInformation = metaTypeService.getMetaTypeInformation(bundle2);
                    String[] factoryPids = metaTypeInformation.getFactoryPids();
                    if (factoryPids != null && factoryPids.length > 0) {
                        int j = 0;
                        while (j < factoryPids.length) {
                            allFactoryPidsTable.put(factoryPids[j], bundle2);
                            ++j;
                        }
                    }
                    if ((pids = metaTypeInformation.getPids()) != null && pids.length > 0) {
                        int j = 0;
                        while (j < pids.length) {
                            allPidsTable.put(pids[j], bundle2);
                            ++j;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.print(bundle2);
                    e.printStackTrace();
                }
                --i;
            }
            int size = allFactoryPidsTable.size();
            if (size > 0) {
                String[] allFactoryPids = new String[size];
                allFactoryPids = allFactoryPidsTable.keySet().toArray(allFactoryPids);
                context.sort(allFactoryPids);
                int i2 = 0;
                while (i2 < size) {
                    String factoryPid = allFactoryPids[i2];
                    bundle = (Bundle)allFactoryPidsTable.get(factoryPid);
                    if (factoryPid != null && factoryPid.length() > 0) {
                        Dictionary headers = bundle.getHeaders();
                        context.addEntities(headers);
                        try {
                            metaTypeProvider = metaTypeService.getMetaTypeInformation(bundle);
                            this.processFactory(context, (MetaTypeProvider)metaTypeProvider, factoryPid);
                        }
                        catch (Exception e) {
                            System.out.println(bundle);
                            e.printStackTrace();
                        }
                    }
                    ++i2;
                }
            }
            if ((size = allPidsTable.size()) > 0) {
                String[] allPids = new String[size];
                allPids = allPidsTable.keySet().toArray(allPids);
                context.sort(allPids);
                int i3 = 0;
                while (i3 < size) {
                    String pid = allPids[i3];
                    bundle = (Bundle)allPidsTable.get(pid);
                    if (pid != null && pid.length() > 0) {
                        try {
                            ObjectClassDefinition objectClassDefinition;
                            Dictionary headers = bundle.getHeaders();
                            context.addEntities(headers);
                            context.addEntity("Pid", pid);
                            metaTypeProvider = metaTypeService.getMetaTypeInformation(bundle);
                            String[] locales = metaTypeProvider.getLocales();
                            int lindex = context.findBestLanguage(context.getLanguage(), locales);
                            if (locales.length > 0 && (objectClassDefinition = metaTypeProvider.getObjectClassDefinition(pid, locales[lindex])) != null) {
                                String objectName = objectClassDefinition.getName();
                                context.addEntity("ObjectName", context.formatData(objectName));
                                String objectDescription = objectClassDefinition.getDescription();
                                context.addEntity("ObjectDescription", context.formatData(objectDescription));
                                context.template("metabegin");
                                AttributeDefinition[] attributeDefinitions = objectClassDefinition.getAttributeDefinitions(1);
                                this.processConfigurationAttributes(context, null, attributeDefinitions, true);
                                attributeDefinitions = objectClassDefinition.getAttributeDefinitions(2);
                                this.processConfigurationAttributes(context, null, attributeDefinitions, false);
                                context.template("metaend");
                            }
                        }
                        catch (Exception e) {
                            System.out.println(bundle);
                            e.printStackTrace();
                        }
                    }
                    ++i3;
                }
            }
        }
    }

    public AttributeDefinition processObjectClass(DeviceMetadataServletContext context, ObjectClassDefinition objectClassDefinition, Dictionary properties) {
        AttributeDefinition sAttributeDefinitions = null;
        if (objectClassDefinition != null) {
            String objectName = objectClassDefinition.getName();
            context.addEntity("Color", Integer.toHexString(this.getColorValue()));
            context.addEntity("ObjectName", context.formatData(objectName));
            String objectDescription = objectClassDefinition.getDescription();
            context.addEntity("ObjectDescription", context.formatData(objectDescription));
            context.template("metafactorybegin");
            AttributeDefinition[] attributeDefinitions = objectClassDefinition.getAttributeDefinitions(1);
            this.processConfigurationAttributes(context, properties, attributeDefinitions, true);
            attributeDefinitions = objectClassDefinition.getAttributeDefinitions(2);
            sAttributeDefinitions = this.processConfigurationAttributes(context, properties, attributeDefinitions, false);
            context.template("metafactoryend");
        }
        return sAttributeDefinitions;
    }

    public void processRequest(DeviceServletContext context) {
        this.processMetaData((DeviceMetadataServletContext)context);
    }

    public void resetColorValue() {
        this.colorValue = 0xFFFFFF;
    }

    public void setColorValue(int colorValue) {
        this.colorValue = colorValue;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setMetaTypeService(MetaTypeService metaTypeService) {
        this.metaTypeService = metaTypeService;
    }

    public void updateColorValue() {
        this.colorValue -= 526344;
        if (this.colorValue == 0x808080) {
            this.colorValue = 0xFFFFFF;
        }
    }

    public Hashtable validateConfiguration(DeviceServletContext context, Hashtable table) {
        Hashtable result = new Hashtable();
        boolean status = true;
        Object factoryPid = table.get("service.factoryPid");
        Object pid = table.get("service.pid");
        Object object = null;
        String id = String.valueOf(pid);
        if (factoryPid != null) {
            id = String.valueOf(factoryPid);
            object = context.getFactoryMetadata().get(id);
        } else {
            object = context.getPidMetadata().get(id);
        }
        if (object instanceof ObjectClassDefinition) {
            ObjectClassDefinition objectClassDefinition = object;
            AttributeDefinition[] attributeDefinitions = objectClassDefinition.getAttributeDefinitions(-1);
            int i = 0;
            while (i < attributeDefinitions.length) {
                AttributeDefinition attributeDefinition = attributeDefinitions[i];
                String aid = attributeDefinition.getID();
                Object value = table.get(aid);
                if (value != null) {
                    String message = attributeDefinition.validate(value.toString());
                    if (message != null && message.length() > 0) {
                        if (status) {
                            context.template("errorbegin");
                        }
                        context.addEntity("Name", (Object)context.formatData((Object)attributeDefinition.getName()));
                        context.addEntity("Value", (Object)context.formatData(value));
                        context.addEntity("Message", (Object)message);
                        context.template("errorentry");
                        status = false;
                    } else {
                        result.put(aid, value);
                    }
                }
                ++i;
            }
        }
        if (status) {
            return result;
        }
        context.template("errorend");
        return null;
    }
}

