/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.metadata.servlet;

import java.io.InputStream;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class DeviceMetadataServletContext
extends DeviceServletContext {
    public static final String CONNECTION_FACTORY_NAME = "ConnectionFactory";
    public static final int CONNECTION_FACTORY_NAME_LENGTH = "ConnectionFactory".length();
    private Hashtable connectionMetadata = new Hashtable();

    public DeviceMetadataServletContext(HttpServletRequest request, HttpServletResponse response, String serverAlias) {
        super(request, response, serverAlias);
    }

    public Hashtable getConnectionMetadata() {
        return this.connectionMetadata;
    }

    public void saveMetaData(Bundle[] bundles, MetaTypeService metaTypeService) {
        if (metaTypeService != null) {
            int i = bundles.length - 1;
            while (i >= 0) {
                Bundle bundle = bundles[i];
                try {
                    MetaTypeInformation metaTypeInformation = metaTypeService.getMetaTypeInformation(bundle);
                    String[] factoryPids = metaTypeInformation.getFactoryPids();
                    int j = 0;
                    while (j < factoryPids.length) {
                        String factoryPid;
                        ObjectClassDefinition objectClassDefinition;
                        MetaTypeInformation metaTypeProvider = metaTypeInformation;
                        String[] locales = metaTypeProvider.getLocales();
                        int lindex = this.findBestLanguage(this.getLanguage(), locales);
                        if (locales.length > 0 && (objectClassDefinition = metaTypeProvider.getObjectClassDefinition(factoryPid = factoryPids[j], locales[lindex])) != null) {
                            this.getFactoryMetadata().put(factoryPid, objectClassDefinition);
                            if (factoryPid.endsWith(CONNECTION_FACTORY_NAME)) {
                                int lastindex = factoryPid.lastIndexOf(46);
                                String connectionId = factoryPid.substring(lastindex + 1, factoryPid.length() - CONNECTION_FACTORY_NAME_LENGTH).toLowerCase();
                                this.getConnectionMetadata().put(connectionId, objectClassDefinition);
                            }
                        }
                        ++j;
                    }
                    String[] pids = metaTypeInformation.getPids();
                    int j2 = 0;
                    while (j2 < pids.length) {
                        String pid;
                        ObjectClassDefinition objectClassDefinition;
                        MetaTypeInformation metaTypeProvider = metaTypeInformation;
                        String[] locales = metaTypeProvider.getLocales();
                        int lindex = this.findBestLanguage(this.getLanguage(), locales);
                        if (locales.length > 0 && (objectClassDefinition = metaTypeProvider.getObjectClassDefinition(pid = pids[j2], locales[lindex])) != null) {
                            this.getPidMetadata().put(pid, objectClassDefinition);
                        }
                        ++j2;
                    }
                }
                catch (Exception exception) {}
                --i;
            }
        }
    }

    public void setConnectionMetadata(Hashtable connectionMetadata) {
        this.connectionMetadata = connectionMetadata;
    }

    public InputStream templateInputStream(String name) {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (is == null) {
            return super.templateInputStream(name);
        }
        return is;
    }
}

