/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.internal;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.sat.plugin.ui.internal.ImageDetail;
import org.eclipse.soda.sat.plugin.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.IImageManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ImageManager
implements IImageManager {
    private static final String ILLEGAL_IMAGE_NAME_KEY = "ImageManager.IllegalImageName";
    private static final String IMAGE_NOT_FOUND = "ImageManager.ImageNotFound";
    private static final String IMAGE_EXTENSION = ".gif";
    private boolean disposed;
    private Map map;
    private Image errorImage;

    public ImageManager(int size) {
        this.setMap(new HashMap(size));
        this.setDisposed(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String id, URL url) {
        Map map = this.getMap();
        ImageManager imageManager = this;
        synchronized (imageManager) {
            this.checkNotDisposed();
            boolean exists = map.containsKey(id);
            if (exists) {
                return;
            }
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            ImageDetail details = new ImageDetail(descriptor);
            map.put(id, details);
        }
    }

    private Image basicGetErrorImage() {
        return this.errorImage;
    }

    private void checkImageDetails(String id, ImageDetail details) {
        if (details != null) {
            return;
        }
        Activator activator = Activator.getDefault();
        String pattern = Messages.getString(IMAGE_NOT_FOUND);
        Object[] values = new Object[]{id};
        String message = MessageFormat.format(pattern, values);
        activator.log(4, message);
    }

    private void checkImageName(String name) {
        boolean isPhysicalName = name.endsWith(IMAGE_EXTENSION);
        if (!isPhysicalName) {
            return;
        }
        String pattern = Messages.getString(ILLEGAL_IMAGE_NAME_KEY);
        Object[] values = new Object[]{name};
        String message = MessageFormat.format(pattern, values);
        throw new IllegalArgumentException(message);
    }

    private void checkNotDisposed() {
        boolean disposed = this.isDisposed();
        if (!disposed) {
            return;
        }
        throw new RuntimeException("Disposed");
    }

    private Image createErrorImage() {
        int width = 6;
        int height = 6;
        int depth = 1;
        RGB red = new RGB(255, 0, 0);
        RGB[] rgb = new RGB[]{red};
        PaletteData palette = new PaletteData(rgb);
        ImageData data = new ImageData(width, height, depth, palette);
        Display device = Display.getCurrent();
        Image image = new Image((Device)device, data);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ImageManager imageManager = this;
        synchronized (imageManager) {
            this.checkNotDisposed();
            this.setDisposed(true);
            this.disposeImages();
            this.disposeErrorImage();
        }
    }

    private void disposeErrorImage() {
        Image image = this.basicGetErrorImage();
        if (image == null) {
            return;
        }
        image.dispose();
        this.setErrorImage(null);
    }

    private void disposeImages() {
        Map map = this.getMap();
        Collection values = map.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            ImageDetail details = (ImageDetail)iterator.next();
            details.dispose();
        }
        this.setMap(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getErrorImage() {
        ImageManager imageManager = this;
        synchronized (imageManager) {
            if (this.errorImage == null) {
                Image image = this.createErrorImage();
                this.setErrorImage(image);
            }
        }
        return this.errorImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String id) {
        Image image;
        this.checkImageName(id);
        ImageManager imageManager = this;
        synchronized (imageManager) {
            this.checkNotDisposed();
            ImageDetail details = this.getImageDetails(id);
            image = details != null ? details.getImage() : this.getErrorImage();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDescriptor getImageDescriptor(String id) {
        ImageDescriptor descriptor;
        this.checkImageName(id);
        ImageManager imageManager = this;
        synchronized (imageManager) {
            this.checkNotDisposed();
            ImageDetail details = this.getImageDetails(id);
            descriptor = details != null ? details.getDescriptor() : null;
        }
        return descriptor;
    }

    private ImageDetail getImageDetails(String id) {
        Map map = this.getMap();
        ImageDetail details = (ImageDetail)map.get(id);
        this.checkImageDetails(id, details);
        return details;
    }

    private List getKeys() {
        Map map = this.getMap();
        Set keys = map.keySet();
        ArrayList list = new ArrayList(keys);
        Collections.sort(list);
        return list;
    }

    private Map getMap() {
        return this.map;
    }

    private boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        Map map = this.getMap();
        ImageManager imageManager = this;
        synchronized (imageManager) {
            this.checkNotDisposed();
            map.remove(id);
        }
    }

    private void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    private void setErrorImage(Image errorImage) {
        this.errorImage = errorImage;
    }

    private void setMap(Map map) {
        this.map = map;
    }

    public String toString() {
        String value = super.toString();
        boolean disposed = this.isDisposed();
        List keys = this.getKeys();
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(value);
        buffer.append(", disposed=");
        buffer.append(disposed);
        buffer.append(" keys=");
        buffer.append(keys);
        String result = buffer.toString();
        return result;
    }
}

