/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class SwtDebugUtility {
    private static final Color[] COLORS = new Color[]{SwtDebugUtility.getSystemColor(3), SwtDebugUtility.getSystemColor(9), SwtDebugUtility.getSystemColor(7), SwtDebugUtility.getSystemColor(5), SwtDebugUtility.getSystemColor(13), SwtDebugUtility.getSystemColor(11), SwtDebugUtility.getSystemColor(4), SwtDebugUtility.getSystemColor(10), SwtDebugUtility.getSystemColor(8), SwtDebugUtility.getSystemColor(6), SwtDebugUtility.getSystemColor(14), SwtDebugUtility.getSystemColor(12)};
    private static final SwtDebugUtility INSTANCE = new SwtDebugUtility();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private StringBuffer buffer;

    public static SwtDebugUtility getInstance() {
        return INSTANCE;
    }

    private static Color getSystemColor(int id) {
        Display device = Display.getDefault();
        Color color = device.getSystemColor(id);
        return color;
    }

    public static void setBackground(Control control, int id) {
        Color color = SwtDebugUtility.getSystemColor(id);
        control.setBackground(color);
    }

    private SwtDebugUtility() {
        this.setBuffer(new StringBuffer(1000));
    }

    private void createCompositeToolTip(Composite composite) {
        StringBuffer buffer = this.getBuffer();
        Layout layout = composite.getLayout();
        buffer.append(LINE_SEPARATOR);
        buffer.append("  layout=");
        buffer.append(layout);
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            this.createGridLayoutToolTip(gridLayout);
        } else if (layout instanceof FormLayout) {
            FormLayout formLayout = (FormLayout)layout;
            this.createFormLayoutToolTip(formLayout);
        } else if (layout instanceof FillLayout) {
            FillLayout fillLayout = (FillLayout)layout;
            this.createFillLayoutToolTip(fillLayout);
        } else if (layout instanceof RowLayout) {
            RowLayout rowLayout = (RowLayout)layout;
            this.createRowLayoutToolTip(rowLayout);
        }
    }

    private void createFillLayoutToolTip(FillLayout layout) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(LINE_SEPARATOR);
        buffer.append("    type=");
        buffer.append(layout.type);
        buffer.append(" (");
        buffer.append(this.getLayoutTypeText(layout.type));
        buffer.append(')');
    }

    private void createFormDataToolTip(FormData data) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(LINE_SEPARATOR);
        buffer.append("    bottom=");
        buffer.append(data.bottom);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    height=");
        buffer.append(data.height);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    left=");
        buffer.append(data.left);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    right=");
        buffer.append(data.right);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    top=");
        buffer.append(data.top);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    width=");
        buffer.append(data.width);
    }

    private void createFormLayoutToolTip(FormLayout layout) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginHeight=");
        buffer.append(layout.marginHeight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginWidth=");
        buffer.append(layout.marginWidth);
    }

    private void createGridDataToolTip(GridData gridData) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(LINE_SEPARATOR);
        buffer.append("    grabExcessHorizontalSpace=");
        buffer.append(gridData.grabExcessHorizontalSpace);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    grabExcessVerticalSpace=");
        buffer.append(gridData.grabExcessVerticalSpace);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    heightHint=");
        buffer.append(gridData.heightHint);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    horizontalAlignment=");
        buffer.append(this.getAlignmentText(gridData.horizontalAlignment));
        buffer.append(LINE_SEPARATOR);
        buffer.append("    horizontalIndent=");
        buffer.append(gridData.horizontalIndent);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    horizontalSpan=");
        buffer.append(gridData.horizontalSpan);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    verticalAlignment=");
        buffer.append(this.getAlignmentText(gridData.verticalAlignment));
        buffer.append(LINE_SEPARATOR);
        buffer.append("    verticalSpan=");
        buffer.append(gridData.verticalSpan);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    widthHint=");
        buffer.append(gridData.widthHint);
    }

    private void createGridLayoutToolTip(GridLayout layout) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(LINE_SEPARATOR);
        buffer.append("    horizontalSpacing=");
        buffer.append(layout.horizontalSpacing);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    makeColumnsEqualWidth=");
        buffer.append(layout.makeColumnsEqualWidth);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginHeight=");
        buffer.append(layout.marginHeight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginWidth=");
        buffer.append(layout.marginWidth);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    numColumns=");
        buffer.append(layout.numColumns);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    verticalSpacing=");
        buffer.append(layout.verticalSpacing);
    }

    private void createRowDataToolTip(RowData data) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(LINE_SEPARATOR);
        buffer.append("    height=");
        buffer.append(data.height);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    width=");
        buffer.append(data.width);
    }

    private void createRowLayoutToolTip(RowLayout layout) {
        StringBuffer buffer = this.getBuffer();
        buffer.append(LINE_SEPARATOR);
        buffer.append("    justify=");
        buffer.append(layout.justify);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginBottom=");
        buffer.append(layout.marginBottom);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginLeft=");
        buffer.append(layout.marginLeft);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginRight=");
        buffer.append(layout.marginRight);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    marginTop=");
        buffer.append(layout.marginTop);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    pack=");
        buffer.append(layout.pack);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    spacing=");
        buffer.append(layout.spacing);
        buffer.append(LINE_SEPARATOR);
        buffer.append("    type=");
        buffer.append(layout.type);
        buffer.append(" (");
        buffer.append(this.getLayoutTypeText(layout.type));
        buffer.append(')');
        buffer.append(LINE_SEPARATOR);
        buffer.append("    wrap=");
        buffer.append(layout.wrap);
    }

    private void createToolTip(Control control, int childIndex) {
        if (childIndex != 0) {
            this.buffer.append(childIndex);
            this.buffer.append(". ");
        }
        this.buffer.append(control);
        this.buffer.append(this.getHashCodeText(control));
        if (childIndex != 0) {
            this.buffer.append(LINE_SEPARATOR);
            this.buffer.append("  parent=");
            Composite parent = control.getParent();
            this.buffer.append(parent);
            this.buffer.append(this.getHashCodeText(parent));
        }
        this.buffer.append(LINE_SEPARATOR);
        this.buffer.append("  border width=");
        this.buffer.append(control.getBorderWidth());
        this.buffer.append(LINE_SEPARATOR);
        this.buffer.append("  bounds=");
        this.buffer.append(control.getBounds());
        this.buffer.append(LINE_SEPARATOR);
        this.buffer.append("  data=");
        this.buffer.append(control.getData());
        this.buffer.append(LINE_SEPARATOR);
        this.buffer.append("  font=");
        Font font = control.getFont();
        FontData[] fontData = font.getFontData();
        this.buffer.append(fontData[0]);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            this.createCompositeToolTip(composite);
        }
        Object layoutData = control.getLayoutData();
        this.buffer.append(LINE_SEPARATOR);
        this.buffer.append("  layout data=");
        this.buffer.append(layoutData);
        if (layoutData != null) {
            if (layoutData instanceof GridData) {
                GridData gridData = (GridData)layoutData;
                this.createGridDataToolTip(gridData);
            } else if (layoutData instanceof FormData) {
                FormData formData = (FormData)layoutData;
                this.createFormDataToolTip(formData);
            } else if (layoutData instanceof RowData) {
                RowData rowData = (RowData)layoutData;
                this.createRowDataToolTip(rowData);
            } else {
                this.buffer.append(layoutData);
            }
        }
        this.buffer.append(LINE_SEPARATOR);
        this.buffer.append("  size=");
        this.buffer.append(control.getSize());
        this.buffer.append(LINE_SEPARATOR);
        this.buffer.append("  style=");
        this.buffer.append(control.getStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decorate(Control control) {
        if (control == null) {
            throw new IllegalArgumentException("Control may not be null");
        }
        SwtDebugUtility swtDebugUtility = this;
        synchronized (swtDebugUtility) {
            this.decorate(control, 0, 0);
        }
    }

    private void decorate(Control control, int colorIndex, int childIndex) {
        int count = COLORS.length;
        int index = colorIndex == count ? 0 : colorIndex;
        Color color = COLORS[index];
        control.setBackground(color);
        this.createToolTip(control, childIndex);
        String tip = this.getBufferValue();
        control.setToolTipText(tip);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                this.decorate(child, index + 1, i + 1);
                ++i;
            }
        }
    }

    private String getAlignmentText(int alignment) {
        String text = null;
        switch (alignment) {
            case 1: {
                text = "GridData.BEGINNING";
                break;
            }
            case 2: {
                text = "GridData.CENTER";
                break;
            }
            case 3: {
                text = "GridData.END";
                break;
            }
            case 4: {
                text = "GridData.FILL";
                break;
            }
            default: {
                text = Integer.toString(alignment);
            }
        }
        return text;
    }

    private StringBuffer getBuffer() {
        return this.buffer;
    }

    private String getBufferValue() {
        StringBuffer buffer = this.getBuffer();
        String value = buffer.toString();
        buffer.setLength(0);
        return value;
    }

    private String getHashCodeText(Object object) {
        long hashCode = object.hashCode();
        String hexString = Long.toHexString(hashCode);
        StringBuffer buffer = new StringBuffer(15);
        buffer.append('(');
        buffer.append(hexString);
        buffer.append(')');
        String result = buffer.toString();
        return result;
    }

    private String getLayoutTypeText(int type) {
        String text;
        switch (type) {
            case 256: {
                text = "SWT.HORIZONTAL";
                break;
            }
            case 512: {
                text = "SWT.VERTICAL";
                break;
            }
            default: {
                text = Integer.toString(type);
            }
        }
        return text;
    }

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }
}

